/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.repository;

import io.ballerina.runtime.api.repository.Artifact;
import io.ballerina.runtime.api.repository.Node;
import io.ballerina.runtime.api.repository.Repository;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.internal.types.BServiceType;
import io.ballerina.runtime.internal.values.ObjectValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class RepositoryImpl
implements Repository {
    private static final Map<ObjectValue, ObjectValue> serviceListenerMap = new HashMap<ObjectValue, ObjectValue>();
    private static final Map<ObjectValue, ObjectValue> listenerServiceMap = new HashMap<ObjectValue, ObjectValue>();
    private static final String nodeId = RepositoryImpl.generateNodeId();
    private static String balHome;
    private static String balVersion;
    private static boolean isRemoteManagementEnabled;

    @Override
    public List<Artifact> getArtifacts() {
        Artifact artifact;
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (Map.Entry<ObjectValue, ObjectValue> entry : serviceListenerMap.entrySet()) {
            ObjectValue service = entry.getKey();
            ObjectValue listener = entry.getValue();
            artifact = this.createArtifact(service, listener);
            artifacts.add(artifact);
        }
        for (Map.Entry<ObjectValue, ObjectValue> entry : listenerServiceMap.entrySet()) {
            ObjectValue listener = entry.getKey();
            ObjectValue service = entry.getValue();
            if (serviceListenerMap.containsKey(service)) continue;
            artifact = this.createArtifact(service, listener);
            artifacts.add(artifact);
        }
        return artifacts;
    }

    @Override
    public Node getNode() {
        return new NodeImpl(nodeId, balVersion, balHome, System.getProperty("os.name"), System.getProperty("os.version"));
    }

    @Override
    public boolean isRemoteManagementEnabled() {
        return isRemoteManagementEnabled;
    }

    private Artifact createArtifact(ObjectValue service, ObjectValue listener) {
        ArtifactImpl artifact = new ArtifactImpl(service.toString(), Artifact.ArtifactType.SERVICE);
        ArrayList<ObjectValue> listeners = (ArrayList<ObjectValue>)artifact.getDetail("listeners");
        if (listeners == null) {
            listeners = new ArrayList<ObjectValue>();
            artifact.addDetail("listeners", listeners);
        }
        listeners.add(listener);
        BServiceType serviceType = (BServiceType)TypeUtils.getImpliedType(service.getOriginalType());
        artifact.addDetail("attachPoint", serviceType.attachPoint);
        artifact.addDetail("service", service);
        return artifact;
    }

    public static void addServiceListener(BObject listener, BObject service, Object attachPoint) {
        if (!isRemoteManagementEnabled) {
            return;
        }
        BServiceType serviceType = (BServiceType)service.getType();
        serviceType.attachPoint = attachPoint;
        serviceListenerMap.put((ObjectValue)service, (ObjectValue)listener);
        listenerServiceMap.put((ObjectValue)listener, (ObjectValue)service);
    }

    public static void addBallerinaRuntimeInformation(String balHome, String balVersion, boolean isRemoteManagementEnabled) {
        RepositoryImpl.balHome = balHome;
        RepositoryImpl.balVersion = balVersion;
        RepositoryImpl.isRemoteManagementEnabled = isRemoteManagementEnabled;
    }

    private static String generateNodeId() {
        return UUID.randomUUID().toString();
    }

    static {
        isRemoteManagementEnabled = false;
    }

    private static class NodeImpl
    extends Node {
        private final Map<String, Object> details = new HashMap<String, Object>();

        public NodeImpl(String nodeId, String balVersion, String balHome, String osName, String osVersion) {
            super(nodeId);
            this.details.put("balVersion", balVersion);
            this.details.put("balHome", balHome);
            this.details.put("osName", osName);
            this.details.put("osVersion", osVersion);
        }

        @Override
        public Object getDetail(String detailKey) {
            return this.details.getOrDefault(detailKey, null);
        }

        @Override
        public Map<String, Object> getAllDetails() {
            return Collections.unmodifiableMap(this.details);
        }
    }

    private static class ArtifactImpl
    extends Artifact {
        private final Map<String, Object> details = new HashMap<String, Object>();

        public ArtifactImpl(String name, Artifact.ArtifactType type) {
            super(name, type);
        }

        private void addDetail(String detailsKey, Object value) {
            this.details.put(detailsKey, value);
        }

        @Override
        public Object getDetail(String detailKey) {
            return this.details.getOrDefault(detailKey, null);
        }

        @Override
        public Map<String, Object> getAllDetails() {
            return Collections.unmodifiableMap(this.details);
        }
    }
}

