/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.scheduling;

import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.internal.scheduling.AsyncUtils;
import io.ballerina.runtime.internal.utils.ErrorUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;

public class WorkerChannel {
    private final String name;
    private final AtomicInteger doneCount;
    private final CompletableFuture<Object> resultFuture;
    private final CompletableFuture<Object> receiveFuture;
    private boolean cancel;

    public WorkerChannel(String name) {
        this.name = name;
        this.resultFuture = new CompletableFuture();
        this.receiveFuture = new CompletableFuture();
        this.doneCount = new AtomicInteger(2);
        this.cancel = false;
    }

    public Object read() {
        if (this.cancel) {
            throw ErrorUtils.createCancelledFutureError();
        }
        try {
            Object object = AsyncUtils.getFutureResult(this.resultFuture);
            return object;
        }
        finally {
            this.receiveFuture.complete(null);
        }
    }

    public void write(Object result) {
        if (this.cancel) {
            throw ErrorUtils.createCancelledFutureError();
        }
        this.resultFuture.complete(result);
    }

    public void panicOnSend(BError error) {
        if (this.resultFuture.isDone()) {
            return;
        }
        this.resultFuture.completeExceptionally(error);
    }

    public void panicOnReceive(BError error) {
        if (this.receiveFuture.isDone()) {
            return;
        }
        this.receiveFuture.completeExceptionally(error);
    }

    public void errorOnSend(String channelKey, Object returnValue) {
        BError error;
        if (this.resultFuture.isDone()) {
            return;
        }
        BError bError = returnValue instanceof BError ? (error = (BError)returnValue) : ErrorUtils.createNoMessageError(channelKey);
        this.resultFuture.complete(bError);
    }

    public void errorOnReceive(String channelKey, Object returnValue) {
        BError error;
        if (this.receiveFuture.isDone()) {
            return;
        }
        BError bError = returnValue instanceof BError ? (error = (BError)returnValue) : ErrorUtils.createNoMessageError(channelKey);
        this.receiveFuture.complete(bError);
    }

    public boolean isWritten() {
        return this.resultFuture.isDone();
    }

    public boolean isReceived() {
        return this.receiveFuture.isDone();
    }

    public boolean done() {
        return this.doneCount.incrementAndGet() == 0;
    }

    public void cancel() {
        this.cancel = true;
    }

    public String getName() {
        return this.name;
    }

    public CompletableFuture<Object> getResultFuture() {
        return this.resultFuture;
    }

    public CompletableFuture<Object> getReceiveFuture() {
        return this.receiveFuture;
    }
}

