/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types.semtype;

import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Env;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.internal.types.semtype.CellAtomicType;
import io.ballerina.runtime.internal.types.semtype.ListDefinition;

public final class FunctionQualifiers {
    private static final FunctionQualifiers DEFAULT = new FunctionQualifiers(false, false);
    private final boolean isolated;
    private final boolean transactional;
    private SemType semType;

    private FunctionQualifiers(boolean isolated, boolean transactional) {
        this.isolated = isolated;
        this.transactional = transactional;
    }

    public static FunctionQualifiers create(boolean isolated, boolean transactional) {
        if (!isolated && !transactional) {
            return DEFAULT;
        }
        return new FunctionQualifiers(isolated, transactional);
    }

    synchronized SemType toSemType(Env env) {
        if (this.semType == null) {
            ListDefinition ld = new ListDefinition();
            SemType[] members = new SemType[]{this.isolated ? Builder.getBooleanConst(true) : Builder.getBooleanType(), this.transactional ? Builder.getBooleanType() : Builder.getBooleanConst(false)};
            this.semType = ld.defineListTypeWrapped(env, members, 2, Builder.getNeverType(), CellAtomicType.CellMutability.CELL_MUT_NONE);
        }
        return this.semType;
    }

    public boolean isolated() {
        return this.isolated;
    }

    public boolean transactional() {
        return this.transactional;
    }

    public String toString() {
        return "FunctionQualifiers[isolated=" + this.isolated + ", transactional=" + this.transactional + "]";
    }
}

