/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.utils;

import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.ResourceMethodType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.scheduling.Scheduler;
import io.ballerina.runtime.internal.scheduling.Strand;
import io.ballerina.runtime.internal.types.BAnnotatableType;
import io.ballerina.runtime.internal.types.BMethodType;
import io.ballerina.runtime.internal.types.BNetworkObjectType;
import io.ballerina.runtime.internal.types.BObjectType;
import io.ballerina.runtime.internal.types.BServiceType;
import io.ballerina.runtime.internal.values.FPValue;
import io.ballerina.runtime.internal.values.MapValue;

public final class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static void processAnnotations(MapValue<BString, Object> globalAnnotMap, Type bType) {
        if (!(bType instanceof BAnnotatableType)) {
            return;
        }
        BAnnotatableType type = (BAnnotatableType)bType;
        BString annotationKey = StringUtils.fromString(type.getAnnotationKey());
        if (globalAnnotMap.containsKey(annotationKey)) {
            type.setAnnotations((MapValue)globalAnnotMap.get(annotationKey));
        }
        if (type.getTag() == 53) {
            Type impliedType = TypeUtils.getImpliedType(type);
            if (AnnotationUtils.isNonObjectType(impliedType.getTag())) {
                return;
            }
            type = (BAnnotatableType)impliedType;
        } else if (AnnotationUtils.isNonObjectType(type.getTag())) {
            return;
        }
        BObjectType objectType = (BObjectType)type;
        for (MethodType attachedFunction : objectType.getMethods()) {
            annotationKey = StringUtils.fromString(attachedFunction.getAnnotationKey());
            AnnotationUtils.setMethodAnnotations(globalAnnotMap, annotationKey, (BMethodType)attachedFunction);
        }
        if (type.getTag() == 31 || (objectType.flags & 0x10000L) == 65536L) {
            BNetworkObjectType serviceType = (BNetworkObjectType)type;
            for (ResourceMethodType resourceMethod : serviceType.getResourceMethods()) {
                annotationKey = StringUtils.fromString(resourceMethod.getAnnotationKey());
                AnnotationUtils.setMethodAnnotations(globalAnnotMap, annotationKey, (BMethodType)((Object)resourceMethod));
            }
        }
    }

    private static boolean isNonObjectType(int impliedTypeTag) {
        return impliedTypeTag != 47 && impliedTypeTag != 31;
    }

    private static void setMethodAnnotations(MapValue<BString, Object> globalAnnotMap, BString annotationKey, BMethodType resourceMethod) {
        if (globalAnnotMap.containsKey(annotationKey)) {
            resourceMethod.setAnnotations((MapValue)globalAnnotMap.get(annotationKey));
        }
    }

    public static void processObjectCtorAnnotations(BObjectType bType, MapValue<BString, Object> globalAnnotMap, Strand strand) {
        BString annotationKey = StringUtils.fromString(bType.getAnnotationKey());
        if (globalAnnotMap.containsKey(annotationKey)) {
            Object v = globalAnnotMap.get(annotationKey);
            Object annotValue = ((FPValue)v).call(Scheduler.getStrand().scheduler.runtime, new Object[0]);
            bType.setAnnotations((MapValue)annotValue);
        }
        for (MethodType attachedFunction : bType.getMethods()) {
            AnnotationUtils.processObjectMethodLambdaAnnotation(globalAnnotMap, strand, attachedFunction);
        }
        if (bType instanceof BServiceType) {
            BServiceType bServiceType = (BServiceType)bType;
            for (ResourceMethodType resourceFunction : bServiceType.getResourceMethods()) {
                AnnotationUtils.processObjectMethodLambdaAnnotation(globalAnnotMap, strand, resourceFunction);
            }
        }
    }

    private static void processObjectMethodLambdaAnnotation(MapValue<BString, Object> globalAnnotMap, Strand strand, MethodType attachedFunction) {
        BString annotationKey = StringUtils.fromString(attachedFunction.getAnnotationKey());
        if (globalAnnotMap.containsKey(annotationKey)) {
            ((BMethodType)attachedFunction).setAnnotations((MapValue)((FPValue)globalAnnotMap.get(annotationKey)).call(Scheduler.getStrand().scheduler.runtime, new Object[0]));
        }
    }

    public static void processFPValueAnnotations(FPValue fpValue, MapValue<BString, Object> globalAnnotMap, String name) {
        BAnnotatableType type = (BAnnotatableType)fpValue.getType();
        BString nameKey = StringUtils.fromString(name);
        if (globalAnnotMap.containsKey(nameKey)) {
            type.setAnnotations((MapValue)globalAnnotMap.get(nameKey));
        }
    }
}

