/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.observability;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.configurable.ConfigMap;
import io.ballerina.runtime.internal.configurable.VariableKey;
import io.ballerina.runtime.internal.values.ErrorValue;
import io.ballerina.runtime.observability.BallerinaObserver;
import io.ballerina.runtime.observability.ObserverContext;
import io.ballerina.runtime.observability.tracer.BSpan;
import io.opentelemetry.api.common.Attributes;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;

public final class ObserveUtils {
    private static final List<BallerinaObserver> observers = new CopyOnWriteArrayList<BallerinaObserver>();
    private static final Map<String, String> defaultTags = new ConcurrentHashMap<String, String>();
    private static final boolean enabled;
    private static final boolean metricsEnabled;
    private static final BString metricsProvider;
    private static final BString metricsReporter;
    private static final boolean tracingEnabled;
    private static final BString tracingProvider;
    private static final boolean metricsLogsEnabled;

    private ObserveUtils() {
    }

    private static <T> T readConfig(VariableKey specificKey, VariableKey inheritedKey, T defaultValue) {
        Object value = ConfigMap.containsKey(specificKey) ? ConfigMap.get(specificKey) : (inheritedKey != null && ConfigMap.containsKey(inheritedKey) ? ConfigMap.get(inheritedKey) : defaultValue);
        return (T)value;
    }

    public static boolean isObservabilityEnabled() {
        return enabled;
    }

    public static boolean isMetricsEnabled() {
        return metricsEnabled;
    }

    public static BString getMetricsProvider() {
        return metricsProvider;
    }

    public static BString getMetricsReporter() {
        return metricsReporter;
    }

    public static boolean isTracingEnabled() {
        return tracingEnabled;
    }

    public static BString getTracingProvider() {
        return tracingProvider;
    }

    public static boolean isMetricsLogsEnabled() {
        return metricsLogsEnabled;
    }

    public static void addTag(String tagKey, String tagValue) {
        if (!enabled) {
            return;
        }
        defaultTags.put(tagKey, tagValue);
    }

    public static void addObserver(BallerinaObserver observer) {
        observers.add(observer);
    }

    public static void startResourceObservation(Environment env, BString module, BString srcFileName, long startLine, long startColumn, BString serviceName, BString resourcePathOrFunction, BString resourceAccessor, boolean isResource, boolean isRemote) {
        if (!enabled) {
            return;
        }
        ObserverContext observerContext = ObserveUtils.getObserverContextOfCurrentFrame(env);
        if (observerContext == null) {
            observerContext = new ObserverContext();
            ObserveUtils.setObserverContextToCurrentFrame(env, observerContext);
        }
        if (observerContext.isStarted()) {
            ObserverContext newObserverContext = new ObserverContext();
            ObserveUtils.setObserverContextToCurrentFrame(env, newObserverContext);
            newObserverContext.setEntrypointFunctionModule(observerContext.getEntrypointFunctionModule());
            newObserverContext.setEntrypointServiceName(observerContext.getEntrypointServiceName());
            newObserverContext.setEntrypointFunctionName(observerContext.getEntrypointFunctionName());
            newObserverContext.setEntrypointResourceAccessor(observerContext.getEntrypointResourceAccessor());
            newObserverContext.setParent(observerContext);
            observerContext = newObserverContext;
        } else {
            observerContext.setEntrypointFunctionModule(module.getValue());
            observerContext.setEntrypointServiceName(serviceName.getValue());
            observerContext.setEntrypointFunctionName(resourcePathOrFunction.getValue());
            if (isResource) {
                observerContext.setEntrypointResourceAccessor(resourceAccessor.getValue());
            }
        }
        observerContext.setServiceName(serviceName.getValue());
        if (isResource) {
            observerContext.setOperationName(resourceAccessor.getValue() + " " + resourcePathOrFunction.getValue());
            observerContext.addTag("src.service.resource", "true");
            observerContext.addTag("src.resource.accessor", resourceAccessor.getValue());
            observerContext.addTag("src.resource.path", resourcePathOrFunction.getValue());
        } else if (isRemote) {
            observerContext.setOperationName(serviceName.getValue() + ":" + resourcePathOrFunction.getValue());
            observerContext.addTag("src.service.remote", "true");
            observerContext.addTag("src.function.name", resourcePathOrFunction.getValue());
        } else {
            observerContext.setOperationName(serviceName.getValue() + ":" + resourcePathOrFunction.getValue());
            observerContext.addTag("src.function.name", resourcePathOrFunction.getValue());
        }
        observerContext.addTag("src.object.name", serviceName.getValue());
        observerContext.addTag("src.module", module.getValue());
        observerContext.addTag("src.position", ObserveUtils.generatePositionId(srcFileName, startLine, startColumn));
        if (observerContext.getEntrypointFunctionModule() != null) {
            observerContext.addTag("entrypoint.function.module", observerContext.getEntrypointFunctionModule());
        }
        if (observerContext.getEntrypointServiceName() != null) {
            observerContext.addTag("entrypoint.service.name", observerContext.getEntrypointServiceName());
        }
        if (observerContext.getEntrypointFunctionName() != null) {
            observerContext.addTag("entrypoint.function.name", observerContext.getEntrypointFunctionName());
        }
        if (observerContext.getEntrypointResourceAccessor() != null) {
            observerContext.addTag("entrypoint.resource.accessor", observerContext.getEntrypointResourceAccessor());
        }
        if (!defaultTags.isEmpty()) {
            for (Map.Entry entry : defaultTags.entrySet()) {
                observerContext.addTag((String)entry.getKey(), (String)entry.getValue());
            }
        }
        observerContext.setServer();
        observerContext.setStarted();
        for (BallerinaObserver ballerinaObserver : observers) {
            ballerinaObserver.startServerObservation(observerContext);
        }
    }

    public static void recordCheckpoint(Environment env, BString pkg, BString srcFileName, long startLine, long startColumn) {
        if (!tracingEnabled) {
            return;
        }
        ObserverContext observerContext = (ObserverContext)env.getStrandLocal("__observer_context__");
        if (observerContext == null) {
            return;
        }
        BSpan span = observerContext.getSpan();
        if (span == null) {
            return;
        }
        Attributes eventAttributes = Attributes.builder().put("src.module", pkg.getValue()).put("src.position", ObserveUtils.generatePositionId(srcFileName, startLine, startColumn)).build();
        span.addEvent("CHECKPOINT", eventAttributes);
    }

    public static void stopObservation(Environment env) {
        if (!enabled) {
            return;
        }
        ObserverContext observerContext = ObserveUtils.getObserverContextOfCurrentFrame(env);
        if (observerContext == null) {
            return;
        }
        if (!observerContext.isManuallyClosed()) {
            ObserveUtils.stopObservationWithContext(observerContext);
        }
        ObserveUtils.setObserverContextToCurrentFrame(env, observerContext.getParent());
    }

    public static void stopObservationWithContext(ObserverContext observerContext) {
        if (!observerContext.isFinished()) {
            if (observerContext.isServer()) {
                observers.forEach(observer -> observer.stopServerObservation(observerContext));
            } else {
                observers.forEach(observer -> observer.stopClientObservation(observerContext));
            }
            observerContext.setFinished();
        }
    }

    public static void stopObservationWithError(Environment env, ErrorValue errorValue) {
        ObserveUtils.reportError(env, errorValue);
        ObserveUtils.stopObservation(env);
    }

    public static void reportError(Environment env, ErrorValue errorValue) {
        if (!enabled) {
            return;
        }
        ObserverContext observerContext = ObserveUtils.getObserverContextOfCurrentFrame(env);
        if (observerContext == null) {
            return;
        }
        observerContext.addTag("error", "true");
        observerContext.addProperty("_ballerina_error_value_", errorValue);
    }

    public static void startCallableObservation(Environment env, BString module, BString srcFileName, long startLine, long startColumn, BObject typeDef, BString functionName, boolean isMainEntryPoint, boolean isRemote, boolean isWorker) {
        if (!enabled) {
            return;
        }
        ObserverContext prevObserverCtx = ObserveUtils.getObserverContextOfCurrentFrame(env);
        ObserverContext newObContext = new ObserverContext();
        ObserveUtils.setObserverContextToCurrentFrame(env, newObContext);
        if (prevObserverCtx != null) {
            newObContext.setServiceName(prevObserverCtx.getServiceName());
            newObContext.setEntrypointFunctionModule(prevObserverCtx.getEntrypointFunctionModule());
            newObContext.setEntrypointServiceName(prevObserverCtx.getEntrypointServiceName());
            newObContext.setEntrypointFunctionName(prevObserverCtx.getEntrypointFunctionName());
            newObContext.setEntrypointResourceAccessor(prevObserverCtx.getEntrypointResourceAccessor());
            newObContext.setParent(prevObserverCtx);
        } else {
            newObContext.setServiceName("Ballerina");
            newObContext.setEntrypointFunctionModule(module.getValue());
            newObContext.setEntrypointFunctionName(functionName.getValue());
        }
        if (isMainEntryPoint) {
            newObContext.addTag("src.main", "true");
        } else if (isRemote) {
            newObContext.addTag("src.client.remote", "true");
        } else if (isWorker) {
            newObContext.addTag("src.worker", "true");
        }
        if (typeDef != null) {
            ObjectType type = (ObjectType)TypeUtils.getImpliedType(typeDef.getType());
            Module module2 = type.getPackage();
            String objectName = module2.getOrg() + "/" + module2.getName() + "/" + type.getName();
            newObContext.setOperationName(objectName + ":" + functionName.getValue());
            newObContext.addTag("src.object.name", objectName);
        } else {
            newObContext.setOperationName(functionName.getValue());
        }
        newObContext.addTag("src.function.name", functionName.getValue());
        newObContext.addTag("src.module", module.getValue());
        newObContext.addTag("src.position", ObserveUtils.generatePositionId(srcFileName, startLine, startColumn));
        if (newObContext.getEntrypointFunctionModule() != null) {
            newObContext.addTag("entrypoint.function.module", newObContext.getEntrypointFunctionModule());
        }
        if (newObContext.getEntrypointServiceName() != null) {
            newObContext.addTag("entrypoint.service.name", newObContext.getEntrypointServiceName());
        }
        if (newObContext.getEntrypointFunctionName() != null) {
            newObContext.addTag("entrypoint.function.name", newObContext.getEntrypointFunctionName());
        }
        if (newObContext.getEntrypointResourceAccessor() != null) {
            newObContext.addTag("entrypoint.resource.accessor", newObContext.getEntrypointResourceAccessor());
        }
        if (!defaultTags.isEmpty()) {
            for (Map.Entry entry : defaultTags.entrySet()) {
                newObContext.addTag((String)entry.getKey(), (String)entry.getValue());
            }
        }
        newObContext.setStarted();
        for (BallerinaObserver ballerinaObserver : observers) {
            ballerinaObserver.startClientObservation(newObContext);
        }
    }

    public static Map<String, String> getContextProperties(ObserverContext observerContext) {
        BSpan bSpan = observerContext.getSpan();
        if (bSpan != null) {
            return bSpan.extractContextAsHttpHeaders();
        }
        return Collections.emptyMap();
    }

    @Deprecated
    public static void logMessageToActiveSpan(String logLevel, Supplier<String> logMessage, boolean isError) {
    }

    public static ObserverContext getObserverContextOfCurrentFrame(Environment env) {
        if (!enabled) {
            return null;
        }
        return (ObserverContext)env.getStrandLocal("__observer_context__");
    }

    public static void setObserverContextToCurrentFrame(Environment env, ObserverContext observerContext) {
        if (!enabled) {
            return;
        }
        env.setStrandLocal("__observer_context__", observerContext);
    }

    private static String generatePositionId(BString srcFileName, long startLine, long startColumn) {
        return String.format("%s:%d:%d", srcFileName, startLine, startColumn);
    }

    static {
        Module observeModule = new Module("ballerina", "observe", "1");
        VariableKey enabledKey = new VariableKey(observeModule, "enabled", PredefinedTypes.TYPE_BOOLEAN, false);
        VariableKey providerKey = new VariableKey(observeModule, "provider", PredefinedTypes.TYPE_STRING, false);
        VariableKey metricsEnabledKey = new VariableKey(observeModule, "metricsEnabled", PredefinedTypes.TYPE_BOOLEAN, false);
        VariableKey metricsProviderKey = new VariableKey(observeModule, "metricsProvider", PredefinedTypes.TYPE_STRING, false);
        VariableKey metricsReporterKey = new VariableKey(observeModule, "metricsReporter", PredefinedTypes.TYPE_STRING, false);
        VariableKey tracingEnabledKey = new VariableKey(observeModule, "tracingEnabled", PredefinedTypes.TYPE_BOOLEAN, false);
        VariableKey tracingProviderKey = new VariableKey(observeModule, "tracingProvider", PredefinedTypes.TYPE_STRING, false);
        VariableKey metricsLogsEnabledKey = new VariableKey(observeModule, "metricsLogsEnabled", PredefinedTypes.TYPE_BOOLEAN, false);
        metricsEnabled = ObserveUtils.readConfig(metricsEnabledKey, enabledKey, false);
        metricsProvider = ObserveUtils.readConfig(metricsProviderKey, null, StringUtils.fromString("default"));
        metricsReporter = ObserveUtils.readConfig(metricsReporterKey, providerKey, StringUtils.fromString("choreo"));
        tracingEnabled = ObserveUtils.readConfig(tracingEnabledKey, enabledKey, false);
        tracingProvider = ObserveUtils.readConfig(tracingProviderKey, providerKey, StringUtils.fromString("choreo"));
        metricsLogsEnabled = ObserveUtils.readConfig(metricsLogsEnabledKey, metricsLogsEnabledKey, false);
        enabled = metricsEnabled || tracingEnabled || metricsLogsEnabled;
    }
}

