/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.constraint;

import java.util.Optional;

public class ConstraintAnnotation {
    private final String minValue;
    private final String maxValue;
    private final String length;
    private final String minLength;
    private final String maxLength;
    private final String minValueExclusive;
    private final String maxValueExclusive;
    private final String pattern;

    public ConstraintAnnotation(ConstraintAnnotationBuilder builder) {
        this.minValue = builder.minValue;
        this.maxValue = builder.maxValue;
        this.length = builder.length;
        this.minLength = builder.minLength;
        this.maxLength = builder.maxLength;
        this.minValueExclusive = builder.minValueExclusive;
        this.maxValueExclusive = builder.maxValueExclusive;
        this.pattern = builder.pattern;
    }

    public boolean hasConstraints() {
        return this.minValue != null || this.maxValue != null || this.length != null || this.minLength != null || this.maxLength != null || this.minValueExclusive != null || this.maxValueExclusive != null || this.pattern != null;
    }

    public Optional<String> getMinValue() {
        return Optional.ofNullable(this.minValue);
    }

    public Optional<String> getMaxValue() {
        return Optional.ofNullable(this.maxValue);
    }

    public Optional<String> getLength() {
        return Optional.ofNullable(this.length);
    }

    public Optional<String> getMinLength() {
        return Optional.ofNullable(this.minLength);
    }

    public Optional<String> getMaxLength() {
        return Optional.ofNullable(this.maxLength);
    }

    public Optional<String> getMinValueExclusive() {
        return Optional.ofNullable(this.minValueExclusive);
    }

    public Optional<String> getMaxValueExclusive() {
        return Optional.ofNullable(this.maxValueExclusive);
    }

    public Optional<String> getPattern() {
        return Optional.ofNullable(this.pattern);
    }

    public static class ConstraintAnnotationBuilder {
        private String minValue;
        private String maxValue;
        private String length;
        private String minLength;
        private String maxLength;
        private String minValueExclusive;
        private String maxValueExclusive;
        private String pattern;

        public void withMinValue(String minValue) {
            this.minValue = minValue;
        }

        public void withLength(String length) {
            this.length = length;
        }

        public void withMaxValue(String maxValue) {
            this.maxValue = maxValue;
        }

        public void withMinLength(String minLength) {
            this.minLength = minLength;
        }

        public void withMaxLength(String maxLength) {
            this.maxLength = maxLength;
        }

        public void withMinValueExclusive(String minValueExclusive) {
            this.minValueExclusive = minValueExclusive;
        }

        public void withMaxValueExclusive(String maxValueExclusive) {
            this.maxValueExclusive = maxValueExclusive;
        }

        public void withPattern(String pattern) {
            this.pattern = pattern;
        }

        public ConstraintAnnotation build() {
            return new ConstraintAnnotation(this);
        }
    }
}

