/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.interceptor.model;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.openapi.service.mapper.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.service.mapper.diagnostic.ExceptionDiagnostic;
import io.ballerina.openapi.service.mapper.diagnostic.OpenAPIMapperDiagnostic;
import io.ballerina.openapi.service.mapper.interceptor.InterceptorMapperException;
import io.ballerina.openapi.service.mapper.interceptor.model.RequestParameter;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class RequestParameterInfo {
    private final Map<String, RequestParameter> reqParameters = new HashMap<String, RequestParameter>();
    private final SemanticModel semanticModel;

    public RequestParameterInfo(SemanticModel semanticModel) {
        this.semanticModel = semanticModel;
    }

    public void addReqParameters(Iterable<ParameterNode> parameterNodes, List<OpenAPIMapperDiagnostic> diagnostics, boolean fromTargetResource) {
        for (ParameterNode parameterNode : parameterNodes) {
            try {
                this.addReqParameter(parameterNode, fromTargetResource);
            }
            catch (InterceptorMapperException e) {
                RequestParameterInfo.addWarningDiagnostic(diagnostics, e.getMessage());
            }
        }
    }

    private static void addWarningDiagnostic(List<OpenAPIMapperDiagnostic> diagnostics, String cause) {
        ExceptionDiagnostic error = new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_127, cause);
        diagnostics.add(error);
    }

    private void addReqParameter(ParameterNode parameterNode, boolean fromTargetResource) throws InterceptorMapperException {
        ParameterSymbol parameterSymbol = this.getParameterSymbol(parameterNode);
        if (Objects.isNull(parameterSymbol)) {
            return;
        }
        String parameterName = this.getParameterName(parameterSymbol);
        if (Objects.isNull(parameterName)) {
            return;
        }
        this.addReqParameter(parameterName, parameterNode, parameterSymbol.typeDescriptor(), fromTargetResource);
    }

    private void addReqParameter(String parameterName, ParameterNode parameterNode, TypeSymbol parameterType, boolean fromTargetResource) throws InterceptorMapperException {
        if (!parameterType.subtypeOf(this.semanticModel.types().ANYDATA)) {
            return;
        }
        if (this.reqParameters.containsKey(parameterName)) {
            this.updateReqParameter(parameterName, parameterNode, parameterType, fromTargetResource);
            return;
        }
        this.reqParameters.put(parameterName, new RequestParameter(parameterNode, parameterType));
    }

    private void updateReqParameter(String parameterName, ParameterNode parameterNode, TypeSymbol parameterType, boolean fromTargetResource) throws InterceptorMapperException {
        TypeSymbol existingType = this.reqParameters.get(parameterName).parameterType();
        if (parameterType.subtypeOf(existingType)) {
            this.reqParameters.put(parameterName, new RequestParameter(parameterNode, parameterType));
        } else if (!existingType.subtypeOf(parameterType)) {
            String expMessage = "incompatible types found for the parameter: " + parameterName;
            if (fromTargetResource) {
                this.reqParameters.put(parameterName, new RequestParameter(parameterNode, parameterType));
                expMessage = expMessage + ". Defaulting to the type from the target resource";
            }
            throw new InterceptorMapperException(expMessage);
        }
    }

    private ParameterSymbol getParameterSymbol(ParameterNode parameterNode) {
        Symbol symbol = this.semanticModel.symbol((Node)parameterNode).orElse(null);
        if (symbol instanceof ParameterSymbol) {
            ParameterSymbol parameterSymbol = (ParameterSymbol)symbol;
            return parameterSymbol;
        }
        return null;
    }

    private String getParameterName(ParameterSymbol parameterNode) {
        return parameterNode.getName().map(MapperCommonUtils::unescapeIdentifier).orElse(null);
    }

    public Iterable<ParameterNode> getReqParameterNodes() {
        return this.reqParameters.values().stream().map(RequestParameter::parameterNode).collect(Collectors.toList());
    }
}

