/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.interceptor.types;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.openapi.service.mapper.interceptor.InterceptorMapperException;
import io.ballerina.openapi.service.mapper.interceptor.types.Resource;
import io.ballerina.openapi.service.mapper.interceptor.types.TargetResource;
import io.ballerina.openapi.service.mapper.model.PackageMemberVisitor;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import io.ballerina.openapi.service.mapper.utils.MediaTypeUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class Interceptor
extends Resource {
    protected final ClassSymbol serviceClass;
    protected final ClassDefinitionNode serviceClassNode;
    protected boolean continueExecution = false;
    private Interceptor nextInReqPath = null;
    protected Interceptor nextInResPath = null;

    protected Interceptor(TypeReferenceTypeSymbol typeSymbol, SemanticModel semanticModel, PackageMemberVisitor packageMemberVisitor) throws InterceptorMapperException {
        super(semanticModel);
        String name = typeSymbol.getName().orElse("");
        String moduleName = MapperCommonUtils.getModuleName((Symbol)typeSymbol);
        Optional<ClassDefinitionNode> interceptorServiceClassNode = packageMemberVisitor.getInterceptorServiceClassNode(moduleName, name);
        if (!interceptorServiceClassNode.isPresent()) {
            throw new InterceptorMapperException("no class definition found for the interceptor: " + name + " within the package. Make sure that the interceptor return type is defined with the specific interceptor class type rather than the generic `http:Interceptor` type and the specific interceptor class is defined within the package");
        }
        this.serviceClassNode = interceptorServiceClassNode.get();
        ClassSymbol classSymbol = this.serviceClass = typeSymbol.typeDescriptor() instanceof ClassSymbol ? (ClassSymbol)typeSymbol.typeDescriptor() : null;
        if (Objects.isNull(this.serviceClass)) {
            throw new InterceptorMapperException("no class definition found for the interceptor: " + name + ". Make sure that the interceptor return type is defined with the specific interceptor class type rather than the generic `http:Interceptor` type");
        }
        this.extractInterceptorDetails(semanticModel);
    }

    protected abstract void extractInterceptorDetails(SemanticModel var1);

    public abstract boolean isInvokable(TargetResource var1);

    protected void setReturnType(TypeSymbol returnType) {
        TypeSymbol effectiveReturnType;
        if (this.isSubTypeOfDefaultInterceptorReturnType(returnType, this.semanticModel)) {
            this.continueExecution = true;
            effectiveReturnType = this.getEffectiveReturnType(returnType, this.semanticModel);
        } else {
            effectiveReturnType = returnType;
        }
        if (Objects.isNull(effectiveReturnType)) {
            return;
        }
        this.extractErrorAndNonErrorReturnTypes(effectiveReturnType);
    }

    private boolean isSubTypeOfDefaultInterceptorReturnType(TypeSymbol typeSymbol, SemanticModel semanticModel) {
        Object t;
        Optional optNextServiceType = semanticModel.types().getTypeByName("ballerina", "http", "", "NextService");
        if (optNextServiceType.isEmpty() || !((t = optNextServiceType.get()) instanceof TypeDefinitionSymbol)) {
            return false;
        }
        TypeDefinitionSymbol nextServiceType = (TypeDefinitionSymbol)t;
        UnionTypeSymbol defaultInterceptorReturnType = semanticModel.types().builder().UNION_TYPE.withMemberTypes(new TypeSymbol[]{nextServiceType.typeDescriptor(), semanticModel.types().NIL}).build();
        return defaultInterceptorReturnType.subtypeOf(typeSymbol);
    }

    private boolean isSubTypeOfHttpNextServiceType(TypeSymbol typeSymbol, SemanticModel semanticModel) {
        Object t;
        Optional optNextServiceType = semanticModel.types().getTypeByName("ballerina", "http", "", "NextService");
        if (optNextServiceType.isEmpty() || !((t = optNextServiceType.get()) instanceof TypeDefinitionSymbol)) {
            return false;
        }
        TypeDefinitionSymbol nextServiceType = (TypeDefinitionSymbol)t;
        return typeSymbol.subtypeOf(nextServiceType.typeDescriptor());
    }

    private TypeSymbol getEffectiveReturnType(TypeSymbol typeSymbol, SemanticModel semanticModel) {
        if (this.isSubTypeOfHttpNextServiceType(typeSymbol, semanticModel) || typeSymbol.subtypeOf(semanticModel.types().NIL)) {
            return null;
        }
        if (MediaTypeUtils.getInstance(semanticModel).isSameMediaType(typeSymbol)) {
            return typeSymbol;
        }
        if (typeSymbol instanceof TypeReferenceTypeSymbol) {
            return this.getEffectiveReturnType(((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor(), semanticModel);
        }
        if (typeSymbol instanceof UnionTypeSymbol) {
            List memberTypes = ((UnionTypeSymbol)typeSymbol).userSpecifiedMemberTypes();
            List<TypeSymbol> effectiveMemberTypes = memberTypes.stream().map(memberType -> this.getEffectiveReturnType((TypeSymbol)memberType, semanticModel)).filter(Objects::nonNull).toList();
            if (effectiveMemberTypes.isEmpty()) {
                return null;
            }
            if (effectiveMemberTypes.size() == 1) {
                return effectiveMemberTypes.getFirst();
            }
            return semanticModel.types().builder().UNION_TYPE.withMemberTypes((TypeSymbol[])effectiveMemberTypes.toArray(TypeSymbol[]::new)).build();
        }
        return typeSymbol;
    }

    protected abstract FunctionDefinitionNode getFunctionDefinitionNode();

    public Iterable<ParameterNode> getParameterNodes() {
        FunctionDefinitionNode functionDefinitionNode = this.getFunctionDefinitionNode();
        if (Objects.isNull(functionDefinitionNode)) {
            return List.of();
        }
        FunctionSignatureNode functionSignature = functionDefinitionNode.functionSignature();
        return functionSignature.parameters();
    }

    public abstract InterceptorType getType();

    public boolean isContinueExecution() {
        return this.continueExecution;
    }

    public void setNextInReqPath(Interceptor nextInReqPath) {
        this.nextInReqPath = nextInReqPath;
    }

    public void setNextInResPath(Interceptor nextInResPath) {
        this.nextInResPath = nextInResPath;
    }

    public Interceptor getNextInReqErrorPath() {
        if (Objects.isNull(this.nextInReqPath) || this.nextInReqPath.getType().equals((Object)InterceptorType.REQUEST_ERROR)) {
            return this.nextInReqPath;
        }
        return this.nextInReqPath.getNextInReqErrorPath();
    }

    public Interceptor getNextInResErrorPath() {
        if (Objects.isNull(this.nextInResPath) || this.nextInResPath.getType().equals((Object)InterceptorType.RESPONSE_ERROR)) {
            return this.nextInResPath;
        }
        return this.nextInResPath.getNextInResErrorPath();
    }

    public Interceptor getNextInReqPath() {
        if (Objects.isNull(this.nextInReqPath) || this.nextInReqPath.getType().equals((Object)InterceptorType.REQUEST)) {
            return this.nextInReqPath;
        }
        return this.nextInReqPath.getNextInReqPath();
    }

    public Interceptor getNextInResPath() {
        if (Objects.isNull(this.nextInResPath) || this.nextInResPath.getType().equals((Object)InterceptorType.RESPONSE)) {
            return this.nextInResPath;
        }
        return this.nextInResPath.getNextInResPath();
    }

    public static enum InterceptorType {
        REQUEST,
        REQUEST_ERROR,
        RESPONSE,
        RESPONSE_ERROR;

    }
}

