/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.model;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.ListenerDeclarationNode;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.openapi.service.mapper.model.ModuleMemberVisitor;
import io.ballerina.openapi.service.mapper.model.ServiceContractType;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class PackageMemberVisitor {
    private final Map<String, ModuleMemberVisitor> moduleVisitors = new LinkedHashMap<String, ModuleMemberVisitor>();

    public ModuleMemberVisitor createModuleVisitor(String moduleName, SemanticModel semanticModel) {
        ModuleMemberVisitor visitor = new ModuleMemberVisitor(semanticModel);
        this.moduleVisitors.put(moduleName, visitor);
        return visitor;
    }

    public Optional<ModuleMemberVisitor> getModuleVisitor(String moduleName) {
        if (this.moduleVisitors.containsKey(moduleName)) {
            return Optional.of(this.moduleVisitors.get(moduleName));
        }
        return Optional.empty();
    }

    public Optional<ListenerDeclarationNode> getListenerDeclaration(String moduleName, String listenerName) {
        return this.getModuleVisitor(moduleName).flatMap(moduleVisitor -> moduleVisitor.getListenerDeclaration(listenerName));
    }

    public Optional<ClassDefinitionNode> getInterceptorServiceClassNode(String moduleName, String typeName) {
        return this.getModuleVisitor(moduleName).flatMap(moduleVisitor -> moduleVisitor.getInterceptorServiceClassNode(typeName));
    }

    public Optional<TypeDefinitionNode> getTypeDefinitionNode(String moduleName, String typeName) {
        return this.getModuleVisitor(moduleName).flatMap(moduleVisitor -> moduleVisitor.getTypeDefinitionNode(typeName));
    }

    public Optional<ModuleMemberVisitor.VariableDeclaredValue> getVariableDeclaredValue(String moduleName, String variableName) {
        return this.getModuleVisitor(moduleName).flatMap(moduleVisitor -> moduleVisitor.getVariableDeclaredValue(variableName));
    }

    public Optional<ServiceContractType> getServiceContractType(String moduleName, String typeName) {
        return this.getModuleVisitor(moduleName).flatMap(moduleVisitor -> moduleVisitor.getServiceContractType(typeName));
    }
}

