/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.parameter;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ParameterKind;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.openapi.service.mapper.model.AdditionalData;
import io.ballerina.openapi.service.mapper.model.OperationInventory;
import io.ballerina.openapi.service.mapper.parameter.AbstractParameterMapper;
import io.ballerina.openapi.service.mapper.parameter.ParameterMapperException;
import io.ballerina.openapi.service.mapper.type.RecordTypeMapper;
import io.ballerina.openapi.service.mapper.type.TypeMapper;
import io.ballerina.openapi.service.mapper.type.UnionTypeMapper;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.HeaderParameter;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class HeaderParameterMapper
extends AbstractParameterMapper {
    private TypeSymbol type = null;
    private String name = null;
    private boolean isRequired = false;
    private String description = null;
    private boolean treatNilableAsOptional = false;
    private Object defaultValue = null;
    private TypeMapper typeMapper = null;
    private final SemanticModel semanticModel;

    public HeaderParameterMapper(ParameterNode parameterNode, Map<String, String> apiDocs, OperationInventory operationInventory, boolean treatNilableAsOptional, AdditionalData additionalData, TypeMapper typeMapper) {
        super(operationInventory);
        Symbol parameterSymbol = additionalData.semanticModel().symbol((Node)parameterNode).orElse(null);
        this.semanticModel = additionalData.semanticModel();
        if (Objects.nonNull(parameterSymbol) && parameterSymbol instanceof ParameterSymbol) {
            ParameterSymbol headerParameter = (ParameterSymbol)parameterSymbol;
            this.type = headerParameter.typeDescriptor();
            String paramName = MapperCommonUtils.unescapeIdentifier((String)parameterSymbol.getName().get());
            this.name = MapperCommonUtils.getHeaderName(parameterNode, paramName);
            this.isRequired = headerParameter.paramKind().equals((Object)ParameterKind.REQUIRED);
            this.description = apiDocs.get(headerParameter.getName().get());
            this.treatNilableAsOptional = treatNilableAsOptional;
            if (parameterNode instanceof DefaultableParameterNode) {
                DefaultableParameterNode defaultableHeaderParam = (DefaultableParameterNode)parameterNode;
                this.defaultValue = AbstractParameterMapper.getDefaultValue(defaultableHeaderParam, additionalData.semanticModel());
            }
            this.typeMapper = typeMapper;
        }
    }

    @Override
    public List<Parameter> getParameterSchemaList() throws ParameterMapperException {
        if (Objects.isNull(this.type)) {
            return List.of();
        }
        List<Parameter> headerParameters = this.getRecordParameterSchema();
        if (!headerParameters.isEmpty()) {
            return headerParameters;
        }
        return List.of(this.getParameterSchema());
    }

    public HeaderParameter getParameterSchema() {
        HeaderParameter headerParameter = new HeaderParameter();
        headerParameter.setName(this.name);
        if (!(!this.isRequired || this.treatNilableAsOptional && UnionTypeMapper.hasNilableType(this.type))) {
            headerParameter.setRequired(Boolean.valueOf(true));
        }
        Schema typeSchema = this.typeMapper.getTypeSchema(this.type);
        if (Objects.nonNull(this.defaultValue)) {
            TypeMapper.setDefaultValue(typeSchema, this.defaultValue);
        }
        headerParameter.setSchema(typeSchema);
        headerParameter.setDescription(this.description);
        return headerParameter;
    }

    public List<Parameter> getRecordParameterSchema() {
        RecordTypeMapper.RecordTypeInfo recordTypeInfo = RecordTypeMapper.getDirectRecordType(this.type, "", null);
        if (Objects.isNull(recordTypeInfo)) {
            return List.of();
        }
        HashSet<String> requiredHeaders = new HashSet<String>();
        HashMap<String, RecordFieldSymbol> headerMap = new HashMap<String, RecordFieldSymbol>(recordTypeInfo.typeSymbol().fieldDescriptors());
        headerMap = this.updateHeaderMapWithName(headerMap);
        Map<String, Schema> headerSchemaMap = this.typeMapper.getSchemaForRecordFields(headerMap, requiredHeaders, recordTypeInfo.moduleName(), recordTypeInfo.name(), this.treatNilableAsOptional);
        return headerSchemaMap.entrySet().stream().map(entry -> HeaderParameterMapper.createHeaderParameter((String)entry.getKey(), (Schema)entry.getValue(), requiredHeaders.contains(entry.getKey()), this.getDefaultValueForHeaderField((String)entry.getKey()))).collect(Collectors.toList());
    }

    private HashMap<String, RecordFieldSymbol> updateHeaderMapWithName(HashMap<String, RecordFieldSymbol> headerMap) {
        HashMap<String, RecordFieldSymbol> updatedHeaderMap = new HashMap<String, RecordFieldSymbol>();
        for (Map.Entry<String, RecordFieldSymbol> entry : headerMap.entrySet()) {
            String defaultName = entry.getKey();
            RecordFieldSymbol recordField = entry.getValue();
            updatedHeaderMap.put(MapperCommonUtils.getNameFromAnnotation("http", "HttpHeader", "name", this.semanticModel, defaultName, recordField), recordField);
        }
        return updatedHeaderMap;
    }

    private Object getDefaultValueForHeaderField(String name) {
        Object object;
        if (Objects.nonNull(this.defaultValue) && (object = this.defaultValue) instanceof Map) {
            Map defaultableValueMap = (Map)object;
            return defaultableValueMap.get(name);
        }
        return null;
    }

    private static HeaderParameter createHeaderParameter(String name, Schema schema, boolean isRequired, Object defaultValue) {
        HeaderParameter headerParameter = new HeaderParameter();
        headerParameter.setName(name);
        if (isRequired) {
            headerParameter.setRequired(Boolean.valueOf(true));
        }
        if (Objects.nonNull(defaultValue)) {
            TypeMapper.setDefaultValue(schema, defaultValue);
        }
        headerParameter.setSchema(schema);
        return headerParameter;
    }
}

