/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.type;

import io.ballerina.compiler.api.symbols.TupleTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.openapi.service.mapper.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.service.mapper.diagnostic.ExceptionDiagnostic;
import io.ballerina.openapi.service.mapper.model.AdditionalData;
import io.ballerina.openapi.service.mapper.type.AbstractTypeMapper;
import io.ballerina.openapi.service.mapper.type.TypeMapperImpl;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.List;
import java.util.Optional;

public class TupleTypeMapper
extends AbstractTypeMapper {
    public TupleTypeMapper(TypeReferenceTypeSymbol typeSymbol, AdditionalData additionalData) {
        super(typeSymbol, additionalData);
    }

    @Override
    public Schema getReferenceSchema(Components components) {
        TupleTypeSymbol referredType = (TupleTypeSymbol)this.typeSymbol.typeDescriptor();
        return TupleTypeMapper.getSchema(referredType, components, this.additionalData).description(this.description);
    }

    public static Schema getSchema(TupleTypeSymbol typeSymbol, Components components, AdditionalData additionalData) {
        Optional restTypeSymbol = typeSymbol.restTypeDescriptor();
        if (restTypeSymbol.isPresent()) {
            ExceptionDiagnostic error = new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_123, MapperCommonUtils.getTypeName((TypeSymbol)typeSymbol));
            additionalData.diagnostics().add(error);
        }
        List memberTypeSymbols = typeSymbol.memberTypeDescriptors();
        Schema memberSchema = new ComposedSchema().oneOf(memberTypeSymbols.stream().map(type -> TypeMapperImpl.getTypeSchema(type, components, additionalData)).toList());
        return new ArraySchema().items(memberSchema);
    }
}

