/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.email.compiler.staticcodeanalyzer;

import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.scan.Reporter;
import io.ballerina.stdlib.email.compiler.staticcodeanalyzer.EmailRule;
import io.ballerina.tools.diagnostics.Location;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class EmailSmtpClientAnalyzer
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    private final Reporter reporter;
    private static final String BALLERINA_ORG = "ballerina";
    private static final String EMAIL = "email";
    private static final String SMTP_CLIENT = "SmtpClient";
    private static final String POP_CLIENT = "PopClient";
    private static final String IMAP_CLIENT = "ImapClient";
    private static final String SECURE_SOCKET = "secureSocket";
    private static final String VERIFY_HOST_NAME = "verifyHostName";
    private final Set<String> emailPrefixes = new HashSet<String>();

    public EmailSmtpClientAnalyzer(Reporter reporter) {
        this.reporter = reporter;
    }

    public void perform(SyntaxNodeAnalysisContext context) {
        this.analyzeImports(context);
        Optional<VariableDeclarationNode> smtpClientNode = this.findSmtpClientNode((FunctionBodyBlockNode)context.node());
        if (smtpClientNode.isEmpty()) {
            return;
        }
        Optional<FunctionArgumentNode> smtpConfigArgument = this.findSmtpConfigArgument(smtpClientNode.get());
        if (smtpConfigArgument.isEmpty()) {
            return;
        }
        Optional<MappingConstructorExpressionNode> smtpConfigMapping = this.extractSmtpConfigMapping(context, smtpConfigArgument.get());
        if (smtpConfigMapping.isPresent() && this.isVulnerableSmtpConfig(smtpConfigMapping.get())) {
            this.report(context, EmailRule.AVOID_UNVERIFIED_SERVER_HOSTNAMES.getId());
        }
    }

    private Optional<MappingConstructorExpressionNode> extractSmtpConfigMapping(SyntaxNodeAnalysisContext context, FunctionArgumentNode smtpConfigArgument) {
        FunctionBodyBlockNode functionBodyBlockNode;
        Optional<MappingConstructorExpressionNode> mapping;
        Optional<ExpressionNode> smtpConfigExpression = this.extractSmtpConfigExpressionFromFunctionBody(smtpConfigArgument);
        if (smtpConfigExpression.isEmpty()) {
            return Optional.empty();
        }
        ExpressionNode expr = smtpConfigExpression.get();
        if (expr instanceof MappingConstructorExpressionNode) {
            MappingConstructorExpressionNode mappingNode = (MappingConstructorExpressionNode)expr;
            return Optional.of(mappingNode);
        }
        Node node = context.node();
        if (node instanceof FunctionBodyBlockNode && (mapping = this.extractSmtpConfigExpressionFromFunctionBody(functionBodyBlockNode = (FunctionBodyBlockNode)node, expr)).isPresent()) {
            return mapping;
        }
        for (Node parent = context.node(); parent != null; parent = parent.parent()) {
            ModulePartNode modulePartNode;
            Optional<MappingConstructorExpressionNode> mapping2;
            if (!(parent instanceof ModulePartNode) || !(mapping2 = this.extractSmtpConfigExpressionFromModulePart(modulePartNode = (ModulePartNode)parent, expr)).isPresent()) continue;
            return mapping2;
        }
        return Optional.empty();
    }

    private Optional<MappingConstructorExpressionNode> extractSmtpConfigExpressionFromFunctionBody(FunctionBodyBlockNode functionBodyBlockNode, ExpressionNode expressionNode) {
        for (StatementNode statement : functionBodyBlockNode.statements()) {
            CaptureBindingPatternNode captureBindingPatternNode;
            VariableDeclarationNode variableDeclarationNode;
            TypedBindingPatternNode typedBindingPatternNode;
            Object object;
            if (!(statement instanceof VariableDeclarationNode) || !((object = (typedBindingPatternNode = (variableDeclarationNode = (VariableDeclarationNode)statement).typedBindingPattern()).bindingPattern()) instanceof CaptureBindingPatternNode) || !(captureBindingPatternNode = (CaptureBindingPatternNode)object).variableName().text().equals(expressionNode.toString()) || !variableDeclarationNode.initializer().isPresent() || !((object = variableDeclarationNode.initializer().get()) instanceof MappingConstructorExpressionNode)) continue;
            MappingConstructorExpressionNode mappingConstructorExpressionNode = (MappingConstructorExpressionNode)object;
            return Optional.of(mappingConstructorExpressionNode);
        }
        return Optional.empty();
    }

    private Optional<MappingConstructorExpressionNode> extractSmtpConfigExpressionFromModulePart(ModulePartNode modulePartNode, ExpressionNode expressionNode) {
        for (ModuleMemberDeclarationNode statement : modulePartNode.members()) {
            CaptureBindingPatternNode captureBindingPatternNode;
            ModuleVariableDeclarationNode variableDeclarationNode;
            TypedBindingPatternNode typedBindingPatternNode;
            Object object;
            if (!(statement instanceof ModuleVariableDeclarationNode) || !((object = (typedBindingPatternNode = (variableDeclarationNode = (ModuleVariableDeclarationNode)statement).typedBindingPattern()).bindingPattern()) instanceof CaptureBindingPatternNode) || !(captureBindingPatternNode = (CaptureBindingPatternNode)object).variableName().text().equals(expressionNode.toString()) || !variableDeclarationNode.initializer().isPresent() || !((object = variableDeclarationNode.initializer().get()) instanceof MappingConstructorExpressionNode)) continue;
            MappingConstructorExpressionNode mappingConstructorExpressionNode = (MappingConstructorExpressionNode)object;
            return Optional.of(mappingConstructorExpressionNode);
        }
        return Optional.empty();
    }

    private Optional<VariableDeclarationNode> findSmtpClientNode(FunctionBodyBlockNode functionBodyBlockNode) {
        if (functionBodyBlockNode.statements().isEmpty()) {
            return Optional.empty();
        }
        for (StatementNode statement : functionBodyBlockNode.statements()) {
            QualifiedNameReferenceNode qualifiedNameReferenceNode;
            VariableDeclarationNode variableDeclarationNode;
            TypedBindingPatternNode typedBindingPatternNode;
            TypeDescriptorNode typeDescriptorNode;
            if (!(statement instanceof VariableDeclarationNode) || !((typeDescriptorNode = (typedBindingPatternNode = (variableDeclarationNode = (VariableDeclarationNode)statement).typedBindingPattern()).typeDescriptor()) instanceof QualifiedNameReferenceNode) || !this.emailPrefixes.contains((qualifiedNameReferenceNode = (QualifiedNameReferenceNode)typeDescriptorNode).modulePrefix().text()) || !qualifiedNameReferenceNode.identifier().text().equals(SMTP_CLIENT) && !qualifiedNameReferenceNode.identifier().text().equals(POP_CLIENT) && !qualifiedNameReferenceNode.identifier().text().equals(IMAP_CLIENT)) continue;
            return Optional.of(variableDeclarationNode);
        }
        return Optional.empty();
    }

    private Optional<FunctionArgumentNode> findSmtpConfigArgument(VariableDeclarationNode variableDeclarationNode) {
        if (variableDeclarationNode.initializer().isEmpty()) {
            return Optional.empty();
        }
        ExpressionNode initializer = (ExpressionNode)variableDeclarationNode.initializer().get();
        if (initializer instanceof CheckExpressionNode) {
            ImplicitNewExpressionNode implicitNewExpressionNode;
            Optional parenthesizedArgList;
            CheckExpressionNode checkExpressionNode = (CheckExpressionNode)initializer;
            ExpressionNode expression = checkExpressionNode.expression();
            if (expression instanceof ImplicitNewExpressionNode && (parenthesizedArgList = (implicitNewExpressionNode = (ImplicitNewExpressionNode)expression).parenthesizedArgList()).isPresent() && ((ParenthesizedArgList)parenthesizedArgList.get()).arguments().size() > 3) {
                FunctionArgumentNode functionArgumentNode = (FunctionArgumentNode)((ParenthesizedArgList)parenthesizedArgList.get()).arguments().get(3);
                return Optional.of(functionArgumentNode);
            }
        } else {
            return Optional.empty();
        }
        return Optional.empty();
    }

    private Optional<ExpressionNode> extractSmtpConfigExpressionFromFunctionBody(FunctionArgumentNode node) {
        FunctionArgumentNode functionArgumentNode = node;
        Objects.requireNonNull(functionArgumentNode);
        FunctionArgumentNode functionArgumentNode2 = functionArgumentNode;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PositionalArgumentNode.class, NamedArgumentNode.class}, (Object)functionArgumentNode2, n)) {
            case 0: {
                PositionalArgumentNode positionalArgumentNode = (PositionalArgumentNode)functionArgumentNode2;
                return Optional.of(positionalArgumentNode.expression());
            }
            case 1: {
                NamedArgumentNode namedArgumentNode = (NamedArgumentNode)functionArgumentNode2;
                return Optional.of(namedArgumentNode.expression());
            }
        }
        return Optional.empty();
    }

    private boolean isVulnerableSmtpConfig(MappingConstructorExpressionNode mappingConstructorExpressionNode) {
        return mappingConstructorExpressionNode.fields().stream().filter(this::isSecureSocketField).map(this::getSecureSocketConfig).filter(Optional::isPresent).map(Optional::get).anyMatch(this::hasUnverifiedHostName);
    }

    private boolean isSecureSocketField(MappingFieldNode fieldNode) {
        SpecificFieldNode specificFieldNode;
        return fieldNode instanceof SpecificFieldNode && (specificFieldNode = (SpecificFieldNode)fieldNode).fieldName().toString().trim().equals(SECURE_SOCKET);
    }

    private Optional<MappingConstructorExpressionNode> getSecureSocketConfig(MappingFieldNode fieldNode) {
        Object t;
        SpecificFieldNode specificFieldNode;
        Optional expressionNode;
        if (fieldNode instanceof SpecificFieldNode && (expressionNode = (specificFieldNode = (SpecificFieldNode)fieldNode).valueExpr()).isPresent() && (t = expressionNode.get()) instanceof MappingConstructorExpressionNode) {
            MappingConstructorExpressionNode secureSocketConfig = (MappingConstructorExpressionNode)t;
            return Optional.of(secureSocketConfig);
        }
        return Optional.empty();
    }

    private boolean hasUnverifiedHostName(MappingConstructorExpressionNode secureSocketConfig) {
        return secureSocketConfig.fields().stream().filter(this::isVerifyHostNameField).map(this::getVerifyHostNameValue).anyMatch(opt -> opt.isPresent() && ((BasicLiteralNode)opt.get()).literalToken().text().equals("false"));
    }

    private boolean isVerifyHostNameField(MappingFieldNode fieldNode) {
        SpecificFieldNode specificFieldNode;
        return fieldNode instanceof SpecificFieldNode && (specificFieldNode = (SpecificFieldNode)fieldNode).fieldName().toString().trim().equals(VERIFY_HOST_NAME);
    }

    private Optional<ExpressionNode> getVerifyHostNameValue(MappingFieldNode fieldNode) {
        if (fieldNode instanceof SpecificFieldNode) {
            SpecificFieldNode specificFieldNode = (SpecificFieldNode)fieldNode;
            return specificFieldNode.valueExpr();
        }
        return Optional.empty();
    }

    private void report(SyntaxNodeAnalysisContext context, int ruleId) {
        this.reporter.reportIssue(EmailSmtpClientAnalyzer.getDocument(context.currentPackage().module(context.moduleId()), context.documentId()), (Location)context.node().location(), ruleId);
    }

    private static Document getDocument(Module module, DocumentId documentId) {
        return module.document(documentId);
    }

    private void analyzeImports(SyntaxNodeAnalysisContext context) {
        Document document = EmailSmtpClientAnalyzer.getDocument(context.currentPackage().module(context.moduleId()), context.documentId());
        Node node = document.syntaxTree().rootNode();
        if (node instanceof ModulePartNode) {
            ModulePartNode modulePartNode = (ModulePartNode)node;
            modulePartNode.imports().forEach(importDeclarationNode -> {
                ImportOrgNameNode importOrgNameNode = importDeclarationNode.orgName().orElse(null);
                if (importOrgNameNode != null && BALLERINA_ORG.equals(importOrgNameNode.orgName().text()) && importDeclarationNode.moduleName().stream().anyMatch(moduleNameNode -> EMAIL.equals(moduleNameNode.text()))) {
                    ImportPrefixNode importPrefixNode = importDeclarationNode.prefix().orElse(null);
                    String prefix = importPrefixNode != null ? importPrefixNode.prefix().text() : EMAIL;
                    this.emailPrefixes.add(prefix);
                }
            });
        }
    }
}

