/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.protobuf.deserializers;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.Descriptors;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.protobuf.deserializers.AbstractDeserializer;
import io.ballerina.stdlib.protobuf.messages.BMessage;
import java.io.IOException;

public class FloatDeserializer
extends AbstractDeserializer {
    public FloatDeserializer(CodedInputStream input, Descriptors.FieldDescriptor fieldDescriptor, BMessage bMessage, Type targetType, boolean isPacked) {
        super(input, fieldDescriptor, bMessage, targetType, isPacked);
    }

    @Override
    public void deserialize() throws IOException {
        BString bFieldName = StringUtils.fromString((String)this.fieldDescriptor.getName());
        if (this.isBMap()) {
            BMap bMap = (BMap)this.bMessage.getContent();
            if (this.fieldDescriptor.isRepeated()) {
                BArray floatArray = (BArray)bMap.get((Object)bFieldName);
                if (this.isPacked) {
                    while (this.input.getBytesUntilLimit() > 0) {
                        floatArray.add((long)floatArray.size(), this.readContent());
                    }
                } else {
                    floatArray.add((long)floatArray.size(), this.readContent());
                }
            } else if (this.fieldDescriptor.getContainingOneof() != null) {
                bMap.put((Object)StringUtils.fromString((String)this.fieldDescriptor.getName()), (Object)this.readContent());
            } else {
                bMap.put((Object)bFieldName, (Object)Double.parseDouble(String.valueOf(this.input.readFloat())));
            }
        } else {
            this.bMessage.setContent(this.readContent());
        }
    }

    private double readContent() throws IOException {
        return Double.parseDouble(String.valueOf(this.input.readFloat()));
    }
}

