/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.protobuf.nativeimpl;

import com.google.protobuf.Any;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Duration;
import com.google.protobuf.Struct;
import com.google.protobuf.Timestamp;
import com.google.protobuf.WrappersProto;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.utils.ValueUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.stdlib.protobuf.deserializers.DeserializeHandler;
import io.ballerina.stdlib.protobuf.exceptions.AnnotationUnavailableException;
import io.ballerina.stdlib.protobuf.nativeimpl.ErrorGenerator;
import io.ballerina.stdlib.protobuf.nativeimpl.Errors;
import io.ballerina.stdlib.protobuf.serializers.SerializeHandler;
import io.ballerina.stdlib.protobuf.utils.Utils;
import java.io.IOException;

public class AnyTypeCreator {
    private AnyTypeCreator() {
    }

    public static BString externGetNameFromRecord(BMap<BString, Object> value) {
        String name = value.getType().getName();
        if ("map".equals(name)) {
            return StringUtils.fromString((String)"google.protobuf.Struct");
        }
        String packageName = value.getType().getPackage().getName();
        if ("Any".equals(name) && "protobuf.types.any".equals(packageName)) {
            return StringUtils.fromString((String)"google.protobuf.Any");
        }
        return StringUtils.fromString((String)name);
    }

    public static Object unpack(BMap<BString, Object> value, BTypedesc targetTypeDesc) {
        Type targetType = targetTypeDesc.getDescribingType();
        int expectedTypeTag = TypeUtils.getReferredType((Type)targetType).getTag();
        String typeUrl = value.getStringValue(StringUtils.fromString((String)"typeUrl")).getValue();
        if (Utils.isMatchingType(typeUrl, expectedTypeTag)) {
            try {
                switch (typeUrl) {
                    case "type.googleapis.com/google.protobuf.DoubleValue": 
                    case "type.googleapis.com/google.protobuf.FloatValue": 
                    case "type.googleapis.com/google.protobuf.Int64Value": 
                    case "type.googleapis.com/google.protobuf.UInt64Value": 
                    case "type.googleapis.com/google.protobuf.Int32Value": 
                    case "type.googleapis.com/google.protobuf.UInt32Value": 
                    case "type.googleapis.com/google.protobuf.BoolValue": 
                    case "type.googleapis.com/google.protobuf.StringValue": 
                    case "type.googleapis.com/google.protobuf.BytesValue": {
                        Descriptors.Descriptor descriptor = WrappersProto.getDescriptor().findMessageTypeByName(Utils.getMessageNameFromTypeUrl(typeUrl));
                        DeserializeHandler deserializeHandler = new DeserializeHandler(descriptor, value.getStringValue(StringUtils.fromString((String)"value")).getValue(), TypeUtils.getReferredType((Type)targetType), null);
                        deserializeHandler.deserialize();
                        return deserializeHandler.getBMessage();
                    }
                    case "type.googleapis.com/google.protobuf.Empty": {
                        return null;
                    }
                    case "type.googleapis.com/google.protobuf.Timestamp": {
                        Descriptors.Descriptor timestampDescriptor = Timestamp.getDescriptor();
                        DeserializeHandler timestampDeserializeHandler = new DeserializeHandler(timestampDescriptor, value.getStringValue(StringUtils.fromString((String)"value")).getValue(), TypeUtils.getReferredType((Type)targetType), TypeUtils.getReferredType((Type)targetType));
                        timestampDeserializeHandler.deserialize();
                        BArray utcTime = (BArray)timestampDeserializeHandler.getBMessage();
                        utcTime.freezeDirect();
                        return utcTime;
                    }
                    case "type.googleapis.com/google.protobuf.Duration": {
                        Descriptors.Descriptor durationDescriptor = Duration.getDescriptor();
                        DeserializeHandler durationDeserializeHandler = new DeserializeHandler(durationDescriptor, value.getStringValue(StringUtils.fromString((String)"value")).getValue(), TypeUtils.getReferredType((Type)targetType), TypeUtils.getReferredType((Type)targetType));
                        durationDeserializeHandler.deserialize();
                        return durationDeserializeHandler.getBMessage();
                    }
                    case "type.googleapis.com/google.protobuf.Struct": {
                        Descriptors.Descriptor structDescriptor = Struct.getDescriptor();
                        DeserializeHandler structDeserializeHandler = new DeserializeHandler(structDescriptor, value.getStringValue(StringUtils.fromString((String)"value")).getValue(), TypeUtils.getReferredType((Type)targetType), TypeUtils.getReferredType((Type)targetType));
                        structDeserializeHandler.deserialize();
                        return structDeserializeHandler.getBMessage();
                    }
                    case "type.googleapis.com/google.protobuf.Any": {
                        Descriptors.Descriptor anyDescriptor = Any.getDescriptor();
                        DeserializeHandler anyDeserializeHandler = new DeserializeHandler(anyDescriptor, value.getStringValue(StringUtils.fromString((String)"value")).getValue(), TypeUtils.getReferredType((Type)targetType), TypeUtils.getReferredType((Type)targetType));
                        return anyDeserializeHandler.getBMessage();
                    }
                }
            }
            catch (Descriptors.DescriptorValidationException | AnnotationUnavailableException | IOException e) {
                return ErrorGenerator.createError(Errors.TypeMismatchError, e.toString());
            }
        }
        if (expectedTypeTag == 24) {
            if (value.get((Object)StringUtils.fromString((String)"value")) instanceof BString) {
                try {
                    Object data = Utils.deserialize(TypeUtils.getReferredType((Type)targetType), (RecordType)TypeUtils.getReferredType((Type)targetType), value.getStringValue(StringUtils.fromString((String)"value")).getValue());
                    return AnyTypeCreator.cloneWithType(data, targetType);
                }
                catch (Descriptors.DescriptorValidationException | IOException e) {
                    return ErrorGenerator.createError(Errors.TypeMismatchError, e.toString());
                }
                catch (AnnotationUnavailableException e) {
                    return ErrorGenerator.createError(Errors.TypeMismatchError, e.getMessage());
                }
            }
            return AnyTypeCreator.cloneWithType(value.getMapValue(StringUtils.fromString((String)"value")), targetType);
        }
        String errorMessage = "Type " + typeUrl + " cannot unpack to " + TypeUtils.getReferredType((Type)targetType).getName();
        return ErrorGenerator.createError(Errors.TypeMismatchError, errorMessage);
    }

    private static Object cloneWithType(Object value, Type targetType) {
        try {
            return ValueUtils.convert((Object)value, (Type)targetType);
        }
        catch (BError e) {
            return e;
        }
    }

    public static Object getSerializedString(Object value, BString bTypeUrl) {
        String typeUrl = bTypeUrl.getValue();
        Descriptors.Descriptor descriptor = null;
        try {
            switch (typeUrl) {
                case "type.googleapis.com/google.protobuf.DoubleValue": 
                case "type.googleapis.com/google.protobuf.FloatValue": 
                case "type.googleapis.com/google.protobuf.Int64Value": 
                case "type.googleapis.com/google.protobuf.UInt64Value": 
                case "type.googleapis.com/google.protobuf.Int32Value": 
                case "type.googleapis.com/google.protobuf.UInt32Value": 
                case "type.googleapis.com/google.protobuf.BoolValue": 
                case "type.googleapis.com/google.protobuf.StringValue": 
                case "type.googleapis.com/google.protobuf.BytesValue": {
                    descriptor = WrappersProto.getDescriptor().findMessageTypeByName(Utils.getMessageNameFromTypeUrl(typeUrl));
                    break;
                }
                case "type.googleapis.com/google.protobuf.Empty": {
                    return StringUtils.fromString((String)"");
                }
                case "type.googleapis.com/google.protobuf.Timestamp": {
                    descriptor = Timestamp.getDescriptor();
                    break;
                }
                case "type.googleapis.com/google.protobuf.Duration": {
                    descriptor = Duration.getDescriptor();
                    break;
                }
                case "type.googleapis.com/google.protobuf.Struct": {
                    descriptor = Struct.getDescriptor();
                    break;
                }
                case "type.googleapis.com/google.protobuf.Any": {
                    descriptor = Any.getDescriptor();
                    break;
                }
                default: {
                    descriptor = Utils.getAnnotatedDescriptorFromRecord(value);
                }
            }
            SerializeHandler serializeHandler = new SerializeHandler(descriptor, value);
            serializeHandler.serialize();
            return serializeHandler.getContentAsBString();
        }
        catch (Descriptors.DescriptorValidationException | AnnotationUnavailableException | IOException e) {
            return ErrorGenerator.createError(Errors.TypeMismatchError, e.toString());
        }
    }
}

