/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.protobuf.serializers;

import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.protobuf.messages.BMessage;
import io.ballerina.stdlib.protobuf.serializers.AbstractSerializer;
import java.io.IOException;

public class StringSerializer
extends AbstractSerializer {
    public StringSerializer(CodedOutputStream output, Descriptors.FieldDescriptor fieldDescriptor, BMessage bMessage) {
        super(output, fieldDescriptor, bMessage);
    }

    @Override
    public void computeMessageSize() {
        if (this.isBMap()) {
            BMap bMap = (BMap)this.bMessage.getContent();
            if (bMap.containsKey((Object)this.bFieldName)) {
                Object bValue = bMap.get((Object)this.bFieldName);
                if (bValue instanceof BArray) {
                    BArray valueArray = (BArray)bValue;
                    for (int i = 0; i < valueArray.size(); ++i) {
                        this.bMessage.incrementSize(this.computeMessageSize(valueArray.getBString((long)i).getValue()));
                    }
                } else {
                    this.bMessage.incrementSize(this.computeMessageSize(((BString)bValue).getValue()));
                }
            }
        } else if (this.isBArray() && this.fieldDescriptor.getFullName().equals("google.protobuf.Struct.FieldsEntry.key")) {
            this.bMessage.incrementSize(this.computeMessageSize(((BArray)this.bMessage.getContent()).getBString(0L).getValue()));
        } else if (this.bMessage.getContent() instanceof BString) {
            this.bMessage.incrementSize(this.computeMessageSize(((BString)this.bMessage.getContent()).getValue()));
        } else if ("Any".equals(this.messageName)) {
            this.bMessage.incrementSize(this.computeMessageSize(((BMap)this.bMessage.getContent()).getStringValue(StringUtils.fromString((String)"typeUrl")).getValue()));
        }
    }

    @Override
    public void serialize() throws IOException {
        if (this.isBMap()) {
            BMap bMap = (BMap)this.bMessage.getContent();
            if (bMap.containsKey((Object)this.bFieldName)) {
                Object bValue = bMap.get((Object)this.bFieldName);
                if (bValue instanceof BArray) {
                    BArray valueArray = (BArray)bValue;
                    for (int i = 0; i < valueArray.size(); ++i) {
                        this.writeContent(valueArray.getBString((long)i).getValue());
                    }
                } else {
                    this.writeContent(((BString)bValue).getValue());
                }
            }
        } else if (this.isBArray() && this.fieldDescriptor.getFullName().equals("google.protobuf.Struct.FieldsEntry.key")) {
            BArray bArray = (BArray)this.bMessage.getContent();
            this.writeContent(((BString)bArray.get(0L)).getValue());
        } else if (this.bMessage.getContent() instanceof BString && !this.fieldDescriptor.getFullName().equals("google.protobuf.Any.type_url")) {
            this.writeContent(((BString)this.bMessage.getContent()).getValue());
        } else if ("Any".equals(this.messageName)) {
            this.writeContent(((BMap)this.bMessage.getContent()).getStringValue(StringUtils.fromString((String)"typeUrl")).getValue());
        }
    }

    private int computeMessageSize(String value) {
        return CodedOutputStream.computeStringSize((int)this.fieldDescriptor.getNumber(), (String)value);
    }

    private void writeContent(String content) throws IOException {
        this.output.writeString(this.fieldDescriptor.getNumber(), content);
    }
}

