/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.compiler.service.validator;

import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.stdlib.graphql.compiler.FinderContext;
import io.ballerina.stdlib.graphql.compiler.service.validator.RecordTypeDefinitionNodeVisitor;
import java.util.ArrayList;
import java.util.Optional;

public class RecordTypeDefinitionNodeFinder {
    private final FinderContext context;
    private final RecordTypeSymbol recordTypeSymbol;
    private final String recordTypeName;

    public RecordTypeDefinitionNodeFinder(FinderContext context, RecordTypeSymbol recordTypeSymbol, String recordTypeName) {
        this.context = context;
        this.recordTypeSymbol = recordTypeSymbol;
        this.recordTypeName = recordTypeName;
    }

    public Optional<TypeDefinitionNode> find() {
        Module currentModule = this.context.project().currentPackage().module(this.context.moduleId());
        ArrayList documentIds = new ArrayList(currentModule.documentIds());
        documentIds.addAll(currentModule.testDocumentIds());
        RecordTypeDefinitionNodeVisitor visitor = new RecordTypeDefinitionNodeVisitor(this.context.semanticModel(), this.recordTypeSymbol, this.recordTypeName);
        for (DocumentId documentId : documentIds) {
            Node rootNode = currentModule.document(documentId).syntaxTree().rootNode();
            rootNode.accept((NodeVisitor)visitor);
            Optional<TypeDefinitionNode> typeDefinitionNode = visitor.getRecordTypeDefinitionNode();
            if (!typeDefinitionNode.isPresent()) continue;
            return typeDefinitionNode;
        }
        return Optional.empty();
    }
}

