/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.metainfo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResourceMetaInfoAnnotation {
    String summary;
    String operationId;
    List<String> tags;
    Map<String, Map<String, Map<String, Object>>> responseExamples;
    Map<String, Map<String, Object>> requestExamples;

    private ResourceMetaInfoAnnotation(Builder builder) {
        this.summary = builder.summary;
        this.operationId = builder.operationId;
        this.tags = builder.tags;
        this.responseExamples = builder.responseExamples;
        this.requestExamples = builder.requestExamples;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Map<String, Map<String, Map<String, Object>>> getResponseExamples() {
        return this.responseExamples;
    }

    public Map<String, Map<String, Object>> getRequestExamples() {
        return this.requestExamples;
    }

    public static class Builder {
        private String summary;
        private String operationId;
        private List<String> tags = new ArrayList<String>();
        private Map<String, Map<String, Map<String, Object>>> responseExamples = new HashMap<String, Map<String, Map<String, Object>>>();
        private Map<String, Map<String, Object>> requestExamples = new HashMap<String, Map<String, Object>>();

        public Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public Builder tags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public Builder responseExamples(Map<String, Map<String, Map<String, Object>>> responseExamples) {
            this.responseExamples = responseExamples;
            return this;
        }

        public Builder requestExamples(Map<String, Map<String, Object>> requestExamples) {
            this.requestExamples = requestExamples;
            return this;
        }

        public ResourceMetaInfoAnnotation build() {
            return new ResourceMetaInfoAnnotation(this);
        }
    }
}

