/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.model;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.ConstantDeclarationNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ListenerDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.openapi.service.mapper.model.ServiceContractType;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class ModuleMemberVisitor
extends NodeVisitor {
    Map<String, TypeDefinitionNode> typeDefinitionNodes = new LinkedHashMap<String, TypeDefinitionNode>();
    Map<String, ListenerDeclarationNode> listenerDeclarations = new LinkedHashMap<String, ListenerDeclarationNode>();
    Map<String, ClassDefinitionNode> interceptorServiceClassNodes = new LinkedHashMap<String, ClassDefinitionNode>();
    Map<String, ServiceContractType> serviceContractTypes = new LinkedHashMap<String, ServiceContractType>();
    Map<String, VariableDeclaredValue> variableDeclarations = new LinkedHashMap<String, VariableDeclaredValue>();
    SemanticModel semanticModel;

    public ModuleMemberVisitor(SemanticModel semanticModel) {
        this.semanticModel = semanticModel;
    }

    public void visit(TypeDefinitionNode typeDefinitionNode) {
        String typeName = MapperCommonUtils.unescapeIdentifier(typeDefinitionNode.typeName().text());
        this.typeDefinitionNodes.put(typeName, typeDefinitionNode);
        Node descriptorNode = MapperCommonUtils.getTypeDescriptor(typeDefinitionNode);
        if (descriptorNode.kind().equals((Object)SyntaxKind.OBJECT_TYPE_DESC) && MapperCommonUtils.isHttpServiceContract(descriptorNode, this.semanticModel)) {
            this.serviceContractTypes.put(typeName, new ServiceContractType(typeDefinitionNode));
        }
    }

    public void visit(ListenerDeclarationNode listenerDeclarationNode) {
        String listenerName = MapperCommonUtils.unescapeIdentifier(listenerDeclarationNode.variableName().text());
        this.listenerDeclarations.put(listenerName, listenerDeclarationNode);
    }

    public void visit(ClassDefinitionNode classDefinitionNode) {
        String className = MapperCommonUtils.unescapeIdentifier(classDefinitionNode.className().text());
        this.interceptorServiceClassNodes.put(className, classDefinitionNode);
    }

    public void visit(ModuleVariableDeclarationNode moduleVariableDeclarationNode) {
        TypedBindingPatternNode typedBindingPatternNode = moduleVariableDeclarationNode.typedBindingPattern();
        TypeDescriptorNode typeDescriptorNode = typedBindingPatternNode.typeDescriptor();
        BindingPatternNode bindingPatternNode = typedBindingPatternNode.bindingPattern();
        if (!bindingPatternNode.kind().equals((Object)SyntaxKind.CAPTURE_BINDING_PATTERN) || !typeDescriptorNode.kind().equals((Object)SyntaxKind.INT_TYPE_DESC) && !typeDescriptorNode.kind().equals((Object)SyntaxKind.VAR_TYPE_DESC)) {
            return;
        }
        CaptureBindingPatternNode captureBindingPatternNode = (CaptureBindingPatternNode)bindingPatternNode;
        if (captureBindingPatternNode.variableName().isMissing()) {
            return;
        }
        String variableName = MapperCommonUtils.unescapeIdentifier(captureBindingPatternNode.variableName().text());
        Optional variableValue = moduleVariableDeclarationNode.initializer();
        boolean isConfigurable = moduleVariableDeclarationNode.qualifiers().stream().anyMatch(token -> token.kind().equals((Object)SyntaxKind.CONFIGURABLE_KEYWORD));
        variableValue.ifPresent(expressionNode -> this.variableDeclarations.put(variableName, new VariableDeclaredValue((ExpressionNode)expressionNode, isConfigurable)));
    }

    public void visit(ConstantDeclarationNode constantDeclarationNode) {
        String variableName = MapperCommonUtils.unescapeIdentifier(constantDeclarationNode.variableName().text());
        Node variableValue = constantDeclarationNode.initializer();
        if (variableValue instanceof ExpressionNode) {
            ExpressionNode valueExpression = (ExpressionNode)variableValue;
            this.variableDeclarations.put(variableName, new VariableDeclaredValue(valueExpression, false));
        }
    }

    public Optional<ListenerDeclarationNode> getListenerDeclaration(String listenerName) {
        if (this.listenerDeclarations.containsKey(listenerName)) {
            return Optional.of(this.listenerDeclarations.get(listenerName));
        }
        return Optional.empty();
    }

    public Optional<TypeDefinitionNode> getTypeDefinitionNode(String typeName) {
        if (this.typeDefinitionNodes.containsKey(typeName)) {
            return Optional.of(this.typeDefinitionNodes.get(typeName));
        }
        return Optional.empty();
    }

    public Optional<ClassDefinitionNode> getInterceptorServiceClassNode(String typeName) {
        if (this.interceptorServiceClassNodes.containsKey(typeName)) {
            return Optional.of(this.interceptorServiceClassNodes.get(typeName));
        }
        return Optional.empty();
    }

    public Optional<VariableDeclaredValue> getVariableDeclaredValue(String variableName) {
        if (this.variableDeclarations.containsKey(variableName)) {
            return Optional.of(this.variableDeclarations.get(variableName));
        }
        return Optional.empty();
    }

    public Optional<ServiceContractType> getServiceContractType(String typeName) {
        if (this.serviceContractTypes.containsKey(typeName)) {
            return Optional.of(this.serviceContractTypes.get(typeName));
        }
        return Optional.empty();
    }

    public record VariableDeclaredValue(ExpressionNode value, boolean isConfigurable) {
    }
}

