/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.response;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.openapi.service.mapper.Constants;
import io.ballerina.openapi.service.mapper.ServiceMapperFactory;
import io.ballerina.openapi.service.mapper.model.AdditionalData;
import io.ballerina.openapi.service.mapper.model.OperationInventory;
import io.ballerina.openapi.service.mapper.model.ResourceFunction;
import io.ballerina.openapi.service.mapper.response.ResponseMapper;
import io.ballerina.openapi.service.mapper.response.model.CacheConfigAnnotation;
import io.ballerina.openapi.service.mapper.response.model.ResponseInfo;
import io.ballerina.openapi.service.mapper.response.utils.CacheHeaderUtils;
import io.ballerina.openapi.service.mapper.response.utils.StatusCodeErrorUtils;
import io.ballerina.openapi.service.mapper.response.utils.StatusCodeResponseUtils;
import io.ballerina.openapi.service.mapper.type.TypeMapper;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import io.ballerina.openapi.service.mapper.utils.MediaTypeUtils;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DefaultResponseMapper
implements ResponseMapper {
    private final TypeMapper typeMapper;
    protected final SemanticModel semanticModel;
    private List<String> allowedMediaTypes = new ArrayList<String>();
    private final Map<String, Header> cacheHeaders = new HashMap<String, Header>();
    private final Map<String, Map<String, Header>> headersMap = new HashMap<String, Map<String, Header>>();
    private final String mediaTypeSubTypePrefix;
    private final ApiResponses apiResponses = new ApiResponses();
    private final OperationInventory operationInventory;
    private final ResourceFunction resourceNode;

    public DefaultResponseMapper(ResourceFunction resourceNode, OperationInventory operationInventory, AdditionalData additionalData, ServiceMapperFactory serviceMapperFactory) {
        this.typeMapper = serviceMapperFactory.getTypeMapper();
        this.mediaTypeSubTypePrefix = MediaTypeUtils.extractCustomMediaType(resourceNode).orElse("");
        this.semanticModel = additionalData.semanticModel();
        this.operationInventory = operationInventory;
        this.resourceNode = resourceNode;
    }

    private void generateApiResponses(ResourceFunction resourceNode, OperationInventory operationInventory) {
        this.extractAnnotationDetails(resourceNode);
        String defaultStatusCode = operationInventory.getHttpOperation().equalsIgnoreCase("POST") ? "201" : "200";
        TypeSymbol returnTypeSymbol = this.getReturnTypeSymbol(resourceNode);
        this.createResponseMapping(returnTypeSymbol, defaultStatusCode);
        this.checkForDataBindingFailures(operationInventory);
    }

    protected void checkForDataBindingFailures(OperationInventory operationInventory) {
        if (operationInventory.hasDataBinding()) {
            this.addResponseMappingForDataBindingFailures();
        }
    }

    @Override
    public void setApiResponses() {
        this.generateApiResponses(this.resourceNode, this.operationInventory);
        this.operationInventory.setApiResponses(this.apiResponses);
    }

    protected TypeSymbol getReturnTypeSymbol(ResourceFunction resourceNode) {
        Symbol symbol;
        Optional<Symbol> symbol2 = resourceNode.getSymbol(this.semanticModel);
        if (symbol2.isEmpty() || !((symbol = symbol2.get()) instanceof ResourceMethodSymbol)) {
            return null;
        }
        ResourceMethodSymbol resourceMethodSymbol = (ResourceMethodSymbol)symbol;
        Optional returnTypeOpt = resourceMethodSymbol.typeDescriptor().returnTypeDescriptor();
        return returnTypeOpt.orElse(null);
    }

    private void extractAnnotationDetails(ResourceFunction resource) {
        ReturnTypeDescriptorNode returnNode;
        NodeList annotations;
        FunctionSignatureNode functionSignature = resource.functionSignature();
        Optional returnTypeDescriptor = functionSignature.returnTypeDesc();
        if (returnTypeDescriptor.isPresent() && !(annotations = (returnNode = (ReturnTypeDescriptorNode)returnTypeDescriptor.get()).annotations()).isEmpty()) {
            for (AnnotationNode annotation : annotations) {
                if (annotation.annotReference().toString().trim().equals("http:Cache")) {
                    CacheConfigAnnotation cacheConfigAnn = new CacheConfigAnnotation();
                    annotation.annotValue().ifPresentOrElse(value -> CacheHeaderUtils.updateResponseHeaderWithCacheValues(this.cacheHeaders, CacheHeaderUtils.setCacheConfigValues((SeparatedNodeList<MappingFieldNode>)value.fields())), () -> CacheHeaderUtils.updateResponseHeaderWithCacheValues(this.cacheHeaders, cacheConfigAnn));
                    continue;
                }
                if (!annotation.annotReference().toString().trim().equals("http:Payload")) continue;
                this.allowedMediaTypes = MapperCommonUtils.extractAnnotationFieldDetails("http:Payload", "mediaType", annotation, this.semanticModel);
            }
        }
    }

    protected void createResponseMapping(TypeSymbol returnType, String defaultStatusCode) {
        this.createResponseMappingInternal(returnType, defaultStatusCode);
    }

    private void createResponseMappingInternal(TypeSymbol returnType, String defaultStatusCode) {
        if (Objects.isNull(returnType)) {
            return;
        }
        Optional<UnionTypeSymbol> unionTypeOpt = DefaultResponseMapper.getUnionType(returnType, this.semanticModel);
        if (unionTypeOpt.isPresent()) {
            this.addResponseMappingForUnion(defaultStatusCode, unionTypeOpt.get());
        } else {
            this.addResponseMappingForSimpleType(returnType, defaultStatusCode);
        }
    }

    private static Optional<UnionTypeSymbol> getUnionType(TypeSymbol typeSymbol, SemanticModel semanticModel) {
        if (Objects.isNull(typeSymbol)) {
            return Optional.empty();
        }
        return switch (typeSymbol.typeKind()) {
            case TypeDescKind.UNION -> Optional.of((UnionTypeSymbol)typeSymbol);
            case TypeDescKind.TYPE_REFERENCE -> {
                if (MediaTypeUtils.getInstance(semanticModel).isSameMediaType(typeSymbol)) {
                    yield Optional.empty();
                }
                yield DefaultResponseMapper.getUnionType(((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor(), semanticModel);
            }
            case TypeDescKind.INTERSECTION -> DefaultResponseMapper.getUnionType(((IntersectionTypeSymbol)typeSymbol).effectiveTypeDescriptor(), semanticModel);
            default -> Optional.empty();
        };
    }

    private void addResponseMappingForUnion(String defaultStatusCode, UnionTypeSymbol unionType) {
        Map<String, Map<String, TypeSymbol>> responseCodeMap = this.getResponseCodeMap(unionType, defaultStatusCode);
        for (Map.Entry<String, Map<String, TypeSymbol>> mediaTypeEntry : responseCodeMap.entrySet()) {
            Map<String, TypeSymbol> mediaTypes = mediaTypeEntry.getValue();
            String responseCode = mediaTypeEntry.getKey();
            for (Map.Entry<String, TypeSymbol> entry : mediaTypes.entrySet()) {
                TypeSymbol typeSymbol = entry.getValue();
                if (DefaultResponseMapper.isSubTypeOfNil(typeSymbol, this.semanticModel)) {
                    this.addResponseMappingForNil();
                    continue;
                }
                if (DefaultResponseMapper.isSubTypeOfHttpResponse(typeSymbol, this.semanticModel)) {
                    this.addResponseMappingForHttpResponse();
                    continue;
                }
                String mediaType = entry.getKey();
                ApiResponse apiResponse = new ApiResponse();
                this.addResponseContent(typeSymbol, apiResponse, mediaType);
                this.addApiResponse(apiResponse, responseCode);
            }
        }
    }

    private void addHeaders(ApiResponse apiResponse, String statusCode) {
        HashMap<String, Header> headers = new HashMap<String, Header>();
        if (!this.cacheHeaders.isEmpty() && DefaultResponseMapper.isSuccessStatusCode(statusCode)) {
            headers.putAll(this.cacheHeaders);
        }
        if (this.headersMap.containsKey(statusCode)) {
            headers.putAll(this.headersMap.get(statusCode));
        }
        if (!headers.isEmpty()) {
            apiResponse.setHeaders(headers);
        }
    }

    private void addResponseContent(TypeSymbol returnType, ApiResponse apiResponse, String mediaType) {
        if (!DefaultResponseMapper.isPlainAnyDataType(returnType)) {
            MediaType mediaTypeObj = new MediaType();
            mediaTypeObj.setSchema(this.typeMapper.getTypeSchema(returnType));
            this.updateApiResponseContentWithMediaType(apiResponse, mediaType, mediaTypeObj);
        }
    }

    public void addApiResponse(ApiResponse apiResponse, String statusCode) {
        this.addHeaders(apiResponse, statusCode);
        if (this.apiResponses.containsKey((Object)statusCode)) {
            this.updateExistingApiResponse(apiResponse, statusCode);
        } else {
            if (Objects.isNull(apiResponse.getDescription())) {
                apiResponse.setDescription(Constants.HTTP_CODE_DESCRIPTIONS.get(statusCode));
            }
            this.apiResponses.put((Object)statusCode, (Object)apiResponse);
        }
    }

    private void updateExistingApiResponse(ApiResponse apiResponse, String statusCode) {
        ApiResponse existingRes = (ApiResponse)this.apiResponses.get((Object)statusCode);
        Content newContent = apiResponse.getContent();
        if (Objects.nonNull(newContent)) {
            Content content = existingRes.getContent();
            if (Objects.isNull(content)) {
                existingRes.setContent(newContent);
            } else {
                this.updateApiResponseContentWithMediaType(existingRes, (String)newContent.keySet().iterator().next(), (MediaType)newContent.values().iterator().next());
            }
        }
        this.apiResponses.put((Object)statusCode, (Object)existingRes);
    }

    private void updateApiResponseContentWithMediaType(ApiResponse apiResponse, String mediaType, MediaType mediaTypeObj) {
        Content content = apiResponse.getContent();
        if (Objects.isNull(content)) {
            content = new Content();
        }
        if (content.containsKey((Object)mediaType) && Objects.nonNull(((MediaType)content.get((Object)mediaType)).getSchema())) {
            MediaType existingMediaType = (MediaType)content.get((Object)mediaType);
            if (Objects.nonNull(mediaTypeObj.getSchema()) && !existingMediaType.getSchema().equals((Object)mediaTypeObj.getSchema())) {
                DefaultResponseMapper.updateContentWithSameMediaType(mediaTypeObj, existingMediaType);
            }
        } else {
            content.addMediaType(mediaType, mediaTypeObj);
        }
        apiResponse.setContent(content);
    }

    private static void updateContentWithSameMediaType(MediaType mediaTypeObj, MediaType existingMediaType) {
        Schema schema = existingMediaType.getSchema();
        if (schema instanceof ComposedSchema) {
            ComposedSchema existingSchema = (ComposedSchema)schema;
            DefaultResponseMapper.updateContentOnComposedSchema(mediaTypeObj, existingSchema);
        } else {
            DefaultResponseMapper.updateContentWithComposedSchema(mediaTypeObj, existingMediaType);
        }
    }

    private static void updateContentWithComposedSchema(MediaType mediaTypeObj, MediaType existingMediaType) {
        Schema schema = mediaTypeObj.getSchema();
        if (schema instanceof ComposedSchema) {
            ComposedSchema mediaTypeSchema = (ComposedSchema)schema;
            if (!mediaTypeSchema.getOneOf().contains(existingMediaType.getSchema())) {
                mediaTypeSchema.getOneOf().add(existingMediaType.getSchema());
            }
            existingMediaType.setSchema((Schema)mediaTypeSchema);
        } else {
            Schema updatedSchema = new ComposedSchema().oneOf(List.of(existingMediaType.getSchema(), mediaTypeObj.getSchema()));
            existingMediaType.setSchema(updatedSchema);
        }
    }

    private static void updateContentOnComposedSchema(MediaType mediaTypeObj, ComposedSchema existingSchema) {
        List oneOf = existingSchema.getOneOf();
        Schema schema = mediaTypeObj.getSchema();
        if (schema instanceof ComposedSchema) {
            ComposedSchema mediaTypeSchema = (ComposedSchema)schema;
            List mediaTypeOneOf = mediaTypeSchema.getOneOf();
            for (Schema schema2 : mediaTypeOneOf) {
                if (oneOf.contains(schema2)) continue;
                oneOf.add(schema2);
            }
            existingSchema.setOneOf(oneOf);
        } else if (!oneOf.contains(mediaTypeObj.getSchema())) {
            oneOf.add(mediaTypeObj.getSchema());
            existingSchema.setOneOf(oneOf);
        }
    }

    private void addResponseMappingForNil() {
        ApiResponse apiResponse = this.getApiResponse("202");
        this.addApiResponse(apiResponse, "202");
    }

    void addResponseMappingForDataBindingFailures() {
        ApiResponse apiResponse = this.getApiResponse("400");
        TypeSymbol errorType = this.semanticModel.types().ERROR;
        this.addResponseContent(errorType, apiResponse, "application/json");
        this.addApiResponse(apiResponse, "400");
    }

    private void addResponseMappingForHttpResponse() {
        MediaType mediaTypeObj = new MediaType();
        mediaTypeObj.setSchema(new Schema().description("Any type of entity body"));
        ApiResponse apiResponse = this.getApiResponse("default");
        apiResponse.setDescription("Any Response");
        apiResponse.setContent(new Content().addMediaType("*/*", mediaTypeObj));
        this.addApiResponse(apiResponse, "default");
    }

    private ApiResponse getApiResponse(String statusCode) {
        if (this.apiResponses.containsKey((Object)statusCode)) {
            return (ApiResponse)this.apiResponses.get((Object)statusCode);
        }
        ApiResponse apiResponse = new ApiResponse();
        apiResponse.setDescription(Constants.HTTP_CODE_DESCRIPTIONS.get(statusCode));
        return apiResponse;
    }

    private void addResponseMappingForSimpleType(TypeSymbol returnType, String defaultStatusCode) {
        if (DefaultResponseMapper.isSubTypeOfNil(returnType, this.semanticModel)) {
            this.addResponseMappingForNil();
        } else if (DefaultResponseMapper.isSubTypeOfHttpResponse(returnType, this.semanticModel)) {
            this.addResponseMappingForHttpResponse();
        } else if (StatusCodeResponseUtils.isSubTypeOfHttpStatusCodeResponse(returnType, this.semanticModel)) {
            ResponseInfo responseInfo = StatusCodeResponseUtils.extractResponseInfo(returnType, defaultStatusCode, this.typeMapper, this.semanticModel);
            this.updateApiResponseWithResponseInfo(responseInfo);
        } else if (StatusCodeErrorUtils.isSubTypeOfHttpStatusCodeError(returnType, this.semanticModel)) {
            ResponseInfo responseInfo = StatusCodeErrorUtils.extractResponseInfo(returnType, this.typeMapper, this.semanticModel);
            this.updateApiResponseWithResponseInfo(responseInfo);
        } else {
            ApiResponse apiResponse = new ApiResponse();
            String mediaType = MediaTypeUtils.getInstance(this.semanticModel).getMediaTypeFromType(returnType, this.mediaTypeSubTypePrefix, this.allowedMediaTypes);
            this.addResponseContent(returnType, apiResponse, mediaType);
            String statusCode = DefaultResponseMapper.getResponseCode(returnType, defaultStatusCode, this.semanticModel);
            apiResponse.description(Constants.HTTP_CODE_DESCRIPTIONS.get(statusCode));
            this.addApiResponse(apiResponse, statusCode);
        }
    }

    private void updateApiResponseWithResponseInfo(ResponseInfo responseInfo) {
        this.updateHeaderMap(responseInfo.statusCode(), responseInfo.headers());
        this.createResponseMappingInternal(responseInfo.bodyType(), responseInfo.statusCode());
    }

    public Map<String, Map<String, TypeSymbol>> getResponseCodeMap(UnionTypeSymbol typeSymbol, String defaultCode) {
        HashMap<String, Map<String, List<TypeSymbol>>> responsesCodeMap = new HashMap<String, Map<String, List<TypeSymbol>>>();
        this.extractBasicMembers((TypeSymbol)typeSymbol, defaultCode, responsesCodeMap);
        HashMap<String, Map<String, TypeSymbol>> responseCodeMap = new HashMap<String, Map<String, TypeSymbol>>();
        for (Map.Entry mediaTypeEntry : responsesCodeMap.entrySet()) {
            Map mediaTypes = (Map)mediaTypeEntry.getValue();
            String code = (String)mediaTypeEntry.getKey();
            for (Map.Entry entry : mediaTypes.entrySet()) {
                List typeSymbols = (List)entry.getValue();
                String mediaType = (String)entry.getKey();
                if (typeSymbols.size() == 1) {
                    this.updateResponseCodeMap(responseCodeMap, code, mediaType, (TypeSymbol)typeSymbols.get(0));
                    continue;
                }
                TypeSymbol[] typeSymbolArray = (TypeSymbol[])typeSymbols.toArray(TypeSymbol[]::new);
                UnionTypeSymbol unionTypeSymbol = this.semanticModel.types().builder().UNION_TYPE.withMemberTypes(typeSymbolArray).build();
                this.updateResponseCodeMap(responseCodeMap, code, mediaType, (TypeSymbol)unionTypeSymbol);
            }
        }
        return responseCodeMap;
    }

    private void updateResponseCodeMap(Map<String, Map<String, List<TypeSymbol>>> responsesMap, TypeSymbol typesymbol, String responseCode, String mediaType) {
        if (responsesMap.containsKey(responseCode)) {
            if (responsesMap.get(responseCode).containsKey(mediaType)) {
                if (!responsesMap.get(responseCode).get(mediaType).contains(typesymbol)) {
                    responsesMap.get(responseCode).get(mediaType).add(typesymbol);
                }
            } else {
                ArrayList<TypeSymbol> typeSymbols = new ArrayList<TypeSymbol>();
                typeSymbols.add(typesymbol);
                responsesMap.get(responseCode).put(mediaType, typeSymbols);
            }
        } else {
            ArrayList<TypeSymbol> typeSymbols = new ArrayList<TypeSymbol>();
            typeSymbols.add(typesymbol);
            HashMap<String, ArrayList<TypeSymbol>> mediaTypeMap = new HashMap<String, ArrayList<TypeSymbol>>();
            mediaTypeMap.put(mediaType, typeSymbols);
            responsesMap.put(responseCode, mediaTypeMap);
        }
    }

    private void updateResponseCodeMap(Map<String, Map<String, TypeSymbol>> responseCodeMap, String code, String mediaType, TypeSymbol typeSymbol) {
        if (responseCodeMap.containsKey(code)) {
            responseCodeMap.get(code).put(mediaType, typeSymbol);
        } else {
            responseCodeMap.put(code, new HashMap<String, TypeSymbol>(Map.of(mediaType, typeSymbol)));
        }
    }

    private void extractBasicMembers(TypeSymbol typeSymbol, String defaultCode, Map<String, Map<String, List<TypeSymbol>>> responses) {
        MediaTypeUtils mediaTypeUtils = MediaTypeUtils.getInstance(this.semanticModel);
        if (mediaTypeUtils.isSameMediaType(typeSymbol)) {
            this.updateResponseCodeMapForBasicType(typeSymbol, defaultCode, responses, mediaTypeUtils);
            return;
        }
        Optional<UnionTypeSymbol> unionTypeOpt = DefaultResponseMapper.getUnionType(typeSymbol, this.semanticModel);
        if (unionTypeOpt.isPresent()) {
            this.extractBasicMembersFromUnion(unionTypeOpt.get(), defaultCode, responses);
        } else {
            this.updateResponseCodeMapForBasicType(typeSymbol, defaultCode, responses, mediaTypeUtils);
        }
    }

    private void updateResponseCodeMapForBasicType(TypeSymbol typeSymbol, String defaultCode, Map<String, Map<String, List<TypeSymbol>>> responses, MediaTypeUtils mediaTypeUtils) {
        String mediaType = mediaTypeUtils.getMediaTypeFromType(typeSymbol, this.mediaTypeSubTypePrefix, this.allowedMediaTypes);
        String code = DefaultResponseMapper.getResponseCode(typeSymbol, defaultCode, this.semanticModel);
        this.updateResponseCodeMap(responses, typeSymbol, code, mediaType);
    }

    private void extractBasicMembersFromUnion(UnionTypeSymbol unionType, String defaultCode, Map<String, Map<String, List<TypeSymbol>>> responses) {
        List directMemberTypes = unionType.userSpecifiedMemberTypes();
        for (TypeSymbol directMemberType : directMemberTypes) {
            String code = DefaultResponseMapper.getResponseCode(directMemberType, defaultCode, this.semanticModel);
            ResponseInfo responseInfo = null;
            Optional<UnionTypeSymbol> unionMemberTypeOpt = DefaultResponseMapper.getUnionType(directMemberType, this.semanticModel);
            if (unionMemberTypeOpt.isPresent()) {
                this.extractBasicMembers((TypeSymbol)unionMemberTypeOpt.get(), code, responses);
                continue;
            }
            if (StatusCodeResponseUtils.isSubTypeOfHttpStatusCodeResponse(directMemberType, this.semanticModel)) {
                responseInfo = StatusCodeResponseUtils.extractResponseInfo(directMemberType, code, this.typeMapper, this.semanticModel);
            } else if (StatusCodeErrorUtils.isSubTypeOfHttpStatusCodeError(directMemberType, this.semanticModel)) {
                responseInfo = StatusCodeErrorUtils.extractResponseInfo(directMemberType, this.typeMapper, this.semanticModel);
            }
            if (Objects.nonNull(responseInfo)) {
                code = responseInfo.statusCode();
                if (!responseInfo.headers().isEmpty()) {
                    this.updateHeaderMap(code, responseInfo.headers());
                }
                directMemberType = responseInfo.bodyType();
            }
            this.extractBasicMembers(directMemberType, code, responses);
        }
    }

    private void updateHeaderMap(String code, Map<String, Header> headers) {
        if (this.headersMap.containsKey(code)) {
            this.headersMap.get(code).putAll(headers);
        } else {
            this.headersMap.put(code, headers);
        }
    }

    private static String getResponseCode(TypeSymbol typeSymbol, String defaultCode, SemanticModel semanticModel) {
        if (DefaultResponseMapper.isSubTypeOfNil(typeSymbol, semanticModel)) {
            return "202";
        }
        if (DefaultResponseMapper.isSubTypeOfError(typeSymbol, semanticModel)) {
            return "500";
        }
        return defaultCode;
    }

    private static boolean isSuccessStatusCode(String statusCode) {
        return statusCode.startsWith("2");
    }

    private static boolean isSubTypeOfNil(TypeSymbol typeSymbol, SemanticModel semanticModel) {
        return typeSymbol.subtypeOf(semanticModel.types().NIL);
    }

    private static boolean isPlainAnyDataType(TypeSymbol typeSymbol) {
        return typeSymbol.typeKind().equals((Object)TypeDescKind.ANYDATA);
    }

    private static boolean isSubTypeOfError(TypeSymbol typeSymbol, SemanticModel semanticModel) {
        return typeSymbol.subtypeOf(semanticModel.types().ERROR);
    }

    public static boolean isSubTypeOfHttpResponse(TypeSymbol returnType, SemanticModel semanticModel) {
        Object t;
        Optional optionalRecordSymbol = semanticModel.types().getTypeByName("ballerina", "http", "", "Response");
        if (optionalRecordSymbol.isPresent() && (t = optionalRecordSymbol.get()) instanceof ClassSymbol) {
            ClassSymbol classSymbol = (ClassSymbol)t;
            return returnType.subtypeOf((TypeSymbol)classSymbol);
        }
        return false;
    }
}

