/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.response.utils;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.openapi.service.mapper.response.model.HeaderRecordInfo;
import io.ballerina.openapi.service.mapper.type.TypeMapper;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.Schema;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public abstract class StatusCodeTypeUtils {
    static boolean isSubTypeOfBallerinaModuleType(String type, String moduleName, TypeSymbol typeSymbol, SemanticModel semanticModel) {
        Object t;
        Optional optionalRecordSymbol = semanticModel.types().getTypeByName("ballerina", moduleName, "", type);
        if (optionalRecordSymbol.isPresent() && (t = optionalRecordSymbol.get()) instanceof TypeDefinitionSymbol) {
            TypeDefinitionSymbol recordSymbol = (TypeDefinitionSymbol)t;
            return typeSymbol.subtypeOf(recordSymbol.typeDescriptor());
        }
        return false;
    }

    static Optional<RecordTypeSymbol> getRecordTypeSymbol(TypeSymbol typeSymbol, TypeMapper typeMapper) {
        TypeReferenceTypeSymbol statusCodeResRefType;
        TypeSymbol typeSymbol2;
        TypeSymbol statusCodeResType = typeMapper.getReferredType(typeSymbol);
        if (statusCodeResType instanceof TypeReferenceTypeSymbol && (typeSymbol2 = (statusCodeResRefType = (TypeReferenceTypeSymbol)statusCodeResType).typeDescriptor()) instanceof RecordTypeSymbol) {
            RecordTypeSymbol recordTypeSymbol = (RecordTypeSymbol)typeSymbol2;
            return Optional.of(recordTypeSymbol);
        }
        if (statusCodeResType instanceof RecordTypeSymbol) {
            RecordTypeSymbol recordTypeSymbol = (RecordTypeSymbol)statusCodeResType;
            return Optional.of(recordTypeSymbol);
        }
        return Optional.empty();
    }

    static TypeSymbol getBodyType(RecordTypeSymbol responseRecordType, SemanticModel semanticModel) {
        if (Objects.nonNull(responseRecordType) && responseRecordType.fieldDescriptors().containsKey("body")) {
            return ((RecordFieldSymbol)responseRecordType.fieldDescriptors().get("body")).typeDescriptor();
        }
        return semanticModel.types().ANYDATA;
    }

    static Map<String, Header> getHeaders(RecordTypeSymbol responseRecordType, TypeMapper typeMapper) {
        if (Objects.isNull(responseRecordType)) {
            return new HashMap<String, Header>();
        }
        HeaderRecordInfo headersInfo = StatusCodeTypeUtils.getHeadersInfo(responseRecordType, typeMapper);
        if (Objects.isNull(headersInfo)) {
            return new HashMap<String, Header>();
        }
        HashMap<String, RecordFieldSymbol> recordFieldMap = new HashMap<String, RecordFieldSymbol>(headersInfo.recordType().fieldDescriptors());
        HashSet<String> requiredFields = new HashSet<String>();
        Map<String, Schema> recordFieldsMapping = typeMapper.getSchemaForRecordFields(recordFieldMap, requiredFields, headersInfo.moduleName(), headersInfo.recordName(), false);
        return StatusCodeTypeUtils.mapRecordFieldToHeaders(recordFieldsMapping, requiredFields);
    }

    private static HeaderRecordInfo getHeadersInfo(RecordTypeSymbol responseRecordType, TypeMapper typeMapper) {
        if (responseRecordType.fieldDescriptors().containsKey("headers")) {
            TypeReferenceTypeSymbol headersRefType;
            TypeSymbol typeSymbol;
            TypeSymbol headersType = typeMapper.getReferredType(((RecordFieldSymbol)responseRecordType.fieldDescriptors().get("headers")).typeDescriptor());
            if (Objects.nonNull(headersType) && headersType instanceof TypeReferenceTypeSymbol && (typeSymbol = (headersRefType = (TypeReferenceTypeSymbol)headersType).typeDescriptor()) instanceof RecordTypeSymbol) {
                RecordTypeSymbol recordType = (RecordTypeSymbol)typeSymbol;
                return new HeaderRecordInfo(recordType, MapperCommonUtils.getModuleName((Symbol)headersType), MapperCommonUtils.getTypeName(headersType));
            }
            if (Objects.nonNull(headersType) && headersType instanceof RecordTypeSymbol) {
                RecordTypeSymbol recordType = (RecordTypeSymbol)headersType;
                return new HeaderRecordInfo(recordType, MapperCommonUtils.getModuleName((Symbol)headersType), MapperCommonUtils.getTypeName(headersType));
            }
        }
        return null;
    }

    private static Map<String, Header> mapRecordFieldToHeaders(Map<String, Schema> recordFields, Set<String> requiredFields) {
        HashMap<String, Header> headers = new HashMap<String, Header>();
        for (Map.Entry<String, Schema> entry : recordFields.entrySet()) {
            Header header = new Header();
            header.setSchema(entry.getValue());
            headers.put(entry.getKey(), header);
            if (!requiredFields.contains(entry.getKey())) continue;
            header.setRequired(Boolean.valueOf(true));
        }
        return headers;
    }
}

