/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.type;

import io.ballerina.compiler.api.symbols.ConstantSymbol;
import io.ballerina.compiler.api.symbols.EnumSymbol;
import io.ballerina.compiler.api.symbols.SingletonTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.openapi.service.mapper.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.service.mapper.diagnostic.ExceptionDiagnostic;
import io.ballerina.openapi.service.mapper.diagnostic.OpenAPIMapperDiagnostic;
import io.ballerina.openapi.service.mapper.model.AdditionalData;
import io.ballerina.openapi.service.mapper.type.AbstractTypeMapper;
import io.ballerina.openapi.service.mapper.type.SimpleTypeMapper;
import io.ballerina.openapi.service.mapper.type.TypeMapperImpl;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class UnionTypeMapper
extends AbstractTypeMapper {
    private final boolean isEnumType;

    public UnionTypeMapper(TypeReferenceTypeSymbol typeSymbol, AdditionalData additionalData) {
        super(typeSymbol, additionalData);
        this.isEnumType = UnionTypeMapper.isEnumTypeDefinition(typeSymbol);
    }

    @Override
    public Schema getReferenceSchema(Components components) {
        Schema schema;
        if (this.isEnumType) {
            schema = UnionTypeMapper.getEnumTypeSchema((EnumSymbol)this.typeSymbol.definition());
        } else {
            UnionTypeSymbol unionTypeSymbol = (UnionTypeSymbol)this.typeSymbol.typeDescriptor();
            schema = UnionTypeMapper.getSchema(unionTypeSymbol, components, this.additionalData, false);
        }
        return Objects.nonNull(schema) ? schema.description(this.description) : null;
    }

    public static Schema getSchema(UnionTypeSymbol typeSymbol, Components components, AdditionalData additionalData, boolean skipNilType) {
        Schema schema;
        if (UnionTypeMapper.isUnionOfSingletons(typeSymbol)) {
            return UnionTypeMapper.getSingletonUnionTypeSchema(typeSymbol, additionalData.diagnostics());
        }
        List memberTypeSymbols = typeSymbol.userSpecifiedMemberTypes();
        ArrayList<Schema> memberSchemas = new ArrayList<Schema>();
        boolean nullable = !skipNilType && UnionTypeMapper.hasNilableType((TypeSymbol)typeSymbol);
        for (TypeSymbol memberTypeSymbol : memberTypeSymbols) {
            Schema schema2;
            if (memberTypeSymbol.typeKind().equals((Object)TypeDescKind.NIL) || !Objects.nonNull(schema2 = TypeMapperImpl.getTypeSchema(memberTypeSymbol, components, additionalData, nullable))) continue;
            memberSchemas.add(schema2);
        }
        if (memberSchemas.isEmpty()) {
            return null;
        }
        if (memberSchemas.size() == 1) {
            schema = (Schema)memberSchemas.get(0);
            if (Objects.nonNull(schema.get$ref()) && nullable) {
                schema = new ComposedSchema().allOf(List.of(schema));
            }
        } else {
            schema = new ComposedSchema().oneOf(memberSchemas);
        }
        if (nullable) {
            schema.setNullable(Boolean.valueOf(true));
        }
        return schema;
    }

    static boolean isUnionOfSingletons(UnionTypeSymbol typeSymbol) {
        List memberTypeSymbols = typeSymbol.userSpecifiedMemberTypes();
        return memberTypeSymbols.stream().allMatch(symbol -> symbol.typeKind().equals((Object)TypeDescKind.SINGLETON) || symbol.typeKind().equals((Object)TypeDescKind.NIL));
    }

    public static boolean hasNilableType(TypeSymbol typeSymbol) {
        return switch (typeSymbol.typeKind()) {
            case TypeDescKind.TYPE_REFERENCE -> UnionTypeMapper.hasNilableType(((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor());
            case TypeDescKind.UNION -> {
                List memberTypeSymbols = ((UnionTypeSymbol)typeSymbol).memberTypeDescriptors();
                yield memberTypeSymbols.stream().anyMatch(symbol -> symbol.typeKind().equals((Object)TypeDescKind.NIL));
            }
            case TypeDescKind.NIL -> true;
            default -> false;
        };
    }

    static Schema getSingletonUnionTypeSchema(UnionTypeSymbol typeSymbol, List<OpenAPIMapperDiagnostic> diagnostics) {
        List<TypeSymbol> memberTypeSymbols = typeSymbol.userSpecifiedMemberTypes().stream().filter(symbol -> symbol.typeKind() != TypeDescKind.NIL).toList();
        ArrayList<String> enumValues = new ArrayList<String>();
        boolean nullable = UnionTypeMapper.hasNilableType((TypeSymbol)typeSymbol);
        TypeDescKind enumType = UnionTypeMapper.getEnumType(memberTypeSymbols);
        if (Objects.isNull(enumType)) {
            UnionTypeMapper.addUnsupportedUnionError(typeSymbol, diagnostics);
            return null;
        }
        for (TypeSymbol memberTypeSymbol : memberTypeSymbols) {
            Object enumValue = UnionTypeMapper.getSigletonStringValue((SingletonTypeSymbol)memberTypeSymbol);
            if (!((SingletonTypeSymbol)memberTypeSymbol).originalType().typeKind().equals((Object)TypeDescKind.STRING)) {
                enumValue = MapperCommonUtils.parseBalSimpleLiteral(enumValue.toString());
            }
            enumValues.add((String)enumValue);
        }
        Schema schema = SimpleTypeMapper.getSchema(enumType);
        if (Objects.isNull(schema)) {
            UnionTypeMapper.addUnsupportedUnionError(typeSymbol, diagnostics);
            return null;
        }
        schema.setEnum(enumValues);
        if (nullable) {
            schema.setNullable(Boolean.valueOf(true));
        }
        return schema;
    }

    private static String getSigletonStringValue(SingletonTypeSymbol typeSymbol) {
        String signature = typeSymbol.signature();
        if (typeSymbol instanceof ConstantSymbol) {
            return ((ConstantSymbol)typeSymbol).constValue().toString();
        }
        if (typeSymbol.originalType().typeKind().equals((Object)TypeDescKind.STRING)) {
            return signature.substring(1, signature.length() - 1);
        }
        return signature;
    }

    private static void addUnsupportedUnionError(UnionTypeSymbol typeSymbol, List<OpenAPIMapperDiagnostic> diagnostics) {
        ExceptionDiagnostic error = new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_122, MapperCommonUtils.getTypeName((TypeSymbol)typeSymbol));
        diagnostics.add(error);
    }

    static TypeDescKind getEnumType(List<TypeSymbol> memberTypeSymbols) {
        if (memberTypeSymbols.stream().allMatch(symbol -> ((SingletonTypeSymbol)symbol).originalType().typeKind().equals((Object)TypeDescKind.STRING))) {
            return TypeDescKind.STRING;
        }
        if (memberTypeSymbols.stream().allMatch(symbol -> ((SingletonTypeSymbol)symbol).originalType().typeKind().equals((Object)TypeDescKind.INT))) {
            return TypeDescKind.INT;
        }
        if (memberTypeSymbols.stream().allMatch(symbol -> ((SingletonTypeSymbol)symbol).originalType().typeKind().equals((Object)TypeDescKind.FLOAT))) {
            return TypeDescKind.FLOAT;
        }
        if (memberTypeSymbols.stream().allMatch(symbol -> ((SingletonTypeSymbol)symbol).originalType().typeKind().equals((Object)TypeDescKind.BOOLEAN))) {
            return TypeDescKind.BOOLEAN;
        }
        if (memberTypeSymbols.stream().allMatch(symbol -> ((SingletonTypeSymbol)symbol).originalType().typeKind().equals((Object)TypeDescKind.DECIMAL))) {
            return TypeDescKind.DECIMAL;
        }
        return null;
    }

    static boolean isEnumTypeDefinition(TypeReferenceTypeSymbol typeSymbol) {
        Symbol definitionSymbol = typeSymbol.definition();
        return definitionSymbol.kind().equals((Object)SymbolKind.ENUM);
    }

    static Schema getEnumTypeSchema(EnumSymbol typeSymbol) {
        List enumConstants = typeSymbol.members();
        ArrayList<String> enumValues = new ArrayList<String>();
        for (ConstantSymbol constantSymbol : enumConstants) {
            Object enumValue = constantSymbol.constValue();
            enumValues.add(enumValue.toString());
        }
        return new StringSchema()._enum(enumValues);
    }
}

