/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.mqtt.caller;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.mqtt.caller.CallerThreadFactory;
import io.ballerina.stdlib.mqtt.utils.MqttConstants;
import io.ballerina.stdlib.mqtt.utils.MqttUtils;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.MqttMessage;

public final class CallerActions {
    private static final ExecutorService executorService = Executors.newCachedThreadPool(new CallerThreadFactory());

    private CallerActions() {
    }

    public static Object complete(Environment env, BObject callerObject) {
        MqttClient subscriber = (MqttClient)callerObject.getNativeData("subscriber");
        int messageId = (Integer)callerObject.getNativeData("messageId");
        int qos = (Integer)callerObject.getNativeData("qos");
        return env.yieldAndRun(() -> {
            executorService.execute(() -> {
                try {
                    subscriber.messageArrivedComplete(messageId, qos);
                }
                catch (MqttException e) {
                    throw MqttUtils.createMqttError((Exception)((Object)e));
                }
            });
            return null;
        });
    }

    public static Object respond(Environment env, BObject callerObject, BMap message) {
        MqttClient subscriber = (MqttClient)callerObject.getNativeData("subscriber");
        byte[] correlationData = (byte[])callerObject.getNativeData("correlationData");
        String responseTopic = (String)callerObject.getNativeData(MqttConstants.RESPONSE_TOPIC.getValue());
        MqttMessage mqttMessage = MqttUtils.generateMqttMessage(message);
        if (Objects.isNull(responseTopic)) {
            return MqttUtils.createMqttError(new Exception("Response topic is not set"));
        }
        if (Objects.nonNull(correlationData)) {
            mqttMessage.getProperties().setCorrelationData(correlationData);
        }
        return env.yieldAndRun(() -> {
            executorService.execute(() -> {
                try {
                    subscriber.publish(responseTopic, mqttMessage);
                }
                catch (MqttException e) {
                    throw MqttUtils.createMqttError((Exception)((Object)e));
                }
            });
            return null;
        });
    }
}

