/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.grpc;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.observability.ObserveUtils;
import io.ballerina.runtime.observability.ObserverContext;
import io.ballerina.stdlib.grpc.ClientConnectorListener;
import io.ballerina.stdlib.grpc.Codec;
import io.ballerina.stdlib.grpc.Compressor;
import io.ballerina.stdlib.grpc.CompressorRegistry;
import io.ballerina.stdlib.grpc.DataContext;
import io.ballerina.stdlib.grpc.DecompressorRegistry;
import io.ballerina.stdlib.grpc.Message;
import io.ballerina.stdlib.grpc.MessageUtils;
import io.ballerina.stdlib.grpc.MethodDescriptor;
import io.ballerina.stdlib.grpc.ObservableClientConnectorListener;
import io.ballerina.stdlib.grpc.OutboundMessage;
import io.ballerina.stdlib.grpc.Status;
import io.ballerina.stdlib.grpc.StreamListener;
import io.ballerina.stdlib.grpc.exception.StatusRuntimeException;
import io.ballerina.stdlib.grpc.stubs.AbstractStub;
import io.ballerina.stdlib.http.transport.contract.HttpClientConnector;
import io.ballerina.stdlib.http.transport.contract.HttpConnectorListener;
import io.ballerina.stdlib.http.transport.contract.HttpResponseFuture;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.CancellationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientCall {
    private static final Logger log = LoggerFactory.getLogger(ClientCall.class);
    private final MethodDescriptor method;
    private final boolean unaryRequest;
    private HttpClientConnector connector;
    private DataContext context;
    private final OutboundMessage outboundMessage;
    private ClientConnectorListener connectorListener;
    private boolean cancelCalled;
    private boolean halfCloseCalled;
    private Map<String, Long> messageSizeMap;
    private DecompressorRegistry decompressorRegistry = DecompressorRegistry.getDefaultInstance();
    private CompressorRegistry compressorRegistry = CompressorRegistry.getDefaultInstance();

    public ClientCall(HttpClientConnector connector, OutboundMessage outboundMessage, MethodDescriptor method, DataContext context, Map<String, Long> messageSizeMap) {
        this.method = method;
        this.unaryRequest = method.getType() == MethodDescriptor.MethodType.UNARY || method.getType() == MethodDescriptor.MethodType.SERVER_STREAMING;
        this.connector = connector;
        this.context = context;
        this.outboundMessage = outboundMessage;
        this.messageSizeMap = messageSizeMap;
    }

    private void prepareHeaders(Compressor compressor) {
        ObserverContext observerContext = ObserveUtils.getObserverContextOfCurrentFrame((Environment)this.context.getEnvironment());
        this.outboundMessage.removeHeader("grpc-encoding");
        if (compressor != Codec.Identity.NONE) {
            this.outboundMessage.setHeader("grpc-encoding", compressor.getMessageEncoding());
        }
        String advertisedEncodings = String.join((CharSequence)",", this.decompressorRegistry.getAdvertisedMessageEncodings());
        this.outboundMessage.setHeader("grpc-accept-encoding", advertisedEncodings);
        if (observerContext != null) {
            this.outboundMessage.getHeaders().entries().forEach(x -> observerContext.addTag((String)x.getKey(), (String)x.getValue()));
        }
        this.outboundMessage.setProperty("TO", "/" + this.method.getFullMethodName());
        this.outboundMessage.setHttpMethod();
        this.outboundMessage.setHttpVersion("2.0");
        this.outboundMessage.setHeader("content-type", "application/grpc");
        this.outboundMessage.setHeader("te", "trailers");
    }

    public void injectHeaders(HttpHeaders headers) {
        if (this.outboundMessage != null && headers != null) {
            headers.forEach(entry -> this.outboundMessage.setHeader((String)entry.getKey(), (String)entry.getValue()));
        }
    }

    public void start(AbstractStub.Listener observer) {
        Compressor compressor;
        if (this.connectorListener != null) {
            throw new IllegalStateException("Client connection already set up.");
        }
        if (this.cancelCalled) {
            throw new IllegalStateException("Client call was cancelled.");
        }
        String compressorName = this.outboundMessage.getHeader("grpc-encoding");
        if (compressorName != null) {
            compressor = this.compressorRegistry.lookupCompressor(compressorName);
            if (compressor == null) {
                this.closeObserver(observer, Status.Code.INTERNAL.toStatus().withDescription(String.format("Unable to find compressor by name %s", compressorName)), (HttpHeaders)new DefaultHttpHeaders());
                return;
            }
        } else {
            compressor = Codec.Identity.NONE;
        }
        this.prepareHeaders(compressor);
        ClientStreamListener clientStreamListener = new ClientStreamListener(observer);
        this.connectorListener = ObserveUtils.isObservabilityEnabled() ? new ObservableClientConnectorListener(clientStreamListener, this.context, this.messageSizeMap.get("maxInboundMessageSize")) : new ClientConnectorListener(clientStreamListener, this.messageSizeMap.get("maxInboundMessageSize"));
        this.outboundMessage.framer().setCompressor(compressor);
        this.connectorListener.setDecompressorRegistry(this.decompressorRegistry);
        HttpResponseFuture responseFuture = this.connector.send(this.outboundMessage.getResponseMessage());
        responseFuture.setHttpConnectorListener((HttpConnectorListener)this.connectorListener);
    }

    public void cancel(String message, Throwable cause) {
        if (message == null && cause == null) {
            cause = new CancellationException("Cancelled without a message or cause");
            log.error("Cancelling without a message or cause is suboptimal", cause);
        }
        if (this.cancelCalled) {
            return;
        }
        this.cancelCalled = true;
        if (this.outboundMessage != null) {
            Status status = Status.Code.CANCELLED.toStatus();
            if (cause instanceof StatusRuntimeException) {
                status = ((StatusRuntimeException)cause).getStatus();
            } else {
                status = message != null ? status.withDescription(message) : status.withDescription("Call cancelled without message");
                if (cause != null) {
                    status = status.withCause(cause);
                }
            }
            this.outboundMessage.sendError(status);
        }
    }

    public void halfClose() {
        if (this.outboundMessage == null) {
            throw new IllegalStateException("Client call did not start properly.");
        }
        if (this.cancelCalled) {
            throw new IllegalStateException("Client call was cancelled.");
        }
        if (this.halfCloseCalled) {
            throw new IllegalStateException("Client call was already closed.");
        }
        this.halfCloseCalled = true;
        this.outboundMessage.halfClose();
    }

    public void sendMessage(Message message) {
        if (this.connectorListener == null) {
            throw Status.Code.INTERNAL.toStatus().withDescription("Connector listener didn't initialize properly.").asRuntimeException();
        }
        if (this.cancelCalled) {
            throw Status.Code.INTERNAL.toStatus().withDescription("Client call was already cancelled.").asRuntimeException();
        }
        if (this.halfCloseCalled) {
            throw Status.Code.INTERNAL.toStatus().withDescription("Client call was already closed.").asRuntimeException();
        }
        try {
            InputStream resp = this.method.streamRequest(message);
            this.outboundMessage.sendMessage(resp);
        }
        catch (StatusRuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw Status.Code.CANCELLED.toStatus().withCause(ex).withDescription("Failed to send the message. " + ex.getMessage()).asRuntimeException();
        }
        if (!this.unaryRequest) {
            this.outboundMessage.flush();
        }
    }

    public void setMessageCompression(boolean enabled) {
        if (this.outboundMessage == null) {
            throw Status.Code.INTERNAL.toStatus().withDescription("Client call did not initiate properly.").asRuntimeException();
        }
        this.outboundMessage.setMessageCompression(enabled);
    }

    private void closeObserver(AbstractStub.Listener observer, Status status, HttpHeaders trailers) {
        observer.onClose(status, trailers);
    }

    public boolean isReady() {
        return this.outboundMessage.isReady();
    }

    public class ClientStreamListener
    implements StreamListener {
        private final AbstractStub.Listener observer;
        private boolean closed;
        private HttpHeaders responseHeaders;

        ClientStreamListener(AbstractStub.Listener observer) {
            this.observer = observer;
        }

        public void headersRead(HttpHeaders headers) {
            try {
                if (this.closed) {
                    return;
                }
                this.responseHeaders = headers;
                this.observer.onHeaders(headers);
            }
            catch (Exception ex) {
                Status status = Status.Code.CANCELLED.toStatus().withCause(ex).withDescription("Failed to read headers. " + ex.getMessage());
                this.close(status, (HttpHeaders)new DefaultHttpHeaders());
            }
        }

        @Override
        public void messagesAvailable(InputStream message) {
            if (this.closed) {
                MessageUtils.closeQuietly(message);
                return;
            }
            try {
                Message responseMessage = ClientCall.this.method.parseResponse(message, ClientCall.this.messageSizeMap.get("maxInboundMessageSize"));
                responseMessage.setHeaders(this.responseHeaders);
                this.observer.onMessage(responseMessage);
                message.close();
            }
            catch (Exception ex) {
                MessageUtils.closeQuietly(message);
                Status status = Status.Code.CANCELLED.toStatus().withCause(ex).withDescription("Failed to read message. " + ex.getMessage());
                this.close(status, (HttpHeaders)new DefaultHttpHeaders());
            }
        }

        private void close(Status status, HttpHeaders trailers) {
            this.closed = true;
            ClientCall.this.closeObserver(this.observer, status, trailers);
        }

        public void closed(Status status, HttpHeaders trailers) {
            if (this.closed) {
                return;
            }
            this.close(status, trailers);
        }

        public void cancelCall(Throwable cause) {
            ClientCall.this.cancel(cause.getMessage(), cause);
        }
    }
}

