/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.grpc;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.grpc.GrpcConstants;
import io.ballerina.stdlib.grpc.MessageUtils;
import io.ballerina.stdlib.grpc.Status;
import io.ballerina.stdlib.grpc.exception.StatusRuntimeException;
import io.ballerina.stdlib.http.api.HttpConstants;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.transport.contract.config.ListenerConfiguration;
import io.ballerina.stdlib.http.transport.contract.config.Parameter;
import io.ballerina.stdlib.http.transport.contract.config.SenderConfiguration;
import io.ballerina.stdlib.http.transport.contract.config.SslConfiguration;
import io.ballerina.stdlib.http.transport.contractimpl.sender.channel.pool.ConnectionManager;
import io.ballerina.stdlib.http.transport.contractimpl.sender.channel.pool.PoolConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcUtil {
    private static final Logger log = LoggerFactory.getLogger(GrpcUtil.class);

    private GrpcUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionManager getConnectionManager(BMap<BString, Long> poolStruct) {
        ConnectionManager poolManager = (ConnectionManager)poolStruct.getNativeData("ConnectionManager");
        if (poolManager == null) {
            BMap<BString, Long> bMap = poolStruct;
            synchronized (bMap) {
                if (poolStruct.getNativeData("ConnectionManager") == null) {
                    PoolConfiguration userDefinedPool = new PoolConfiguration();
                    GrpcUtil.populatePoolingConfig(poolStruct, userDefinedPool);
                    poolManager = new ConnectionManager(userDefinedPool);
                    poolStruct.addNativeData("ConnectionManager", (Object)poolManager);
                }
            }
        }
        return poolManager;
    }

    public static void populatePoolingConfig(BMap poolRecord, PoolConfiguration poolConfiguration) {
        long maxActiveConnections = (Long)poolRecord.get((Object)HttpConstants.CONNECTION_POOLING_MAX_ACTIVE_CONNECTIONS);
        poolConfiguration.setMaxActivePerPool(GrpcUtil.validateConfig(maxActiveConnections, HttpConstants.CONNECTION_POOLING_MAX_ACTIVE_CONNECTIONS));
        long maxIdleConnections = (Long)poolRecord.get((Object)HttpConstants.CONNECTION_POOLING_MAX_IDLE_CONNECTIONS);
        poolConfiguration.setMaxIdlePerPool(GrpcUtil.validateConfig(maxIdleConnections, HttpConstants.CONNECTION_POOLING_MAX_IDLE_CONNECTIONS));
        double waitTime = ((BDecimal)poolRecord.get((Object)StringUtils.fromString((String)"waitTime"))).floatValue();
        poolConfiguration.setMaxWaitTime((long)(waitTime * 1000.0));
        long maxActiveStreamsPerConnection = (Long)poolRecord.get((Object)HttpConstants.CONNECTION_POOLING_MAX_ACTIVE_STREAMS_PER_CONNECTION);
        poolConfiguration.setHttp2MaxActiveStreamsPerConnection(maxActiveStreamsPerConnection == -1L ? Integer.MAX_VALUE : GrpcUtil.validateConfig(maxActiveStreamsPerConnection, HttpConstants.CONNECTION_POOLING_MAX_ACTIVE_STREAMS_PER_CONNECTION));
    }

    public static void populateSenderConfigurations(SenderConfiguration senderConfiguration, BMap<BString, Object> clientEndpointConfig, String scheme) {
        double timeoutSeconds;
        BMap secureSocket = clientEndpointConfig.getMapValue(GrpcConstants.ENDPOINT_CONFIG_SECURESOCKET);
        if (scheme.equals("https")) {
            if (secureSocket == null) {
                senderConfiguration.useJavaDefaults();
            } else {
                GrpcUtil.populateSSLConfiguration((SslConfiguration)senderConfiguration, (BMap<BString, Object>)secureSocket);
            }
        }
        if ((timeoutSeconds = ((BDecimal)clientEndpointConfig.get((Object)StringUtils.fromString((String)"timeout"))).floatValue()) < 0.0) {
            senderConfiguration.setSocketIdleTimeout(0);
        } else {
            senderConfiguration.setSocketIdleTimeout(GrpcUtil.validateConfig((long)(timeoutSeconds * 1000.0), HttpConstants.CLIENT_EP_ENDPOINT_TIMEOUT));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void populateSSLConfiguration(SslConfiguration senderConfiguration, BMap<BString, Object> secureSocket) {
        BArray ciphers;
        BMap<BString, Object> certValidation;
        BMap<BString, Object> protocol;
        BMap<BString, Object> key;
        ArrayList<Parameter> clientParamList = new ArrayList<Parameter>();
        boolean enable = secureSocket.getBooleanValue(GrpcConstants.SECURESOCKET_CONFIG_DISABLE_SSL);
        if (!enable) {
            senderConfiguration.disableSsl();
            return;
        }
        Object cert = secureSocket.get((Object)GrpcConstants.SECURESOCKET_CONFIG_CERT);
        if (cert == null) {
            key = GrpcUtil.getBMapValueIfPresent(secureSocket, GrpcConstants.SECURESOCKET_CONFIG_KEY);
            if (key == null) throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Need to configure cert with client SSL certificates file")));
            senderConfiguration.useJavaDefaults();
        } else {
            GrpcUtil.evaluateCertField(cert, senderConfiguration);
        }
        key = GrpcUtil.getBMapValueIfPresent(secureSocket, GrpcConstants.SECURESOCKET_CONFIG_KEY);
        if (key != null) {
            GrpcUtil.evaluateKeyField(key, senderConfiguration);
        }
        if ((protocol = GrpcUtil.getBMapValueIfPresent(secureSocket, GrpcConstants.SECURESOCKET_CONFIG_PROTOCOL)) != null) {
            GrpcUtil.evaluateProtocolField(protocol, senderConfiguration, clientParamList);
        }
        if ((certValidation = GrpcUtil.getBMapValueIfPresent(secureSocket, GrpcConstants.SECURESOCKET_CONFIG_CERT_VALIDATION)) != null) {
            GrpcUtil.evaluateCertValidationField(certValidation, senderConfiguration);
        }
        BArray bArray = ciphers = secureSocket.containsKey((Object)GrpcConstants.SECURESOCKET_CONFIG_CIPHERS) ? secureSocket.getArrayValue(GrpcConstants.SECURESOCKET_CONFIG_CIPHERS) : null;
        if (ciphers != null) {
            GrpcUtil.evaluateCiphersField(ciphers, clientParamList);
        }
        GrpcUtil.evaluateCommonFields(secureSocket, senderConfiguration, clientParamList);
        if (clientParamList.isEmpty()) return;
        senderConfiguration.setParameters(clientParamList);
    }

    public static ListenerConfiguration getListenerConfig(long port, BMap endpointConfig) {
        BString host = endpointConfig.getStringValue(HttpConstants.ENDPOINT_CONFIG_HOST);
        BMap sslConfig = endpointConfig.getMapValue(GrpcConstants.ENDPOINT_CONFIG_SECURESOCKET);
        double idleTimeout = ((BDecimal)endpointConfig.get((Object)StringUtils.fromString((String)"timeout"))).floatValue();
        ListenerConfiguration listenerConfiguration = new ListenerConfiguration();
        if (host == null || host.getValue().trim().isEmpty()) {
            listenerConfiguration.setHost("0.0.0.0");
        } else {
            listenerConfiguration.setHost(host.getValue());
        }
        if (port == 0L) {
            throw new RuntimeException("Listener port is not defined!");
        }
        listenerConfiguration.setPort(Math.toIntExact(port));
        if (idleTimeout < 0.0) {
            throw new RuntimeException("Idle timeout cannot be negative. If you want to disable the timeout please use value 0");
        }
        listenerConfiguration.setSocketIdleTimeout(Math.toIntExact((long)(idleTimeout * 1000.0)));
        listenerConfiguration.setVersion("2.0");
        if (endpointConfig.getType().getName().equalsIgnoreCase("ListenerConfiguration")) {
            BString serverName = endpointConfig.getStringValue(HttpConstants.SERVER_NAME);
            listenerConfiguration.setServerHeader(serverName != null ? serverName.getValue() : GrpcUtil.getServerName());
        } else {
            listenerConfiguration.setServerHeader(GrpcUtil.getServerName());
        }
        if (sslConfig != null) {
            return GrpcUtil.setSslConfig((BMap<BString, Object>)sslConfig, listenerConfiguration);
        }
        listenerConfiguration.getMsgSizeValidationConfig().setMaxHeaderSize(endpointConfig.getIntValue(HttpConstants.MAX_HEADER_SIZE).intValue());
        listenerConfiguration.setPipeliningEnabled(true);
        listenerConfiguration.setSocketReuse(true);
        listenerConfiguration.setTcpNoDelay(true);
        return listenerConfiguration;
    }

    private static String getServerName() {
        String version = System.getProperty("ballerina.version");
        Object userAgent = version != null ? "ballerina/" + version : "ballerina";
        return userAgent;
    }

    private static ListenerConfiguration setSslConfig(BMap<BString, Object> secureSocket, ListenerConfiguration listenerConfiguration) {
        BArray ciphers;
        BMap<BString, Object> certValidation;
        BMap<BString, Object> protocol;
        ArrayList<Parameter> serverParamList = new ArrayList<Parameter>();
        listenerConfiguration.setScheme("https");
        BMap<BString, Object> key = GrpcUtil.getBMapValueIfPresent(secureSocket, GrpcConstants.SECURESOCKET_CONFIG_KEY);
        assert (key != null);
        GrpcUtil.evaluateKeyField(key, (SslConfiguration)listenerConfiguration);
        BMap<BString, Object> mutualSsl = GrpcUtil.getBMapValueIfPresent(secureSocket, GrpcConstants.SECURESOCKET_CONFIG_MUTUAL_SSL);
        if (mutualSsl != null) {
            String verifyClient = mutualSsl.getStringValue(GrpcConstants.SECURESOCKET_CONFIG_VERIFY_CLIENT).getValue();
            listenerConfiguration.setVerifyClient(verifyClient);
            Object cert = mutualSsl.get((Object)GrpcConstants.SECURESOCKET_CONFIG_CERT);
            GrpcUtil.evaluateCertField(cert, (SslConfiguration)listenerConfiguration);
        }
        if ((protocol = GrpcUtil.getBMapValueIfPresent(secureSocket, GrpcConstants.SECURESOCKET_CONFIG_PROTOCOL)) != null) {
            GrpcUtil.evaluateProtocolField(protocol, (SslConfiguration)listenerConfiguration, serverParamList);
        }
        if ((certValidation = GrpcUtil.getBMapValueIfPresent(secureSocket, GrpcConstants.SECURESOCKET_CONFIG_CERT_VALIDATION)) != null) {
            GrpcUtil.evaluateCertValidationField(certValidation, (SslConfiguration)listenerConfiguration);
        }
        BArray bArray = ciphers = secureSocket.containsKey((Object)GrpcConstants.SECURESOCKET_CONFIG_CIPHERS) ? secureSocket.getArrayValue(GrpcConstants.SECURESOCKET_CONFIG_CIPHERS) : null;
        if (ciphers != null) {
            GrpcUtil.evaluateCiphersField(ciphers, serverParamList);
        }
        GrpcUtil.evaluateCommonFields(secureSocket, (SslConfiguration)listenerConfiguration, serverParamList);
        listenerConfiguration.setTLSStoreType("PKCS12");
        if (!serverParamList.isEmpty()) {
            listenerConfiguration.setParameters(serverParamList);
        }
        listenerConfiguration.setId(HttpUtil.getListenerInterface((String)listenerConfiguration.getHost(), (int)listenerConfiguration.getPort()));
        return listenerConfiguration;
    }

    private static void evaluateKeyField(BMap<BString, Object> key, SslConfiguration sslConfiguration) {
        if (key.containsKey((Object)GrpcConstants.SECURESOCKET_CONFIG_KEYSTORE_FILE_PATH)) {
            String keyStoreFile = key.getStringValue(GrpcConstants.SECURESOCKET_CONFIG_KEYSTORE_FILE_PATH).getValue();
            if (keyStoreFile.isBlank()) {
                throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("KeyStore file location must be provided for secure connection.")));
            }
            String keyStorePassword = key.getStringValue(GrpcConstants.SECURESOCKET_CONFIG_KEYSTORE_PASSWORD).getValue();
            if (keyStorePassword.isBlank()) {
                throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("KeyStore password must be provided for secure connection.")));
            }
            sslConfiguration.setKeyStoreFile(keyStoreFile);
            sslConfiguration.setKeyStorePass(keyStorePassword);
        } else {
            BString keyPassword;
            String certFile = key.getStringValue(GrpcConstants.SECURESOCKET_CONFIG_CERTKEY_CERT_FILE).getValue();
            String keyFile = key.getStringValue(GrpcConstants.SECURESOCKET_CONFIG_CERTKEY_KEY_FILE).getValue();
            BString bString = keyPassword = key.containsKey((Object)GrpcConstants.SECURESOCKET_CONFIG_CERTKEY_KEY_PASSWORD) ? key.getStringValue(GrpcConstants.SECURESOCKET_CONFIG_CERTKEY_KEY_PASSWORD) : null;
            if (certFile.isBlank()) {
                throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Certificate file location must be provided for secure connection.")));
            }
            if (keyFile.isBlank()) {
                throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Private key file location must be provided for secure connection.")));
            }
            if (sslConfiguration instanceof ListenerConfiguration) {
                sslConfiguration.setServerCertificates(certFile);
                sslConfiguration.setServerKeyFile(keyFile);
                if (keyPassword != null && !keyPassword.getValue().isBlank()) {
                    sslConfiguration.setServerKeyPassword(keyPassword.getValue());
                }
            } else {
                sslConfiguration.setClientCertificates(certFile);
                sslConfiguration.setClientKeyFile(keyFile);
                if (keyPassword != null && !keyPassword.getValue().isBlank()) {
                    sslConfiguration.setClientKeyPassword(keyPassword.getValue());
                }
            }
        }
    }

    private static void evaluateCertField(Object cert, SslConfiguration sslConfiguration) {
        if (cert instanceof BMap) {
            BMap trustStore = (BMap)cert;
            String trustStoreFile = trustStore.getStringValue(GrpcConstants.SECURESOCKET_CONFIG_TRUSTSTORE_FILE_PATH).getValue();
            String trustStorePassword = trustStore.getStringValue(GrpcConstants.SECURESOCKET_CONFIG_TRUSTSTORE_PASSWORD).getValue();
            if (trustStoreFile.isBlank()) {
                throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("TrustStore file location must be provided for secure connection.")));
            }
            if (trustStorePassword.isBlank()) {
                throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("TrustStore password must be provided for secure connection.")));
            }
            sslConfiguration.setTrustStoreFile(trustStoreFile);
            sslConfiguration.setTrustStorePass(trustStorePassword);
        } else {
            String certFile = ((BString)cert).getValue();
            if (certFile.isBlank()) {
                throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Certificate file location must be provided for secure connection.")));
            }
            if (sslConfiguration instanceof ListenerConfiguration) {
                sslConfiguration.setServerTrustCertificates(certFile);
            } else {
                sslConfiguration.setClientTrustCertificates(certFile);
            }
        }
    }

    private static void evaluateProtocolField(BMap<BString, Object> protocol, SslConfiguration sslConfiguration, List<Parameter> paramList) {
        String sslProtocol;
        List<String> sslEnabledProtocolsValueList = Arrays.asList(protocol.getArrayValue(GrpcConstants.SECURESOCKET_CONFIG_PROTOCOL_VERSIONS).getStringArray());
        if (!sslEnabledProtocolsValueList.isEmpty()) {
            String sslEnabledProtocols = sslEnabledProtocolsValueList.stream().collect(Collectors.joining(",", "", ""));
            Parameter serverProtocols = new Parameter("sslEnabledProtocols", sslEnabledProtocols);
            paramList.add(serverProtocols);
        }
        if (!(sslProtocol = protocol.getStringValue(GrpcConstants.SECURESOCKET_CONFIG_PROTOCOL_NAME).getValue()).isBlank()) {
            sslConfiguration.setSSLProtocol(sslProtocol);
        }
    }

    private static void evaluateCertValidationField(BMap<BString, Object> certValidation, SslConfiguration sslConfiguration) {
        String type = certValidation.getStringValue(GrpcConstants.SECURESOCKET_CONFIG_CERT_VALIDATION_TYPE).getValue();
        if (type.equals(GrpcConstants.SECURESOCKET_CONFIG_CERT_VALIDATION_TYPE_OCSP_STAPLING.getValue())) {
            sslConfiguration.setOcspStaplingEnabled(true);
        } else {
            sslConfiguration.setValidateCertEnabled(true);
        }
        long cacheSize = certValidation.getIntValue(GrpcConstants.SECURESOCKET_CONFIG_CERT_VALIDATION_CACHE_SIZE).intValue();
        long cacheValidityPeriod = certValidation.getIntValue(GrpcConstants.SECURESOCKET_CONFIG_CERT_VALIDATION_CACHE_VALIDITY_PERIOD).intValue();
        if (cacheValidityPeriod != 0L) {
            sslConfiguration.setCacheValidityPeriod(Math.toIntExact(cacheValidityPeriod));
        }
        if (cacheSize != 0L) {
            sslConfiguration.setCacheSize(Math.toIntExact(cacheSize));
        }
    }

    private static void evaluateCiphersField(BArray ciphers, List<Parameter> paramList) {
        String[] ciphersArray = ciphers.getStringArray();
        List<String> ciphersList = Arrays.asList(ciphersArray);
        if (ciphersList.size() > 0) {
            String ciphersString = ciphersList.stream().map(Object::toString).collect(Collectors.joining(",", "", ""));
            Parameter serverParameters = new Parameter("ciphers", ciphersString);
            paramList.add(serverParameters);
        }
    }

    private static void evaluateCommonFields(BMap<BString, Object> secureSocket, SslConfiguration sslConfiguration, List<Parameter> paramList) {
        if (!(sslConfiguration instanceof ListenerConfiguration)) {
            boolean hostNameVerificationEnabled = secureSocket.getBooleanValue(GrpcConstants.SECURESOCKET_CONFIG_HOST_NAME_VERIFICATION_ENABLED);
            sslConfiguration.setHostNameVerificationEnabled(hostNameVerificationEnabled);
        }
        sslConfiguration.setSslSessionTimeOut((int)GrpcUtil.getLongValueOrDefault(secureSocket, GrpcConstants.SECURESOCKET_CONFIG_SESSION_TIMEOUT));
        sslConfiguration.setSslHandshakeTimeOut(GrpcUtil.getLongValueOrDefault(secureSocket, GrpcConstants.SECURESOCKET_CONFIG_HANDSHAKE_TIMEOUT));
        String enableSessionCreation = String.valueOf(secureSocket.getBooleanValue(GrpcConstants.SECURESOCKET_CONFIG_SHARE_SESSION));
        Parameter enableSessionCreationParam = new Parameter(GrpcConstants.SECURESOCKET_CONFIG_SHARE_SESSION.getValue(), enableSessionCreation);
        paramList.add(enableSessionCreationParam);
    }

    private static BMap<BString, Object> getBMapValueIfPresent(BMap<BString, Object> map, BString key) {
        return map.containsKey((Object)key) ? map.getMapValue(key) : null;
    }

    private static long getLongValueOrDefault(BMap<BString, Object> map, BString key) {
        return map.containsKey((Object)key) ? ((BDecimal)map.get((Object)key)).intValue() : 0L;
    }

    private static int validateConfig(long value, BString configName) {
        try {
            return Math.toIntExact(value);
        }
        catch (ArithmeticException e) {
            log.warn("The value set for the configuration needs to be less than {}. The " + configName.getValue() + "value is set to {}", (Object)Integer.MAX_VALUE);
            return Integer.MAX_VALUE;
        }
    }

    public static String getTypeName(Type type) {
        if (type.getTag() == 44) {
            return "Timestamp";
        }
        if (type.getTag() == 4) {
            return "Duration";
        }
        if (type.getTag() == 27) {
            return "Struct";
        }
        return type.getName();
    }

    public static Object getResult(CompletableFuture<Object> balFuture) {
        try {
            return balFuture.get();
        }
        catch (BError error) {
            throw error;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw ErrorCreator.createError((Throwable)e);
        }
        catch (Throwable throwable) {
            throw ErrorCreator.createError((Throwable)throwable);
        }
    }
}

