/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.grpc;

import io.ballerina.stdlib.grpc.Codec;
import io.ballerina.stdlib.grpc.Decompressor;
import io.ballerina.stdlib.grpc.DecompressorRegistry;
import io.ballerina.stdlib.grpc.MessageDeframer;
import io.ballerina.stdlib.grpc.StreamListener;
import io.ballerina.stdlib.http.transport.contract.HttpResponseFuture;
import io.ballerina.stdlib.http.transport.contract.exceptions.ServerConnectorException;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.InputStream;
import java.util.Map;

public class InboundMessage {
    private final HttpCarbonMessage httpCarbonMessage;

    InboundMessage(HttpCarbonMessage httpCarbonMessage) {
        this.httpCarbonMessage = httpCarbonMessage;
    }

    public boolean isEmpty() {
        return this.httpCarbonMessage.isEmpty();
    }

    public HttpHeaders getHeaders() {
        return this.httpCarbonMessage.getHeaders();
    }

    public String getHeader(String key) {
        return this.httpCarbonMessage.getHeader(key);
    }

    public Object getProperty(String key) {
        return this.httpCarbonMessage.getProperty(key);
    }

    public Map<String, Object> getProperties() {
        return this.httpCarbonMessage.getProperties();
    }

    public void setProperty(String key, Object value) {
        this.httpCarbonMessage.setProperty(key, value);
    }

    public String getPath() {
        return (String)this.httpCarbonMessage.getProperty("TO");
    }

    public int getStatus() {
        return this.httpCarbonMessage.getHttpStatusCode();
    }

    public String getHttpMethod() {
        return this.httpCarbonMessage.getHttpMethod();
    }

    HttpCarbonMessage getHttpCarbonMessage() {
        return this.httpCarbonMessage;
    }

    public boolean respond(HttpCarbonMessage carbonMessage) throws ServerConnectorException {
        HttpResponseFuture statusFuture = this.httpCarbonMessage.respond(carbonMessage);
        return statusFuture.getStatus().getCause() == null;
    }

    public Decompressor getMessageDecompressor() {
        String contentEncodingHeader = this.httpCarbonMessage.getHeader("grpc-encoding");
        if (contentEncodingHeader != null) {
            this.httpCarbonMessage.removeHeader(HttpHeaderNames.CONTENT_ENCODING.toString());
            return DecompressorRegistry.getDefaultInstance().lookupDecompressor(contentEncodingHeader);
        }
        return null;
    }

    public static abstract class InboundStateListener
    implements MessageDeframer.Listener {
        private MessageDeframer deframer;

        InboundStateListener(long maxMessageSize) {
            this.deframer = new MessageDeframer(this, Codec.Identity.NONE, maxMessageSize);
        }

        protected abstract StreamListener listener();

        @Override
        public void messagesAvailable(InputStream inputStream) {
            this.listener().messagesAvailable(inputStream);
        }

        final void closeDeframer(boolean stopDelivery) {
            if (stopDelivery) {
                this.deframer.close();
            } else {
                this.deframer.closeWhenComplete();
            }
        }

        final void deframe(HttpContent httpContent) {
            try {
                this.deframer.deframe(httpContent);
            }
            catch (Exception ex) {
                this.deframeFailed(ex);
            }
        }

        protected final void setDecompressor(Decompressor decompressor) {
            this.deframer.setDecompressor(decompressor);
        }
    }
}

