/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.grpc;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.Descriptors;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.stdlib.grpc.Message;
import io.ballerina.stdlib.grpc.MessageRegistry;
import io.ballerina.stdlib.grpc.MessageUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class MessageParser {
    private final String messageName;
    private final Type bType;
    private final Map<Integer, Descriptors.FieldDescriptor> fieldDescriptors;

    public MessageParser(String messageName, Type bType) {
        this.messageName = messageName;
        this.bType = bType;
        Descriptors.Descriptor messageDescriptor = MessageRegistry.getInstance().getMessageDescriptor(messageName);
        this.fieldDescriptors = MessageParser.computeFieldTagValues(messageDescriptor);
    }

    public MessageParser(String messageName, Type bType, Descriptors.Descriptor messageDescriptor) {
        this.messageName = messageName;
        this.bType = bType;
        this.fieldDescriptors = MessageParser.computeFieldTagValues(messageDescriptor);
    }

    MessageParser(Descriptors.Descriptor descriptor, Type bType) {
        this.messageName = descriptor.getFullName();
        this.bType = bType;
        this.fieldDescriptors = MessageParser.computeFieldTagValues(descriptor);
    }

    public Map<Integer, Descriptors.FieldDescriptor> getFieldDescriptors() {
        return this.fieldDescriptors;
    }

    Message parseFrom(CodedInputStream input) throws IOException {
        return new Message(this.messageName, this.bType, input, this.fieldDescriptors);
    }

    Message getDefaultInstance() throws IOException {
        return new Message(this.messageName, this.bType, null, this.fieldDescriptors);
    }

    public static Map<Integer, Descriptors.FieldDescriptor> computeFieldTagValues(Descriptors.Descriptor messageDescriptor) {
        HashMap<Integer, Descriptors.FieldDescriptor> fieldDescriptors = new HashMap<Integer, Descriptors.FieldDescriptor>();
        for (Descriptors.FieldDescriptor fieldDescriptor : messageDescriptor.getFields()) {
            Descriptors.FieldDescriptor.Type fieldType = fieldDescriptor.getType();
            int number = fieldDescriptor.getNumber();
            int byteCode = (number << 3) + MessageUtils.getFieldWireType(fieldType);
            fieldDescriptors.put(byteCode, fieldDescriptor);
            if (!fieldDescriptor.isRepeated()) continue;
            byteCode = (number << 3) + 2;
            fieldDescriptors.put(byteCode, fieldDescriptor);
        }
        return fieldDescriptors;
    }
}

