/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.grpc;

import io.ballerina.stdlib.grpc.InboundMessage;
import io.ballerina.stdlib.grpc.MessageFramer;
import io.ballerina.stdlib.grpc.Status;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.Http2ResetContent;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.EmptyByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class OutboundMessage {
    private static final int NULL_STATUS_CODE = -1;
    private final HttpCarbonMessage responseMessage;
    private int statusCode = -1;
    private boolean outboundClosed;
    private final MessageFramer framer;

    public OutboundMessage(HttpCarbonMessage responseMessage) {
        this.responseMessage = responseMessage;
        this.framer = new MessageFramer(responseMessage);
    }

    OutboundMessage(InboundMessage inboundMessage) {
        HttpCarbonMessage responseMessage = inboundMessage.getHttpCarbonMessage().cloneCarbonMessageWithOutData();
        HttpHeaders headers = responseMessage.getHeaders();
        headers.forEach(entry -> {
            if (((String)entry.getKey()).equals("scheme")) {
                return;
            }
            responseMessage.removeHeader((String)entry.getKey());
        });
        responseMessage.setHeader("content-type", "application/grpc");
        responseMessage.setHeader("te", "trailers");
        this.responseMessage = responseMessage;
        this.framer = new MessageFramer(responseMessage);
    }

    public boolean isEmpty() {
        return this.responseMessage.isEmpty();
    }

    public HttpHeaders getHeaders() {
        return this.responseMessage.getHeaders();
    }

    public String getHeader(String key) {
        return this.responseMessage.getHeader(key);
    }

    public OutboundMessage setHeader(String key, String value) {
        this.responseMessage.setHeader(key, value);
        return this;
    }

    public void setHeaders(Map<String, String> headerMap) {
        headerMap.forEach((arg_0, arg_1) -> ((HttpCarbonMessage)this.responseMessage).setHeader(arg_0, arg_1));
    }

    public void setHeaders(HttpHeaders headers) {
        this.responseMessage.setHeaders(headers);
    }

    public void addHeaders(HttpHeaders httpHeaders) {
        this.responseMessage.addHeaders(httpHeaders);
    }

    public void setProperty(String key, Object value) {
        this.responseMessage.setProperty(key, value);
    }

    public void removeHeader(String key) {
        this.responseMessage.removeHeader(key);
    }

    HttpCarbonMessage getResponseMessage() {
        return this.responseMessage;
    }

    public OutboundMessage setStatus(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public void sendMessage(InputStream entity) {
        if (entity != null) {
            this.framer().writePayload(entity);
            this.framer().flush();
        } else {
            ByteBuffer byteBuffer = ByteBuffer.allocate(0);
            this.responseMessage.addHttpContent((HttpContent)new DefaultLastHttpContent(Unpooled.wrappedBuffer((ByteBuffer)byteBuffer)));
        }
    }

    public void complete(Status status, HttpHeaders trailers) {
        this.framer().flush();
        this.framer().dispose();
        this.addStatusToTrailers(status, trailers);
        DefaultLastHttpContent lastHttpContent = new DefaultLastHttpContent();
        lastHttpContent.trailingHeaders().set(trailers);
        this.responseMessage.addHttpContent((HttpContent)lastHttpContent);
    }

    public void sendError(Status status) {
        this.framer().flush();
        this.framer().dispose();
        DefaultHttpHeaders errorHeaders = new DefaultHttpHeaders();
        this.addStatusToTrailers(status, (HttpHeaders)errorHeaders);
        Http2ResetContent resetContent = new Http2ResetContent((ByteBuf)new EmptyByteBuf(ByteBufAllocator.DEFAULT), (HttpHeaders)errorHeaders);
        this.responseMessage.addHttpContent((HttpContent)resetContent);
    }

    private void addStatusToTrailers(Status status, HttpHeaders trailers) {
        trailers.remove("grpc-status");
        trailers.remove("grpc-message");
        byte[] bytes = Status.CODE_MARSHALLER.toAsciiString(status);
        trailers.add("grpc-status", (Object)new String(bytes, StandardCharsets.US_ASCII));
        if (status.getDescription() != null) {
            trailers.add("grpc-message", (Object)new String(Status.MESSAGE_MARSHALLER.toAsciiString(status.getDescription()), StandardCharsets.US_ASCII));
        }
    }

    final void halfClose() {
        if (!this.outboundClosed) {
            this.outboundClosed = true;
            this.framer().close();
        }
    }

    final MessageFramer framer() {
        return this.framer;
    }

    public boolean isReady() {
        return !this.framer().isClosed();
    }

    public final void setMessageCompression(boolean enable) {
        this.framer().setMessageCompression(enable);
    }

    public final void flush() {
        if (!this.framer().isClosed()) {
            this.framer().flush();
        }
    }

    public void setHttpVersion(String httpVersion) {
        this.responseMessage.setHttpVersion(httpVersion);
    }

    void setHttpMethod() {
        this.responseMessage.setHttpMethod("POST");
    }
}

