/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.grpc;

import io.ballerina.runtime.observability.ObserveUtils;
import io.ballerina.runtime.observability.ObserverContext;
import io.ballerina.stdlib.grpc.CompressorRegistry;
import io.ballerina.stdlib.grpc.DecompressorRegistry;
import io.ballerina.stdlib.grpc.GrpcThreadFactory;
import io.ballerina.stdlib.grpc.InboundMessage;
import io.ballerina.stdlib.grpc.MessageUtils;
import io.ballerina.stdlib.grpc.OutboundMessage;
import io.ballerina.stdlib.grpc.ServerCall;
import io.ballerina.stdlib.grpc.ServerMethodDefinition;
import io.ballerina.stdlib.grpc.ServicesRegistry;
import io.ballerina.stdlib.grpc.Status;
import io.ballerina.stdlib.grpc.exception.StatusRuntimeException;
import io.ballerina.stdlib.http.api.HttpConstants;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.transport.contract.HttpConnectorListener;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.LastHttpContent;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConnectorListener
implements HttpConnectorListener {
    private static final Logger log = LoggerFactory.getLogger(ServerConnectorListener.class);
    private static final String SERVER_CONNECTOR_GRPC = "grpc";
    private static final String GRPC_PROTOCOL = "grpc";
    private final ServicesRegistry servicesRegistry;
    private Map<String, Long> messageSizeMap;
    private ExecutorService workerExecutor = Executors.newFixedThreadPool(10, new GrpcThreadFactory(new ThreadGroup("grpc-worker"), "grpc-service-worker-thread-pool"));

    public ServerConnectorListener(ServicesRegistry servicesRegistry, Map<String, Long> messageSizeMap) {
        this.servicesRegistry = servicesRegistry;
        this.messageSizeMap = messageSizeMap;
    }

    public void onMessage(HttpCarbonMessage inboundMessage) {
        try {
            InboundMessage request = new InboundMessage(inboundMessage);
            if (!this.isValid(request)) {
                return;
            }
            OutboundMessage outboundMessage = new OutboundMessage(request);
            String path = request.getPath();
            String method = path != null ? path.subSequence(1, path.length()).toString() : null;
            this.deliver(method, request, outboundMessage);
        }
        catch (RuntimeException ex) {
            try {
                HttpUtil.handleFailure((HttpCarbonMessage)inboundMessage, (String)ex.getMessage());
            }
            catch (Exception e) {
                log.error("Cannot handle error using the error handler for: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void onError(Throwable throwable) {
        log.error("Error in http server connector" + throwable.getMessage(), throwable);
    }

    private void deliver(String method, InboundMessage inboundMessage, OutboundMessage outboundMessage) {
        ServerMethodDefinition methodDefinition = this.servicesRegistry.lookupMethod(method);
        if (methodDefinition == null) {
            ServerConnectorListener.handleFailure(inboundMessage.getHttpCarbonMessage(), 404, Status.Code.UNIMPLEMENTED, String.format("Method not found: %s", method));
            return;
        }
        this.workerExecutor.execute(() -> {
            try {
                ServerCall.ServerStreamListener listener = this.startCall(inboundMessage, outboundMessage, method);
                ServerInboundStateListener stateListener = new ServerInboundStateListener(this.messageSizeMap.get("maxInboundMessageSize"), listener, inboundMessage);
                stateListener.setDecompressor(inboundMessage.getMessageDecompressor());
                HttpContent httpContent = inboundMessage.getHttpCarbonMessage().getHttpContent();
                while (httpContent != null) {
                    if (httpContent instanceof LastHttpContent) {
                        stateListener.inboundDataReceived(httpContent, true);
                        break;
                    }
                    stateListener.inboundDataReceived(httpContent, false);
                    httpContent = inboundMessage.getHttpCarbonMessage().getHttpContent();
                }
            }
            catch (RuntimeException e) {
                HttpUtil.handleFailure((HttpCarbonMessage)inboundMessage.getHttpCarbonMessage(), (String)e.getMessage());
            }
        });
    }

    private ServerCall.ServerStreamListener startCall(InboundMessage inboundMessage, OutboundMessage outboundMessage, String fullMethodName) {
        ServerMethodDefinition methodDefinition = this.servicesRegistry.lookupMethod(fullMethodName);
        ServerCall call = new ServerCall(inboundMessage, outboundMessage, methodDefinition.getMethodDescriptor(), DecompressorRegistry.getDefaultInstance(), CompressorRegistry.getDefaultInstance(), this.messageSizeMap);
        if (ObserveUtils.isObservabilityEnabled()) {
            call.setObserverContext(this.getObserverContext(fullMethodName, inboundMessage));
        }
        return call.newServerStreamListener(methodDefinition.getServerCallHandler().startCall(call));
    }

    private ObserverContext getObserverContext(String method, InboundMessage inboundMessage) {
        ObserverContext observerContext = new ObserverContext();
        observerContext.setServiceName("grpc");
        observerContext.setOperationName(method);
        HashMap httpHeaders = new HashMap();
        inboundMessage.getHeaders().forEach(entry -> httpHeaders.put((String)entry.getKey(), (String)entry.getValue()));
        observerContext.addProperty("_trace_properties_", httpHeaders);
        observerContext.addTag("http.method", (String)inboundMessage.getProperty(HttpConstants.HTTP_REQUEST_METHOD.getValue()));
        observerContext.addTag("protocol", "grpc");
        observerContext.addTag("http.url", inboundMessage.getPath());
        return observerContext;
    }

    private boolean isValid(InboundMessage inboundMessage) {
        HttpHeaders headers = inboundMessage.getHeaders();
        String path = inboundMessage.getPath();
        if (path == null) {
            ServerConnectorListener.handleFailure(inboundMessage.getHttpCarbonMessage(), 404, Status.Code.UNIMPLEMENTED, "Expected path is missing");
            return false;
        }
        if (path.charAt(0) != '/') {
            ServerConnectorListener.handleFailure(inboundMessage.getHttpCarbonMessage(), 404, Status.Code.UNIMPLEMENTED, String.format("Expected path to start with /: %s", path));
            return false;
        }
        String contentType = headers.get("content-type");
        if (contentType == null) {
            ServerConnectorListener.handleFailure(inboundMessage.getHttpCarbonMessage(), 415, Status.Code.INTERNAL, "Content-Type is missing from the request");
            return false;
        }
        String contentTypeString = contentType.toString();
        if (!MessageUtils.isGrpcContentType(contentTypeString)) {
            ServerConnectorListener.handleFailure(inboundMessage.getHttpCarbonMessage(), 415, Status.Code.INTERNAL, String.format("Content-Type '%s' is not supported", contentTypeString));
            return false;
        }
        String method = inboundMessage.getHttpMethod();
        if (!"POST".equals(method)) {
            ServerConnectorListener.handleFailure(inboundMessage.getHttpCarbonMessage(), 405, Status.Code.INTERNAL, String.format("Method '%s' is not supported", method));
            return false;
        }
        return true;
    }

    private static void handleFailure(HttpCarbonMessage requestMessage, int status, Status.Code statusCode, String msg) {
        HttpCarbonMessage responseMessage = HttpUtil.createErrorMessage((String)msg, (int)status);
        responseMessage.setHeader("grpc-status", statusCode.toString());
        responseMessage.setHeader("grpc-message", msg);
        HttpUtil.sendOutboundResponse((HttpCarbonMessage)requestMessage, (HttpCarbonMessage)responseMessage);
    }

    private static class ServerInboundStateListener
    extends InboundMessage.InboundStateListener {
        final ServerCall.ServerStreamListener listener;
        final InboundMessage inboundMessage;

        ServerInboundStateListener(long maxMessageSize, ServerCall.ServerStreamListener listener, InboundMessage inboundMessage) {
            super(maxMessageSize);
            this.listener = listener;
            this.inboundMessage = inboundMessage;
        }

        @Override
        protected ServerCall.ServerStreamListener listener() {
            return this.listener;
        }

        @Override
        public void deframerClosed(boolean hasPartialMessage) {
            if (hasPartialMessage) {
                this.deframeFailed(Status.Code.INTERNAL.toStatus().withDescription("Encountered end-of-stream mid-frame").asRuntimeException());
                return;
            }
            this.listener.halfClosed();
        }

        @Override
        public void deframeFailed(Throwable cause) {
            if (cause instanceof StatusRuntimeException) {
                StatusRuntimeException exp = (StatusRuntimeException)cause;
                ServerConnectorListener.handleFailure(this.inboundMessage.getHttpCarbonMessage(), MessageUtils.statusCodeToHttpCode(exp.getStatus().getCode()), exp.getStatus().getCode(), exp.getStatus().getDescription());
                this.listener.closed(exp.getStatus());
            } else {
                ServerConnectorListener.handleFailure(this.inboundMessage.getHttpCarbonMessage(), 500, Status.Code.INTERNAL, cause.getMessage());
            }
        }

        void inboundDataReceived(HttpContent httpContent, boolean endOfStream) {
            this.deframe(httpContent);
            if (endOfStream) {
                Throwable error = httpContent.getDecoderResult().cause();
                if (error != null) {
                    Status status = Status.fromCode(Status.Code.CANCELLED).withDescription(error.getMessage());
                    this.listener.closed(status);
                } else {
                    LastHttpContent lastHttpContent = (LastHttpContent)httpContent;
                    HttpHeaders trailingHeaders = lastHttpContent.trailingHeaders();
                    if (!trailingHeaders.isEmpty()) {
                        Status status = MessageUtils.statusFromTrailers(trailingHeaders);
                        this.listener.closed(status);
                    }
                }
                this.closeDeframer(false);
            }
        }
    }
}

