/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.grpc;

import io.ballerina.stdlib.grpc.MethodDescriptor;
import io.ballerina.stdlib.grpc.ServerMethodDefinition;
import io.ballerina.stdlib.grpc.ServiceDescriptor;
import io.ballerina.stdlib.grpc.exception.GrpcServerException;
import io.ballerina.stdlib.grpc.listener.ServerCallHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class ServerServiceDefinition {
    private final ServiceDescriptor serviceDescriptor;
    private final Map<String, ServerMethodDefinition> methods;

    public static Builder builder(String serviceName) throws GrpcServerException {
        return new Builder(serviceName);
    }

    private ServerServiceDefinition(ServiceDescriptor serviceDescriptor, Map<String, ServerMethodDefinition> methods) {
        this.serviceDescriptor = serviceDescriptor;
        this.methods = Map.copyOf(methods);
    }

    public ServiceDescriptor getServiceDescriptor() {
        return this.serviceDescriptor;
    }

    public Collection<ServerMethodDefinition> getMethods() {
        return this.methods.values();
    }

    public static final class Builder {
        private final String serviceName;
        private final Map<String, ServerMethodDefinition> methods = new HashMap<String, ServerMethodDefinition>();

        private Builder(String serviceName) throws GrpcServerException {
            if (serviceName == null) {
                throw new GrpcServerException("Service Name cannot be null");
            }
            this.serviceName = serviceName;
        }

        public void addMethod(MethodDescriptor method, ServerCallHandler handler) throws GrpcServerException {
            if (method == null) {
                throw new GrpcServerException("Method Descriptor cannot be null");
            }
            if (handler == null) {
                throw new GrpcServerException("Server call handler cannot be null");
            }
            this.addMethod(ServerMethodDefinition.create(method, handler));
        }

        void addMethod(ServerMethodDefinition def) throws GrpcServerException {
            MethodDescriptor method = def.getMethodDescriptor();
            if (!this.serviceName.equals(MethodDescriptor.extractFullServiceName(method.getFullMethodName()))) {
                throw new GrpcServerException(String.format("Method name should be prefixed with service name and separated with '/'. Expected service name: '%s'. Actual fully qualifed method name: '%s'.", this.serviceName, method.getFullMethodName()));
            }
            String name = method.getFullMethodName();
            if (this.methods.containsKey(name)) {
                throw new GrpcServerException(String.format("Method by same name already registered: %s", name));
            }
            this.methods.put(name, def);
        }

        public ServerServiceDefinition build() throws GrpcServerException {
            ArrayList<MethodDescriptor> methodDescriptors = new ArrayList<MethodDescriptor>(this.methods.size());
            for (ServerMethodDefinition serverMethod : this.methods.values()) {
                methodDescriptors.add(serverMethod.getMethodDescriptor());
            }
            ServiceDescriptor descriptor = ServiceDescriptor.newBuilder(this.serviceName).addAllMethods(methodDescriptors).build();
            HashMap<String, ServerMethodDefinition> tmpMethods = new HashMap<String, ServerMethodDefinition>(this.methods);
            for (MethodDescriptor descriptorMethod : descriptor.getMethods()) {
                ServerMethodDefinition removed = (ServerMethodDefinition)tmpMethods.remove(descriptorMethod.getFullMethodName());
                if (removed == null) {
                    throw new IllegalStateException("No method bound for descriptor entry " + descriptorMethod.getFullMethodName());
                }
                if (removed.getMethodDescriptor() == descriptorMethod) continue;
                throw new IllegalStateException("Bound method for " + descriptorMethod.getFullMethodName() + " not same instance as method in service descriptor");
            }
            if (tmpMethods.size() > 0) {
                throw new IllegalStateException("No entry in descriptor matching bound method " + ((ServerMethodDefinition)tmpMethods.values().iterator().next()).getMethodDescriptor().getFullMethodName());
            }
            return new ServerServiceDefinition(descriptor, this.methods);
        }
    }
}

