/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.xmldata.utils;

import io.ballerina.lib.data.xmldata.utils.DataUtils;
import io.ballerina.lib.data.xmldata.utils.QualifiedName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class QualifiedNameMap<V> {
    private final Map<QualifiedName, V> members;
    private final Map<String, List<QualifiedName>> stringToQNameMap;

    public QualifiedNameMap(Map<QualifiedName, V> fields) {
        this.members = fields;
        this.stringToQNameMap = this.getStringToQNamesMap(fields.keySet());
    }

    public Map<QualifiedName, V> getMembers() {
        return this.members;
    }

    public V remove(QualifiedName qName) {
        V field = this.members.remove(qName);
        if (field == null) {
            Map<String, List<QualifiedName>> fields = this.stringToQNameMap;
            String localName = qName.getLocalPart();
            if (!fields.containsKey(localName)) {
                return null;
            }
            List<QualifiedName> qNames = fields.get(localName);
            for (QualifiedName qualifiedName : fields.get(localName)) {
                if (!DataUtils.isSameNamespace(qualifiedName, qName) || !DataUtils.isSameAttributeFlag(qualifiedName.getAttributeState(), qName.getAttributeState())) continue;
                field = this.members.remove(qualifiedName);
                qNames.remove(qualifiedName);
                break;
            }
            if (qNames.isEmpty()) {
                fields.remove(localName);
            }
        }
        return field;
    }

    public boolean contains(QualifiedName qName) {
        if (this.members.containsKey(qName)) {
            return true;
        }
        String localName = qName.getLocalPart();
        if (!this.stringToQNameMap.containsKey(localName)) {
            return false;
        }
        for (QualifiedName qualifiedName : this.stringToQNameMap.get(localName)) {
            if (!DataUtils.isSameNamespace(qualifiedName, qName) || !DataUtils.isSameAttributeFlag(qualifiedName.getAttributeState(), qName.getAttributeState())) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String localName) {
        return this.stringToQNameMap.containsKey(localName);
    }

    public void put(QualifiedName qName, V value) {
        this.members.put(qName, value);
        String localName = qName.getLocalPart();
        if (this.stringToQNameMap.containsKey(localName)) {
            this.stringToQNameMap.get(localName).add(qName);
        } else {
            ArrayList<QualifiedName> qNames = new ArrayList<QualifiedName>();
            qNames.add(qName);
            this.stringToQNameMap.put(localName, qNames);
        }
    }

    public V get(QualifiedName qName) {
        if (this.members.containsKey(qName)) {
            return this.members.get(qName);
        }
        String localName = qName.getLocalPart();
        if (!this.stringToQNameMap.containsKey(localName)) {
            return null;
        }
        for (QualifiedName qualifiedName : this.stringToQNameMap.get(localName)) {
            if (!DataUtils.isSameNamespace(qualifiedName, qName)) continue;
            return this.members.get(qualifiedName);
        }
        return null;
    }

    public V getOrDefault(QualifiedName qName, V defaultValue) {
        V value = this.get(qName);
        return value != null ? value : defaultValue;
    }

    public boolean isEmpty() {
        return this.members.isEmpty();
    }

    public QualifiedName getMatchedQualifiedName(QualifiedName elementQName) {
        if (this.members.containsKey(elementQName)) {
            return elementQName;
        }
        String localName = elementQName.getLocalPart();
        if (!this.stringToQNameMap.containsKey(localName)) {
            return null;
        }
        for (QualifiedName qualifiedName : this.stringToQNameMap.get(localName)) {
            if (!DataUtils.isSameNamespace(qualifiedName, elementQName) || !DataUtils.isSameAttributeFlag(qualifiedName.getAttributeState(), elementQName.getAttributeState())) continue;
            return qualifiedName;
        }
        return null;
    }

    public void clear() {
        this.members.clear();
        this.stringToQNameMap.clear();
    }

    private Map<String, List<QualifiedName>> getStringToQNamesMap(Set<QualifiedName> fieldQNames) {
        HashMap<String, List<QualifiedName>> fields = new HashMap<String, List<QualifiedName>>();
        for (QualifiedName qName : fieldQNames) {
            String localName = qName.getLocalPart();
            if (fields.containsKey(localName)) {
                ((List)fields.get(localName)).add(qName);
                continue;
            }
            ArrayList<QualifiedName> qNames = new ArrayList<QualifiedName>();
            qNames.add(qName);
            fields.put(localName, qNames);
        }
        return fields;
    }
}

