/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.xmldata.utils.xsd;

import io.ballerina.lib.data.xmldata.utils.Constants;
import io.ballerina.lib.data.xmldata.utils.DiagnosticErrorCode;
import io.ballerina.lib.data.xmldata.utils.DiagnosticLog;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;

public class ElementInfo {
    String name;
    public String fieldName;
    public long minOccurs;
    public long maxOccurs;
    public int occurrences;
    public boolean isInsideChoice = false;

    public ElementInfo(String name, String fieldName, BMap<BString, Object> element) {
        this.name = name;
        this.fieldName = fieldName;
        this.minOccurs = element.containsKey((Object)Constants.MIN_OCCURS) ? element.getIntValue(Constants.MIN_OCCURS) : 1L;
        this.maxOccurs = element.containsKey((Object)Constants.MAX_OCCURS) ? element.getIntValue(Constants.MAX_OCCURS) : Math.max(this.minOccurs, 1L);
        this.occurrences = 0;
    }

    public void updateOccurrences() {
        ++this.occurrences;
        if ((long)this.occurrences > this.maxOccurs) {
            throw DiagnosticLog.error(DiagnosticErrorCode.ELEMENT_OCCURS_MORE_THAN_MAX_ALLOWED_TIMES, this.name);
        }
    }

    public void validate() throws BError {
        this.validateMinOccurrences();
    }

    private void validateMinOccurrences() throws BError {
        if (!this.isInsideChoice && (long)this.occurrences < this.minOccurs) {
            throw DiagnosticLog.error(DiagnosticErrorCode.ELEMENT_OCCURS_LESS_THAN_MIN_REQUIRED_TIMES, this.name);
        }
    }
}

