/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.xmldata.xpath;

import io.ballerina.lib.data.xmldata.utils.DiagnosticLog;
import io.ballerina.lib.data.xmldata.xpath.ConvertibleBasicType;
import io.ballerina.lib.data.xmldata.xpath.InvalidQueryException;
import io.ballerina.lib.data.xmldata.xpath.ResultTypeMismatchException;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.types.XmlNodeType;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.Env;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.ShapeAnalyzer;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.runtime.api.values.BXmlSequence;
import java.io.StringReader;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import org.ballerinalang.langlib.xml.Concat;

public final class XPath {
    private static final Processor processor = new Processor(false);
    private static final List<ConvertibleBasicType<?>> DEFAULT_CANDIDATE_TYPES = List.of(ConvertibleBasicType.INT, ConvertibleBasicType.FLOAT, ConvertibleBasicType.DECIMAL, ConvertibleBasicType.BOOLEAN, ConvertibleBasicType.STRING, ConvertibleBasicType.XML);

    private XPath() {
    }

    public static Object transform(BXml value, BObject query, BTypedesc td) {
        try {
            XdmValue result = XPath.query(XPath.convertRawTemplateToString(query), XPath.from(value));
            return XPath.convertToBType(result, td);
        }
        catch (InvalidQueryException | ResultTypeMismatchException e) {
            return DiagnosticLog.createXmlError(e.getMessage());
        }
    }

    private static Object convertToBType(XdmValue value, BTypedesc td) throws ResultTypeMismatchException {
        Context cx = Context.from((Env)Env.getInstance());
        assert (!Core.isNever((SemType)SemType.tryInto((Context)cx, (Type)td.getDescribingType()))) : "Target type must not be never";
        return switch (value.size()) {
            case 0 -> XPath.convertToNil(cx, value, td);
            case 1 -> XPath.convertToSingleValue(cx, value, td);
            default -> XPath.convertToSequence(cx, value, td);
        };
    }

    private static Object convertToSequence(Context cx, XdmValue value, BTypedesc td) throws ResultTypeMismatchException {
        if (!ConvertibleBasicType.XML.isValidCandidate(cx, td)) {
            throw new ResultTypeMismatchException(value, td.getDescribingType());
        }
        XdmSequenceIterator it = value.iterator();
        Object[] items = it.stream().map(ConvertibleBasicType.XML::convertToType).toArray(BXml[]::new);
        return Concat.concat((Object[])items);
    }

    private static Object convertToSingleValue(Context cx, XdmValue value, BTypedesc td) throws ResultTypeMismatchException {
        SemType describingTy = SemType.tryInto((Context)cx, (Type)td.getDescribingType());
        return XPath.getCandidateSequence(cx, td).filter(candidate -> candidate.isValidCandidate(cx, td)).map(candidate -> candidate.tryConvertToType(value)).filter(Optional::isPresent).map(Optional::get).filter(v -> {
            SemType inherentType = (SemType)ShapeAnalyzer.inherentTypeOf((Context)cx, (Object)v).orElseThrow(() -> new RuntimeException("Inherent type not found for: " + String.valueOf(v)));
            return Core.isSubType((Context)cx, (SemType)inherentType, (SemType)describingTy);
        }).findFirst().orElseThrow(() -> new ResultTypeMismatchException(value, td.getDescribingType()));
    }

    private static Stream<ConvertibleBasicType<?>> getCandidateSequence(Context cx, BTypedesc td) {
        Type describingType = td.getDescribingType();
        if (!(describingType instanceof UnionType)) {
            return DEFAULT_CANDIDATE_TYPES.stream();
        }
        UnionType unionType = (UnionType)describingType;
        return unionType.getMemberTypes().stream().flatMap(each -> XPath.getCandidateConvertibleTypes(cx, each));
    }

    private static Stream<ConvertibleBasicType<?>> getCandidateConvertibleTypes(Context cx, Type type) {
        SemType ty = SemType.tryInto((Context)cx, (Type)type);
        return DEFAULT_CANDIDATE_TYPES.stream().filter(each -> Core.containsBasicType((SemType)ty, (SemType)each.basicType()));
    }

    private static Object convertToNil(Context cx, XdmValue value, BTypedesc td) throws ResultTypeMismatchException {
        ConvertibleBasicType<Object> nil = ConvertibleBasicType.NIL;
        if (nil.isValidCandidate(cx, td)) {
            return null;
        }
        throw new ResultTypeMismatchException(value, td.getDescribingType());
    }

    private static XdmValue query(String xPath, String xml) throws InvalidQueryException {
        XdmNode xmlDocument;
        DocumentBuilder builder = processor.newDocumentBuilder();
        try {
            xmlDocument = builder.build((Source)new StreamSource(new StringReader(xml)));
        }
        catch (SaxonApiException e) {
            throw new RuntimeException(e);
        }
        XPathCompiler xpathCompiler = processor.newXPathCompiler();
        try {
            XPathExecutable executable = xpathCompiler.compile(xPath);
            XPathSelector selector = executable.load();
            selector.setContextItem((XdmItem)xmlDocument);
            return selector.evaluate();
        }
        catch (SaxonApiException e) {
            throw new InvalidQueryException(xPath);
        }
    }

    private static String from(BXml bXml) {
        BXml xmlInput = bXml;
        if (xmlInput.getNodeType() == XmlNodeType.SEQUENCE) {
            xmlInput = ValueCreator.createXmlItem((QName)new QName("root"), (BXmlSequence)((BXmlSequence)xmlInput));
            String input = xmlInput.toString();
            return input.substring(6, input.length() - 7).trim();
        }
        return xmlInput.toString();
    }

    public static String convertRawTemplateToString(BObject rawTemplate) {
        BArray insertionsArray = rawTemplate.getArrayValue(StringUtils.fromString((String)"insertions"));
        BArray stringsArray = rawTemplate.getArrayValue(StringUtils.fromString((String)"strings"));
        int stringArraySize = stringsArray.size();
        if (stringArraySize == 0) {
            return "";
        }
        long insertionLength = insertionsArray.getLength();
        StringBuilder query = new StringBuilder(stringsArray.getBString(0L).getValue());
        for (int i = 1; i < stringArraySize; ++i) {
            String templatedString = "";
            if ((long)(i - 1) < insertionLength) {
                templatedString = StringUtils.getStringValue((Object)insertionsArray.get((long)(i - 1)));
            }
            query.append(templatedString).append(stringsArray.getBString((long)i).getValue());
        }
        return query.toString();
    }
}

