/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.net.URI;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.debugadapter.DebugSourceType;
import org.ballerinalang.debugadapter.ExecutionContext;
import org.ballerinalang.debugadapter.config.ClientConfigHolder;
import org.ballerinalang.debugadapter.jdi.JdiProxyException;
import org.ballerinalang.debugadapter.jdi.LocalVariableProxyImpl;
import org.ballerinalang.debugadapter.jdi.StackFrameProxyImpl;
import org.ballerinalang.debugadapter.utils.PackageUtils;
import org.ballerinalang.debugadapter.utils.ServerUtils;
import org.ballerinalang.debugadapter.variable.BVariableType;
import org.ballerinalang.debugadapter.variable.VariableUtils;
import org.eclipse.lsp4j.debug.Source;
import org.eclipse.lsp4j.debug.StackFrame;

public class BallerinaStackFrame {
    private final ExecutionContext context;
    private final Integer frameId;
    private final StackFrameProxyImpl jStackFrame;
    private StackFrame dapStackFrame;
    private static final String STRAND_FIELD_NAME = "name";
    private static final String FRAME_TYPE_START = "start";
    private static final String FRAME_TYPE_WORKER = "worker";
    private static final String FRAME_TYPE_ANONYMOUS = "anonymous";
    private static final String FRAME_SEPARATOR = ":";
    private static final String ACCESSOR_DEFAULT = "default";
    private static final String METHOD_INIT = "$init$";
    private static final String SELF_VAR_NAME = "self";
    private static final String WORKER_LAMBDA_REGEX = "(\\$lambda\\$)\\b(.*)\\b(\\$lambda)(.*)";
    private static final String BALA_URI_SCHEME_NAME = "bala:";

    public BallerinaStackFrame(ExecutionContext context, Integer frameId, StackFrameProxyImpl stackFrameProxy) {
        this.context = context;
        this.frameId = frameId;
        this.jStackFrame = stackFrameProxy;
    }

    public StackFrameProxyImpl getJStackFrame() {
        return this.jStackFrame;
    }

    public Optional<StackFrame> getAsDAPStackFrame() {
        if (this.dapStackFrame != null) {
            return Optional.of(this.dapStackFrame);
        }
        this.dapStackFrame = this.computeDapStackFrame();
        return Optional.ofNullable(this.dapStackFrame);
    }

    private StackFrame computeDapStackFrame() {
        try {
            boolean supportsReadOnlyEditors;
            if (!ServerUtils.isBalStackFrame(this.jStackFrame.getStackFrame())) {
                return null;
            }
            StackFrame dapStackFrame = new StackFrame();
            dapStackFrame.setId(this.frameId.intValue());
            dapStackFrame.setName(BallerinaStackFrame.getStackFrameName(this.jStackFrame));
            dapStackFrame.setLine(this.jStackFrame.location().lineNumber());
            dapStackFrame.setColumn(0);
            Optional<Map.Entry<Path, DebugSourceType>> sourcePathAndType = PackageUtils.getStackFrameSourcePath(this.context, this.context.getSourceProject(), this.jStackFrame.location());
            if (sourcePathAndType.isEmpty()) {
                return null;
            }
            Path frameLocationPath = sourcePathAndType.get().getKey();
            DebugSourceType sourceType = sourcePathAndType.get().getValue();
            Source source = new Source();
            source.setName(this.jStackFrame.location().sourceName());
            URI uri = frameLocationPath.toAbsolutePath().toUri();
            Optional<ClientConfigHolder.ExtendedClientCapabilities> capabilities = this.context.getAdapter().getClientConfigHolder().getExtendedCapabilities();
            boolean bl = supportsReadOnlyEditors = capabilities.isPresent() && capabilities.get().supportsReadOnlyEditors();
            if (supportsReadOnlyEditors && sourceType == DebugSourceType.DEPENDENCY) {
                source.setPath(PackageUtils.covertToBalaUri(uri).toString());
            } else {
                source.setPath(uri.toString());
            }
            dapStackFrame.setSource(source);
            return dapStackFrame;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getStackFrameName(StackFrameProxyImpl stackFrame) {
        try {
            Value frameNameValue;
            ObjectReference strand = BallerinaStackFrame.getStrand(stackFrame);
            String frameName = strand != null ? ((frameNameValue = strand.getValue(strand.referenceType().fieldByName(STRAND_FIELD_NAME))) != null ? VariableUtils.removeRedundantQuotes(String.valueOf(frameNameValue)) : FRAME_TYPE_ANONYMOUS) : FRAME_TYPE_ANONYMOUS;
            if (stackFrame.location().method().name().matches(WORKER_LAMBDA_REGEX)) {
                return "worker:" + frameName;
            }
            if (stackFrame.location().method().name().contains("$lambda$")) {
                return stackFrame.visibleVariableByName("__strand") != null ? frameName : "start:" + frameName;
            }
            return BallerinaStackFrame.getFilteredStackFrame(stackFrame);
        }
        catch (Exception e) {
            return FRAME_TYPE_ANONYMOUS;
        }
    }

    private static String getFilteredStackFrame(StackFrameProxyImpl stackFrame) throws JdiProxyException {
        String stackFrameName = stackFrame.location().method().name();
        LocalVariableProxyImpl selfVariable = stackFrame.visibleVariableByName(SELF_VAR_NAME);
        if (selfVariable == null) {
            return stackFrameName;
        }
        Value selfValue = stackFrame.getValue(selfVariable);
        if (VariableUtils.isService(selfValue)) {
            if (stackFrameName.equals(METHOD_INIT)) {
                return BVariableType.SERVICE.getString();
            }
            String[] stackFrameNameParts = stackFrameName.split("\\$");
            if (stackFrameNameParts.length > 1 && stackFrameNameParts[1].equals(ACCESSOR_DEFAULT)) {
                return stackFrameNameParts[1];
            }
            return stackFrameNameParts.length > 2 ? stackFrameNameParts[2] : stackFrameName;
        }
        return stackFrameName;
    }

    private static ObjectReference getStrand(StackFrameProxyImpl frame) {
        try {
            if (frame.visibleVariableByName("__strand") == null) {
                return (ObjectReference)((ArrayReference)frame.getStackFrame().getArgumentValues().get(0)).getValue(0);
            }
            return (ObjectReference)frame.getValue(frame.visibleVariableByName("__strand"));
        }
        catch (Exception e) {
            return null;
        }
    }
}

