/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter;

import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.directory.BuildProject;
import io.ballerina.projects.directory.ProjectLoader;
import io.ballerina.projects.directory.SingleFileProject;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.ballerinalang.debugadapter.utils.PackageUtils;

public class DebugProjectCache {
    private final Map<Path, Project> loadedProjects = new ConcurrentHashMap<Path, Project>();

    public Project getOrLoadProject(Path filePath) {
        return this.getOrLoadProject(filePath, false);
    }

    public Project getOrLoadProject(Path filePath, boolean allowWorkspaceProjects) {
        Map.Entry<ProjectKind, Path> projectKindAndRoot = PackageUtils.computeProjectKindAndRoot(filePath, allowWorkspaceProjects);
        Path projectRoot = projectKindAndRoot.getValue();
        return this.loadedProjects.computeIfAbsent(projectRoot, key -> DebugProjectCache.loadProject(projectKindAndRoot));
    }

    public void clear() {
        this.loadedProjects.clear();
    }

    private static Project loadProject(Map.Entry<ProjectKind, Path> projectKindAndRoot) {
        ProjectKind projectKind = projectKindAndRoot.getKey();
        Path projectRoot = projectKindAndRoot.getValue();
        BuildOptions options = BuildOptions.builder().setOffline(Boolean.valueOf(true)).build();
        if (projectKind == ProjectKind.BUILD_PROJECT) {
            return BuildProject.load((Path)projectRoot, (BuildOptions)options);
        }
        if (projectKind == ProjectKind.SINGLE_FILE_PROJECT) {
            return SingleFileProject.load((Path)projectRoot, (BuildOptions)options);
        }
        return ProjectLoader.load((Path)projectRoot, (BuildOptions)options).project();
    }
}

