/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.StepRequest;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import org.ballerinalang.debugadapter.BallerinaStackFrame;
import org.ballerinalang.debugadapter.BreakpointProcessor;
import org.ballerinalang.debugadapter.DebugInstruction;
import org.ballerinalang.debugadapter.DebugOutputLogger;
import org.ballerinalang.debugadapter.ExecutionContext;
import org.ballerinalang.debugadapter.breakpoint.BalBreakpoint;
import org.ballerinalang.debugadapter.config.ClientConfigHolder;
import org.ballerinalang.debugadapter.jdi.JdiProxyException;
import org.ballerinalang.debugadapter.jdi.StackFrameProxyImpl;
import org.ballerinalang.debugadapter.jdi.ThreadReferenceProxyImpl;
import org.ballerinalang.debugadapter.utils.ServerUtils;
import org.eclipse.lsp4j.debug.ContinuedEventArguments;
import org.eclipse.lsp4j.debug.StackFrame;
import org.eclipse.lsp4j.debug.StoppedEventArguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDIEventProcessor {
    private final ExecutionContext context;
    private final BreakpointProcessor breakpointProcessor;
    private volatile boolean isRemoteVmAttached;
    private volatile boolean interruptFlag;
    private final List<EventRequest> stepRequests = new CopyOnWriteArrayList<EventRequest>();
    private static final List<ThreadReference> virtualThreads = new CopyOnWriteArrayList<ThreadReference>();
    private static final Logger LOGGER = LoggerFactory.getLogger(JDIEventProcessor.class);
    private CompletableFuture<Void> listeningTask;

    JDIEventProcessor(ExecutionContext context) {
        this.context = context;
        this.breakpointProcessor = new BreakpointProcessor(context, this);
        this.isRemoteVmAttached = true;
        this.interruptFlag = false;
        this.listeningTask = null;
    }

    BreakpointProcessor getBreakpointProcessor() {
        return this.breakpointProcessor;
    }

    List<ThreadReference> getVirtualThreads() {
        return virtualThreads;
    }

    void startListenAsync() {
        this.listeningTask = CompletableFuture.runAsync(() -> {
            while (this.isRemoteVmAttached && !this.interruptFlag) {
                try {
                    EventSet eventSet = this.context.getDebuggeeVM().eventQueue().remove();
                    EventIterator eventIterator = eventSet.eventIterator();
                    while (eventIterator.hasNext() && this.isRemoteVmAttached && !this.interruptFlag) {
                        this.processEvent(eventSet, (Event)eventIterator.next());
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error occurred while processing JDI events.", (Throwable)e);
                }
            }
            this.cleanupAfterListening();
        });
    }

    private void stopListening(boolean force) {
        this.interruptFlag = true;
        if (Objects.nonNull(this.listeningTask) && !this.listeningTask.isDone() && force) {
            this.listeningTask.cancel(true);
        }
    }

    private void cleanupAfterListening() {
        if (!this.context.isTerminateRequestReceived() && !this.interruptFlag) {
            this.context.getAdapter().terminateDebugSession(false, true);
        }
        this.isRemoteVmAttached = true;
        this.interruptFlag = false;
    }

    private void processEvent(EventSet eventSet, Event event) {
        if (event instanceof ClassPrepareEvent) {
            ClassPrepareEvent evt = (ClassPrepareEvent)event;
            if (!this.breakpointProcessor.getUserBreakpoints().isEmpty() && this.context.getPrevInstruction() != DebugInstruction.STEP_OVER) {
                this.breakpointProcessor.activateUserBreakPoints(evt.referenceType(), true);
            }
            eventSet.resume();
        } else if (event instanceof BreakpointEvent) {
            BreakpointEvent bpEvent = (BreakpointEvent)event;
            this.breakpointProcessor.processBreakpointEvent(bpEvent);
        } else if (event instanceof StepEvent) {
            StepEvent stepEvent = (StepEvent)event;
            ClientConfigHolder clientConfigs = this.context.getAdapter().getClientConfigHolder();
            int threadId = (int)stepEvent.thread().uniqueID();
            if (clientConfigs.isLowCodeMode() && this.hasSteppedIntoExternalSource(stepEvent)) {
                DebugOutputLogger logger = this.context.getAdapter().getOutputLogger();
                logger.sendDebugServerOutput("Stepping into external sources is not supported in low-code mode.");
                this.sendStepRequest(threadId, 3);
            } else if (this.isBallerinaSource(stepEvent.location())) {
                this.notifyStopEvent(event);
            } else {
                int stepType = ((StepRequest)event.request()).depth();
                this.sendStepRequest(threadId, stepType);
            }
        } else if (event instanceof VMDisconnectEvent || event instanceof VMDeathEvent || event instanceof VMDisconnectedException) {
            this.isRemoteVmAttached = false;
        } else if (event instanceof ThreadStartEvent) {
            ThreadStartEvent threadStartEvent = (ThreadStartEvent)event;
            ThreadReference thread = threadStartEvent.thread();
            if (thread.isVirtual()) {
                virtualThreads.add(thread);
            }
            eventSet.resume();
        } else if (event instanceof ThreadDeathEvent) {
            ThreadDeathEvent threadDeathEvent = (ThreadDeathEvent)event;
            ThreadReference thread = threadDeathEvent.thread();
            virtualThreads.remove(thread);
            eventSet.resume();
        } else {
            eventSet.resume();
        }
    }

    private boolean hasSteppedIntoExternalSource(StepEvent event) {
        int stepType = ((StepRequest)event.request()).depth();
        if (stepType != 1) {
            return false;
        }
        try {
            ThreadReferenceProxyImpl thread = this.context.getAdapter().getAllThreads().get((int)event.thread().uniqueID());
            Optional<StackFrame> topFrame = thread.frames().stream().map(this::toDapStackFrame).filter(ServerUtils::isValidFrame).findFirst();
            if (topFrame.isPresent()) {
                String path = topFrame.get().getSource().getPath();
                return path.startsWith("bala");
            }
            return false;
        }
        catch (JdiProxyException e) {
            throw new RuntimeException(e);
        }
    }

    private StackFrame toDapStackFrame(StackFrameProxyImpl stackFrameProxy) {
        try {
            if (!ServerUtils.isBalStackFrame(stackFrameProxy.getStackFrame())) {
                return null;
            }
            BallerinaStackFrame balStackFrame = new BallerinaStackFrame(this.context, 0, stackFrameProxy);
            return balStackFrame.getAsDAPStackFrame().orElse(null);
        }
        catch (JdiProxyException e) {
            return null;
        }
    }

    void enableBreakpoints(String qClassName, LinkedHashMap<Integer, BalBreakpoint> breakpoints) {
        this.breakpointProcessor.addSourceBreakpoints(qClassName, breakpoints);
        if (this.context.getDebuggeeVM() == null) {
            return;
        }
        this.context.getEventManager().deleteAllBreakpoints();
        if (this.breakpointProcessor.getUserBreakpoints().isEmpty()) {
            return;
        }
        this.context.getDebuggeeVM().allClasses().forEach(ref -> this.breakpointProcessor.activateUserBreakPoints((ReferenceType)ref, false));
    }

    void sendStepRequest(int threadId, int stepType) {
        if (stepType == 1 || stepType == 3) {
            this.createStepRequest(threadId, stepType);
        }
        this.context.getDebuggeeVM().resume();
        ContinuedEventArguments continuedEventArguments = new ContinuedEventArguments();
        continuedEventArguments.setAllThreadsContinued(Boolean.valueOf(true));
        this.context.getClient().continued(continuedEventArguments);
    }

    private void createStepRequest(int threadId, int stepType) {
        this.context.getEventManager().deleteEventRequests(this.stepRequests);
        ThreadReferenceProxyImpl proxy = this.context.getAdapter().getAllThreads().get(threadId);
        if (proxy == null || proxy.getThreadReference() == null) {
            return;
        }
        StepRequest request = this.context.getEventManager().createStepRequest(proxy.getThreadReference(), -2, stepType);
        request.setSuspendPolicy(2);
        request.addClassExclusionFilter("io.*");
        request.addClassExclusionFilter("com.*");
        request.addClassExclusionFilter("org.*");
        request.addClassExclusionFilter("java.*");
        request.addClassExclusionFilter("$lambda$main$");
        request.addCountFilter(1);
        this.stepRequests.add(request);
        request.enable();
    }

    List<BallerinaStackFrame> filterValidBallerinaFrames(List<StackFrameProxyImpl> jStackFrames) {
        ArrayList<BallerinaStackFrame> validFrames = new ArrayList<BallerinaStackFrame>();
        for (StackFrameProxyImpl stackFrameProxy : jStackFrames) {
            try {
                BallerinaStackFrame balStackFrame;
                if (!ServerUtils.isBalStackFrame(stackFrameProxy.getStackFrame()) || (balStackFrame = new BallerinaStackFrame(this.context, 0, stackFrameProxy)).getAsDAPStackFrame().isEmpty() || !ServerUtils.isValidFrame(balStackFrame.getAsDAPStackFrame().get())) continue;
                validFrames.add(balStackFrame);
            }
            catch (Exception exception) {}
        }
        return validFrames;
    }

    private boolean isBallerinaSource(Location location) {
        try {
            String sourceName = location.sourceName();
            int sourceLine = location.lineNumber();
            return sourceName.endsWith(".bal") && sourceLine > 0;
        }
        catch (AbsentInformationException e) {
            return false;
        }
    }

    void notifyStopEvent(Event event) {
        if (event instanceof BreakpointEvent) {
            BreakpointEvent breakpointEvent = (BreakpointEvent)event;
            this.notifyStopEvent("breakpoint", breakpointEvent.thread().uniqueID());
        } else if (event instanceof StepEvent) {
            StepEvent stepEvent = (StepEvent)event;
            this.notifyStopEvent("step", stepEvent.thread().uniqueID());
        }
    }

    void notifyStopEvent(String reason, long threadId) {
        this.context.getEventManager().deleteEventRequests(this.stepRequests);
        StoppedEventArguments stoppedEventArguments = new StoppedEventArguments();
        stoppedEventArguments.setReason(reason);
        stoppedEventArguments.setThreadId(Integer.valueOf((int)threadId));
        stoppedEventArguments.setAllThreadsStopped(Boolean.valueOf(true));
        this.context.getClient().stopped(stoppedEventArguments);
    }

    public void reset() {
        this.stopListening(true);
        this.stepRequests.clear();
        virtualThreads.clear();
    }
}

