/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter;

import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.Value;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.Project;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.debugadapter.DebugSourceType;
import org.ballerinalang.debugadapter.ExecutionContext;
import org.ballerinalang.debugadapter.evaluation.DebugExpressionCompiler;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.jdi.JdiProxyException;
import org.ballerinalang.debugadapter.jdi.StackFrameProxyImpl;
import org.ballerinalang.debugadapter.jdi.ThreadReferenceProxyImpl;
import org.ballerinalang.debugadapter.jdi.VirtualMachineProxyImpl;
import org.ballerinalang.debugadapter.utils.PackageUtils;

public class SuspendedContext {
    private final ExecutionContext executionContext;
    private final VirtualMachineProxyImpl attachedVm;
    private final ThreadReferenceProxyImpl owningThread;
    private final StackFrameProxyImpl frame;
    private final Project project;
    private DebugSourceType sourceType;
    private Path breakPointSourcePath;
    private String fileName;
    private int lineNumber;
    private Module module;
    private Document document;
    private ClassLoaderReference classLoader;
    private DebugExpressionCompiler debugCompiler;

    SuspendedContext(ExecutionContext executionContext, ThreadReferenceProxyImpl threadRef, StackFrameProxyImpl frame) {
        this.executionContext = executionContext;
        this.owningThread = threadRef;
        this.frame = frame;
        this.attachedVm = executionContext.getDebuggeeVM();
        this.lineNumber = -1;
        this.project = this.resolveCurrentProject(executionContext.getSourceProject());
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public Project getProject() {
        return this.project;
    }

    public VirtualMachineProxyImpl getAttachedVm() {
        return this.attachedVm;
    }

    public ClassLoaderReference getDebuggeeClassLoader() {
        if (this.classLoader == null) {
            try {
                this.classLoader = this.frame.location().declaringType().classLoader();
            }
            catch (JdiProxyException e) {
                this.classLoader = null;
            }
        }
        return this.classLoader;
    }

    public ThreadReferenceProxyImpl getOwningThread() {
        return this.owningThread;
    }

    public StackFrameProxyImpl getFrame() {
        return this.frame;
    }

    public DebugSourceType getSourceType() {
        if (this.sourceType == null) {
            Project project = this.getProject();
            switch (project.kind()) {
                case BUILD_PROJECT: {
                    this.sourceType = DebugSourceType.PACKAGE;
                    break;
                }
                case SINGLE_FILE_PROJECT: {
                    this.sourceType = DebugSourceType.SINGLE_FILE;
                    break;
                }
                default: {
                    this.sourceType = DebugSourceType.DEPENDENCY;
                }
            }
        }
        return this.sourceType;
    }

    public Optional<String> getPackageOrg() {
        return Optional.ofNullable(this.project.currentPackage().packageOrg().toString());
    }

    public Optional<String> getPackageName() {
        return Optional.ofNullable(this.project.currentPackage().packageName().toString());
    }

    public Optional<String> getPackageVersion() {
        return Optional.ofNullable(this.project.currentPackage().packageVersion().toString());
    }

    public Optional<String> getPackageMajorVersion() {
        return Optional.of(String.valueOf(this.project.currentPackage().packageVersion().value().major()));
    }

    public Optional<String> getModuleName() {
        return Optional.ofNullable(this.project.currentPackage().getDefaultModule().moduleName().toString());
    }

    public Optional<Path> getBreakPointSourcePath(Project project) {
        if (this.breakPointSourcePath == null) {
            Optional<Path> sourcePath = this.getSourcePath(project, this.frame);
            sourcePath.ifPresent(path -> {
                this.breakPointSourcePath = path.normalize();
            });
        }
        return Optional.ofNullable(this.breakPointSourcePath);
    }

    private Optional<Path> getSourcePath(Project sourceProject, StackFrameProxyImpl frame) {
        try {
            Optional<Map.Entry<Path, DebugSourceType>> pathAndType = PackageUtils.getStackFrameSourcePath(this.executionContext, sourceProject, frame.location());
            return pathAndType.map(Map.Entry::getKey);
        }
        catch (InvalidStackFrameException | JdiProxyException e) {
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public DebugExpressionCompiler getDebugCompiler() {
        if (this.debugCompiler == null) {
            this.debugCompiler = new DebugExpressionCompiler(this);
        }
        return this.debugCompiler;
    }

    public SemanticModel getSemanticInfo() {
        return this.getDebugCompiler().getSemanticInfo();
    }

    public Value getCurrentStrand() throws EvaluationException {
        try {
            Value strand = this.getFrame().getValue(this.getFrame().visibleVariableByName("__strand"));
            if (strand == null) {
                throw EvaluationException.createEvaluationException(EvaluationExceptionKind.STRAND_NOT_FOUND, new Object[0]);
            }
            return strand;
        }
        catch (JdiProxyException e) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.STRAND_NOT_FOUND, new Object[0]);
        }
    }

    public Optional<String> getFileName() {
        if (this.fileName == null) {
            Optional<Path> breakPointPath = this.getBreakPointSourcePath(this.project);
            if (breakPointPath.isEmpty()) {
                return Optional.empty();
            }
            this.fileName = PackageUtils.getFileNameFrom(breakPointPath.get());
        }
        return Optional.ofNullable(this.fileName);
    }

    public int getLineNumber() {
        if (this.lineNumber < 0) {
            try {
                this.lineNumber = this.frame.location().lineNumber();
            }
            catch (JdiProxyException e) {
                this.lineNumber = -1;
            }
        }
        return this.lineNumber;
    }

    public Module getModule() {
        if (this.module == null) {
            this.loadModule();
        }
        return this.module;
    }

    public Document getDocument() {
        if (this.document == null) {
            this.loadDocument();
        }
        return this.document;
    }

    private void loadModule() {
        Optional<Path> breakPointSourcePath = this.getBreakPointSourcePath(this.project);
        if (breakPointSourcePath.isEmpty()) {
            return;
        }
        DocumentId documentId = this.project.documentId(breakPointSourcePath.get());
        this.module = this.project.currentPackage().module(documentId.moduleId());
    }

    private void loadDocument() {
        Optional<Path> breakPointSourcePath = this.getBreakPointSourcePath(this.project);
        if (breakPointSourcePath.isEmpty()) {
            return;
        }
        DocumentId documentId = this.project.documentId(breakPointSourcePath.get());
        this.module = this.project.currentPackage().module(documentId.moduleId());
        this.document = this.module.document(documentId);
    }

    private Project resolveCurrentProject(Project sourceProject) {
        Optional<Path> breakPointSourcePath = this.getBreakPointSourcePath(sourceProject);
        if (breakPointSourcePath.isPresent()) {
            return this.executionContext.getProjectCache().getOrLoadProject(breakPointSourcePath.get());
        }
        return sourceProject;
    }
}

