/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.completion.util;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import io.ballerina.tools.text.TextRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.debugadapter.SuspendedContext;
import org.ballerinalang.debugadapter.completion.FunctionCompletionItemBuilder;
import org.ballerinalang.debugadapter.completion.context.CompletionContext;
import org.ballerinalang.debugadapter.evaluation.DebugExpressionCompiler;
import org.eclipse.lsp4j.debug.CompletionItem;
import org.eclipse.lsp4j.debug.CompletionItemType;
import org.eclipse.lsp4j.debug.CompletionsArguments;

public final class CompletionUtil {
    private static final String PARENTHESIS = "()";
    private static final List<String> triggerCharacters = Arrays.asList(".", ">");

    private CompletionUtil() {
    }

    public static String getUpdatedBalFileContent(CompletionContext completionContext, CompletionsArguments args, NonTerminalNode node, int lineNumber) {
        SuspendedContext suspendedContext = completionContext.getSuspendedContext();
        TextDocument textDocument = suspendedContext.getDocument().textDocument();
        List<String> lines = Arrays.asList(textDocument.toString().split(System.lineSeparator()));
        if (node.kind() == SyntaxKind.FUNCTION_BODY_BLOCK) {
            nodeStartLine = node.lineRange().startLine().line();
            int nodeEndLine = node.lineRange().endLine().line();
            if (nodeStartLine == lineNumber - 1) {
                lineContent = lines.get(nodeStartLine);
                lineContent = (String)lineContent + System.lineSeparator() + args.getText();
                lines.set(nodeStartLine, (String)lineContent);
            } else if (nodeEndLine == lineNumber - 1) {
                lineContent = lines.get(nodeEndLine);
                int startLineOffSet = node.lineRange().endLine().offset() - 1;
                lineContent = ((String)lineContent).substring(0, startLineOffSet) + args.getText() + System.lineSeparator() + String.join((CharSequence)"", Collections.nCopies(startLineOffSet, " ")) + ((String)lineContent).substring(startLineOffSet);
                lines.set(nodeEndLine, (String)lineContent);
            }
        } else {
            nodeStartLine = node.lineRange().startLine().line();
            Object lineContent = lines.get(nodeStartLine);
            int startLineOffSet = node.lineRange().startLine().offset();
            lineContent = ((String)lineContent).substring(0, startLineOffSet) + args.getText() + System.lineSeparator() + String.join((CharSequence)"", Collections.nCopies(startLineOffSet, " ")) + ((String)lineContent).substring(startLineOffSet);
            lines.set(nodeStartLine, (String)lineContent);
        }
        StringBuilder result = new StringBuilder();
        for (String line : lines) {
            result.append(line).append(System.lineSeparator());
        }
        return result.toString();
    }

    public static Optional<Node> getResolverNode(NonTerminalNode node) {
        if (node == null || node.kind() == SyntaxKind.MODULE_PART) {
            return Optional.empty();
        }
        if (node.kind() == SyntaxKind.FIELD_ACCESS || node.kind() == SyntaxKind.REMOTE_METHOD_CALL_ACTION || node.kind() == SyntaxKind.ASYNC_SEND_ACTION) {
            return Optional.of(node);
        }
        return CompletionUtil.getResolverNode(node.parent());
    }

    public static CompletionItem[] getVisibleSymbolCompletions(CompletionContext completionContext) {
        SuspendedContext suspendedContext = completionContext.getSuspendedContext();
        DebugExpressionCompiler debugCompiler = suspendedContext.getDebugCompiler();
        SemanticModel semanticContext = debugCompiler.getSemanticInfo();
        List symbolList = semanticContext.visibleSymbols(suspendedContext.getDocument(), LinePosition.from((int)(suspendedContext.getLineNumber() - 1), (int)0));
        return CompletionUtil.getCompletions(symbolList);
    }

    public static CompletionItem[] getCompletions(List<Symbol> symbolList) {
        ArrayList<CompletionItem> completionItems = new ArrayList<CompletionItem>();
        for (Symbol symbol : symbolList) {
            CompletionItem completionItem = new CompletionItem();
            if (symbol.getName().isPresent() && (symbol.kind().name().equals(CompletionItemType.METHOD.toString()) || symbol.kind().name().equals(CompletionItemType.FUNCTION.toString()))) {
                completionItem.setLabel((String)symbol.getName().get() + PARENTHESIS);
                completionItem.setText((String)symbol.getName().get() + PARENTHESIS);
            } else {
                completionItem.setLabel((String)symbol.getName().get());
                completionItem.setText((String)symbol.getName().get());
            }
            completionItem.setType(CompletionUtil.getCompletionItemType(symbol));
            completionItems.add(completionItem);
        }
        return completionItems.toArray(new CompletionItem[0]);
    }

    public static List<CompletionItem> getCompletionItemList(List<? extends Symbol> scopeEntries, CompletionContext ctx) {
        ArrayList processedSymbols = new ArrayList();
        ArrayList<CompletionItem> completionItems = new ArrayList<CompletionItem>();
        scopeEntries.forEach(symbol -> {
            if (processedSymbols.contains(symbol)) {
                return;
            }
            if (symbol.kind() == SymbolKind.FUNCTION || symbol.kind() == SymbolKind.METHOD) {
                completionItems.addAll(CompletionUtil.populateBallerinaFunctionCompletionItems(symbol, ctx));
            }
            processedSymbols.add(symbol);
        });
        return completionItems;
    }

    private static List<CompletionItem> populateBallerinaFunctionCompletionItems(Symbol symbol, CompletionContext context) {
        ArrayList<CompletionItem> completionItems = new ArrayList<CompletionItem>();
        if (symbol.kind() != SymbolKind.FUNCTION && symbol.kind() != SymbolKind.METHOD) {
            return completionItems;
        }
        CompletionItem completionItem = FunctionCompletionItemBuilder.build((FunctionSymbol)symbol, context);
        completionItems.add(completionItem);
        return completionItems;
    }

    private static CompletionItemType getCompletionItemType(Symbol symbol) {
        return switch (symbol.kind()) {
            case SymbolKind.MODULE -> CompletionItemType.MODULE;
            case SymbolKind.FUNCTION -> CompletionItemType.FUNCTION;
            case SymbolKind.METHOD, SymbolKind.RESOURCE_METHOD -> CompletionItemType.METHOD;
            case SymbolKind.VARIABLE -> CompletionItemType.VARIABLE;
            case SymbolKind.CLASS -> CompletionItemType.CLASS;
            case SymbolKind.RECORD_FIELD, SymbolKind.OBJECT_FIELD, SymbolKind.CLASS_FIELD -> CompletionItemType.FIELD;
            case SymbolKind.ENUM -> CompletionItemType.ENUM;
            default -> null;
        };
    }

    public static NonTerminalNode getNonTerminalNode(CompletionContext completionContext, String source, String sourcePath, int lineNumber) {
        return CompletionUtil.getNonTerminalNode(completionContext, source, sourcePath, null, lineNumber, 0);
    }

    public static NonTerminalNode getNonTerminalNode(CompletionContext completionContext, String source, String sourcePath, NonTerminalNode nonTerminalNode, int lineNumber, int column) {
        TextDocument document = TextDocuments.from((String)source);
        SyntaxTree syntaxTree = SyntaxTree.from((TextDocument)document, (String)sourcePath);
        int textPosition = CompletionUtil.getTextPosition(nonTerminalNode, document, lineNumber, column - 1);
        completionContext.setCursorPositionInTree(textPosition);
        TextRange range = TextRange.from((int)textPosition, (int)0);
        return ((ModulePartNode)syntaxTree.rootNode()).findNode(range);
    }

    private static int getTextPosition(NonTerminalNode nonTerminalNode, TextDocument textDocument, int lineNumber, int offset) {
        int textPosition = 0;
        if (nonTerminalNode == null) {
            return textDocument.textPositionFrom(LinePosition.from((int)lineNumber, (int)offset));
        }
        if (nonTerminalNode.kind() == SyntaxKind.FUNCTION_BODY_BLOCK) {
            if (nonTerminalNode.lineRange().startLine().line() == lineNumber - 1) {
                textPosition = textDocument.textPositionFrom(LinePosition.from((int)(nonTerminalNode.lineRange().startLine().line() + 1), (int)offset));
            } else if (nonTerminalNode.lineRange().endLine().line() == lineNumber - 1) {
                textPosition = textDocument.textPositionFrom(LinePosition.from((int)nonTerminalNode.lineRange().endLine().line(), (int)offset));
            }
        } else {
            textPosition = textDocument.textPositionFrom(LinePosition.from((int)nonTerminalNode.lineRange().startLine().line(), (int)(nonTerminalNode.lineRange().startLine().offset() + offset)));
        }
        return textPosition;
    }

    public static boolean triggerCharactersFound(String expression) {
        return Arrays.stream(expression.split("")).anyMatch(triggerCharacters::contains);
    }

    public static List<String> getTriggerCharacters() {
        return triggerCharacters;
    }

    public static NonTerminalNode getInjectedExpressionNode(CompletionContext completionContext, CompletionsArguments args, String sourcePath, int lineNumber) {
        SuspendedContext suspendedContext = completionContext.getSuspendedContext();
        String source = suspendedContext.getDocument().textDocument().toString();
        NonTerminalNode nonTerminalNode = CompletionUtil.getNonTerminalNode(completionContext, source, sourcePath, lineNumber);
        while (!(nonTerminalNode instanceof StatementNode) && nonTerminalNode.kind() != SyntaxKind.FUNCTION_BODY_BLOCK) {
            nonTerminalNode = nonTerminalNode.parent();
        }
        String updatedSource = CompletionUtil.getUpdatedBalFileContent(completionContext, args, nonTerminalNode, lineNumber);
        return CompletionUtil.getNonTerminalNode(completionContext, updatedSource, sourcePath, nonTerminalNode, lineNumber, args.getColumn());
    }
}

