/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine;

import com.sun.jdi.Field;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Qualifiable;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import org.ballerinalang.debugadapter.EvaluationContext;
import org.ballerinalang.debugadapter.SuspendedContext;
import org.ballerinalang.debugadapter.evaluation.BExpressionValue;
import org.ballerinalang.debugadapter.evaluation.BImport;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.IdentifierModifier;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.RuntimeStaticMethod;
import org.ballerinalang.debugadapter.evaluation.utils.EvaluationUtils;
import org.ballerinalang.debugadapter.utils.PackageUtils;

public abstract class EvaluationTypeResolver<T> {
    protected final SuspendedContext context;
    protected final Map<String, BImport> resolvedImports;

    protected EvaluationTypeResolver(EvaluationContext evaluationContext) {
        this.context = evaluationContext.getSuspendedContext();
        this.resolvedImports = evaluationContext.getResolvedImports();
    }

    public abstract List<Value> resolve(T var1) throws EvaluationException;

    public Value getUnionTypeFrom(List<Value> resolvedTypes) throws EvaluationException {
        ArrayList<String> methodArgTypeNames = new ArrayList<String>();
        methodArgTypeNames.add("io.ballerina.runtime.api.types.Type[]");
        RuntimeStaticMethod method = EvaluationUtils.getRuntimeMethod(this.context, "io.ballerina.runtime.api.creators.TypeCreator", "createUnionType", methodArgTypeNames);
        ArrayList<Value> methodArgs = new ArrayList<Value>(resolvedTypes);
        method.setArgValues(methodArgs);
        return method.invokeSafely();
    }

    protected Optional<Value> resolveInbuiltType(String typeName) {
        try {
            List<String> methodArgTypeNames = Collections.singletonList("java.lang.String");
            RuntimeStaticMethod method = EvaluationUtils.getRuntimeMethod(this.context, "io.ballerina.runtime.api.utils.TypeUtils", "fromString", methodArgTypeNames);
            method.setArgValues(Collections.singletonList(this.context.getAttachedVm().mirrorOf(typeName)));
            return Optional.of(new BExpressionValue(this.context, method.invokeSafely()).getJdiValue());
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    protected Optional<Symbol> getModuleTypeDefinitionSymbol(String typeName) {
        SemanticModel semanticContext = this.context.getDebugCompiler().getSemanticInfo();
        return semanticContext.moduleSymbols().stream().filter(symbol -> symbol.kind() == SymbolKind.TYPE_DEFINITION || symbol.kind() == SymbolKind.CLASS).filter(symbol -> IdentifierModifier.encodeIdentifier((String)symbol.getName().get(), IdentifierModifier.IdentifierType.OTHER).equals(typeName)).findAny();
    }

    protected Optional<Symbol> getQualifiedTypeDefinitionSymbol(String modulePrefix, String typeName) {
        return this.resolvedImports.get(modulePrefix).getResolvedSymbol().allSymbols().stream().filter(symbol -> symbol.kind() == SymbolKind.TYPE_DEFINITION || symbol.kind() == SymbolKind.CLASS).filter(symbol -> IdentifierModifier.encodeIdentifier((String)symbol.getName().get(), IdentifierModifier.IdentifierType.OTHER).equals(typeName)).findAny();
    }

    protected Value createBArrayType(Value type) throws EvaluationException {
        ArrayList<String> argTypeNames = new ArrayList<String>();
        argTypeNames.add("io.ballerina.runtime.api.types.Type");
        RuntimeStaticMethod createArrayMethod = EvaluationUtils.getRuntimeMethod(this.context, "io.ballerina.runtime.api.creators.TypeCreator", "createArrayType", argTypeNames);
        ArrayList<Value> methodArgs = new ArrayList<Value>();
        methodArgs.add(type);
        createArrayMethod.setArgValues(methodArgs);
        return createArrayMethod.invokeSafely();
    }

    protected Optional<Value> resolveQualifiedType(String modulePrefix, String typeName) throws EvaluationException {
        Optional<Symbol> typeDefinition = this.getQualifiedTypeDefinitionSymbol(modulePrefix, typeName);
        if (typeDefinition.isEmpty()) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.NON_PUBLIC_OR_UNDEFINED_ACCESS, modulePrefix, typeName);
        }
        if (!EvaluationTypeResolver.isPublicSymbol(typeDefinition.get())) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.NON_PUBLIC_OR_UNDEFINED_ACCESS, modulePrefix, typeName);
        }
        for (String prefix : PackageUtils.TYPE_PREFIXES) {
            List<ReferenceType> classRefs;
            block6: {
                String typeClassName = this.constructClassNameFrom(typeDefinition.get(), typeName, prefix);
                try {
                    classRefs = this.context.getAttachedVm().classesByName(typeClassName);
                    if (!classRefs.isEmpty()) break block6;
                    ReferenceType referenceType = EvaluationUtils.loadClass(this.context, typeClassName, "");
                    classRefs = Collections.singletonList(referenceType);
                }
                catch (EvaluationException e) {
                    continue;
                }
            }
            ReferenceType classRef = classRefs.getFirst();
            Field typeField = classRef.fieldByName("t");
            if (typeField == null) {
                throw EvaluationException.createEvaluationException(EvaluationExceptionKind.TYPE_RESOLVING_ERROR, typeName);
            }
            return Optional.ofNullable(classRef.getValue(typeField));
        }
        throw EvaluationException.createEvaluationException(EvaluationExceptionKind.TYPE_RESOLVING_ERROR, typeName);
    }

    protected String constructClassNameFrom(Symbol typeSymbol, String typeName, String ... packageNames) {
        ModuleID moduleMeta = ((ModuleSymbol)typeSymbol.getModule().get()).id();
        StringJoiner classNameJoiner = new StringJoiner(".").add(IdentifierModifier.encodeModuleName(moduleMeta.orgName())).add(IdentifierModifier.encodeModuleName(moduleMeta.moduleName())).add(moduleMeta.version().split("\\.")[0]);
        for (String packageName : packageNames) {
            classNameJoiner.add(packageName);
        }
        return classNameJoiner.add(typeName).toString();
    }

    public static boolean isPublicSymbol(Symbol symbol) {
        if (symbol instanceof Qualifiable) {
            Qualifiable qualifiable = (Qualifiable)symbol;
            return qualifiable.qualifiers().stream().anyMatch(qualifier -> qualifier == Qualifier.PUBLIC);
        }
        return true;
    }
}

