/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.TextRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.debugadapter.EvaluationContext;
import org.ballerinalang.debugadapter.SuspendedContext;
import org.ballerinalang.debugadapter.evaluation.DebugExpressionEvaluator;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.engine.Evaluator;
import org.ballerinalang.debugadapter.evaluation.engine.NameBasedTypeResolver;
import org.ballerinalang.debugadapter.evaluation.engine.NodeBasedArgProcessor;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.RuntimeInstanceMethod;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.RuntimeStaticMethod;
import org.ballerinalang.debugadapter.evaluation.utils.EvaluationUtils;

public abstract class InvocationArgProcessor {
    protected final SuspendedContext context;
    protected final String functionName;
    protected final Method jdiMethodReference;
    protected static final String DEFAULTABLE_PARAM_SUFFIX = "[Defaultable]";
    protected static final String GET_ELEMENT_TYPE_METHOD = "getElementType";
    protected static final String UNKNOWN_VALUE = "unknown";

    protected InvocationArgProcessor(SuspendedContext context, String functionName, Method jdiMethodReference) {
        this.context = context;
        this.functionName = functionName;
        this.jdiMethodReference = jdiMethodReference;
    }

    public abstract List<Value> process(List<Map.Entry<String, Evaluator>> var1) throws EvaluationException;

    protected List<Value> getOrderedArgList(Map<String, Value> namedArgValues, FunctionSymbol definitionSymbol, FunctionDefinitionNode definitionNode) throws EvaluationException {
        try {
            ArrayList<Value> argValueList = new ArrayList<Value>();
            List<LocalVariable> args = this.jdiMethodReference.arguments();
            List<String> argNames = args.stream().filter(LocalVariable::isArgument).map(LocalVariable::name).toList();
            int argNamesSize = argNames.size();
            for (int i = 0; i < argNamesSize; ++i) {
                String argName = argNames.get(i);
                if (argName.equals("self") || argName.equals("__strand")) continue;
                String defaultableArgName = argName + DEFAULTABLE_PARAM_SUFFIX;
                if (namedArgValues.get(argName) == null && namedArgValues.get(defaultableArgName) != null) {
                    if (definitionNode == null && definitionSymbol != null) {
                        definitionNode = this.getDefinitionNodeFrom(argName.replace(DEFAULTABLE_PARAM_SUFFIX, ""), definitionSymbol);
                    }
                    if (definitionNode == null) continue;
                    argValueList.add(InvocationArgProcessor.getDefaultValue(this.context, args.get(i), definitionNode));
                    continue;
                }
                argValueList.add(namedArgValues.get(argName));
            }
            return EvaluationUtils.getAsObjects(this.context, argValueList);
        }
        catch (AbsentInformationException e) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.FUNCTION_EXECUTION_ERROR, this.jdiMethodReference.name());
        }
    }

    protected static Value getRestArgArray(SuspendedContext context, Value arrayType, Value ... values) throws EvaluationException {
        ArrayList<String> argTypeNames = new ArrayList<String>();
        argTypeNames.add("io.ballerina.runtime.api.types.Type");
        argTypeNames.add("io.ballerina.runtime.api.values.BValue[]");
        RuntimeStaticMethod getRestArgArray = EvaluationUtils.getRuntimeMethod(context, "org.ballerinalang.debugadapter.runtime.DebuggerRuntime", "getRestArgArray", argTypeNames);
        ArrayList<Value> argValues = new ArrayList<Value>();
        argValues.add(arrayType);
        argValues.addAll(Arrays.asList(values));
        getRestArgArray.setArgValues(argValues);
        return getRestArgArray.invokeSafely();
    }

    protected static Value getElementType(SuspendedContext context, Value arrayType) throws EvaluationException {
        ReferenceType arrayTypeRef = ((ObjectReference)arrayType).referenceType();
        List<Method> methods = arrayTypeRef.methodsByName(GET_ELEMENT_TYPE_METHOD);
        if (methods == null || methods.size() != 1) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.OBJECT_METHOD_NOT_FOUND, GET_ELEMENT_TYPE_METHOD, "ArrayType");
        }
        RuntimeInstanceMethod method = new RuntimeInstanceMethod(context, arrayType, methods.get(0));
        method.setArgValues(new ArrayList<Value>());
        return method.invokeSafely();
    }

    protected static ArgType getArgType(Map.Entry<String, Evaluator> arg) {
        if (InvocationArgProcessor.isPositionalArg(arg)) {
            return ArgType.POSITIONAL;
        }
        if (InvocationArgProcessor.isNamedArg(arg)) {
            return ArgType.NAMED;
        }
        if (InvocationArgProcessor.isRestArg(arg)) {
            return ArgType.REST;
        }
        return ArgType.UNKNOWN;
    }

    protected static Value resolveType(SuspendedContext context, String arrayTypeName) throws EvaluationException {
        NameBasedTypeResolver bTypeResolver = new NameBasedTypeResolver(new EvaluationContext(context));
        List<Value> resolvedTypes = bTypeResolver.resolve(arrayTypeName);
        return resolvedTypes.size() > 1 ? bTypeResolver.getUnionTypeFrom(resolvedTypes) : resolvedTypes.get(0);
    }

    private FunctionDefinitionNode getDefinitionNodeFrom(String argName, FunctionSymbol definitionSymbol) throws EvaluationException {
        try {
            TextRange textRange = ((Location)definitionSymbol.getLocation().get()).textRange();
            NonTerminalNode node = ((ModulePartNode)this.context.getDocument().syntaxTree().rootNode()).findNode(textRange);
            return (FunctionDefinitionNode)node;
        }
        catch (Exception e) {
            throw EvaluationException.createEvaluationException(String.format("failed to evaluate the default value expression of the parameter '%s' in function '%s'.", argName, this.functionName));
        }
    }

    private static boolean isPositionalArg(Map.Entry<String, Evaluator> arg) {
        return arg.getKey().isEmpty();
    }

    private static boolean isNamedArg(Map.Entry<String, Evaluator> arg) {
        return !arg.getKey().isEmpty() && !InvocationArgProcessor.isRestArg(arg);
    }

    private static boolean isRestArg(Map.Entry<String, Evaluator> arg) {
        return !arg.getKey().isEmpty() && arg.getKey().equals("...");
    }

    private static Value getDefaultValue(SuspendedContext context, LocalVariable localVariable, FunctionDefinitionNode functionDefinition) throws EvaluationException {
        String name = localVariable.name();
        Optional<ParameterNode> paramNode = functionDefinition.functionSignature().parameters().stream().filter(parameterNode -> NodeBasedArgProcessor.getParameterName(parameterNode).equals(name)).findFirst();
        Node expression = ((DefaultableParameterNode)paramNode.get()).expression();
        if (expression.kind().equals((Object)SyntaxKind.INFERRED_TYPEDESC_DEFAULT)) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.CANNOT_INFER_PARAM_TYPE, NodeBasedArgProcessor.getParameterName(paramNode.get()), functionDefinition.functionName().text());
        }
        DebugExpressionEvaluator defaultValueEvaluator = new DebugExpressionEvaluator(new EvaluationContext(context));
        defaultValueEvaluator.setExpression(expression.toSourceCode());
        return defaultValueEvaluator.evaluate().getJdiValue();
    }

    protected static enum ArgType {
        POSITIONAL,
        NAMED,
        REST,
        UNKNOWN;

    }
}

