/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine.expression;

import com.sun.jdi.Value;
import io.ballerina.compiler.syntax.tree.AnnotAccessExpressionNode;
import java.util.ArrayList;
import org.ballerinalang.debugadapter.EvaluationContext;
import org.ballerinalang.debugadapter.evaluation.BExpressionValue;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.engine.Evaluator;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.RuntimeStaticMethod;
import org.ballerinalang.debugadapter.evaluation.utils.EvaluationUtils;
import org.ballerinalang.debugadapter.variable.BVariableType;

public class AnnotationAccessExpressionEvaluator
extends Evaluator {
    private final AnnotAccessExpressionNode syntaxNode;
    private final Evaluator exprEvaluator;

    public AnnotationAccessExpressionEvaluator(EvaluationContext context, AnnotAccessExpressionNode syntaxNode, Evaluator exprEvaluator) {
        super(context);
        this.syntaxNode = syntaxNode;
        this.exprEvaluator = exprEvaluator;
    }

    @Override
    public BExpressionValue evaluate() throws EvaluationException {
        try {
            BExpressionValue result = this.exprEvaluator.evaluate();
            Value valueAsObject = EvaluationUtils.getValueAsObject(this.context, result.getJdiValue());
            if (result.getType() != BVariableType.TYPE_DESC && result.getType() != BVariableType.UNKNOWN) {
                throw EvaluationException.createEvaluationException(EvaluationExceptionKind.TYPE_MISMATCH, BVariableType.TYPE_DESC.getString(), result.getType().getString(), this.syntaxNode.toSourceCode());
            }
            ArrayList<String> argTypeNames = new ArrayList<String>();
            argTypeNames.add("java.lang.Object");
            argTypeNames.add("java.lang.String");
            RuntimeStaticMethod getAnnotationValueMethod = EvaluationUtils.getRuntimeMethod(this.context, "org.ballerinalang.debugadapter.runtime.DebuggerRuntime", "getAnnotationValue", argTypeNames);
            ArrayList<Value> argValues = new ArrayList<Value>();
            argValues.add(valueAsObject);
            argValues.add(EvaluationUtils.getAsJString(this.context, this.syntaxNode.annotTagReference().toSourceCode()));
            getAnnotationValueMethod.setArgValues(argValues);
            return new BExpressionValue(this.context, getAnnotationValueMethod.invokeSafely());
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.INTERNAL_ERROR, this.syntaxNode.toSourceCode().trim());
        }
    }
}

