/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine.expression;

import com.sun.jdi.Value;
import io.ballerina.compiler.syntax.tree.BinaryExpressionNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.ArrayList;
import org.ballerinalang.debugadapter.EvaluationContext;
import org.ballerinalang.debugadapter.evaluation.BExpressionValue;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.engine.Evaluator;
import org.ballerinalang.debugadapter.evaluation.engine.expression.BinaryExpressionEvaluator;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.GeneratedStaticMethod;
import org.ballerinalang.debugadapter.evaluation.utils.EvaluationUtils;
import org.ballerinalang.debugadapter.evaluation.utils.VMUtils;
import org.ballerinalang.debugadapter.variable.BVariable;
import org.ballerinalang.debugadapter.variable.VariableFactory;

public class RangeExpressionEvaluator
extends BinaryExpressionEvaluator {
    public RangeExpressionEvaluator(EvaluationContext context, BinaryExpressionNode node, Evaluator lhsEvaluator, Evaluator rhsEvaluator) {
        super(context, node, lhsEvaluator, rhsEvaluator);
    }

    @Override
    public BExpressionValue evaluate() throws EvaluationException {
        try {
            BExpressionValue lhsResult = this.lhsEvaluator.evaluate();
            BExpressionValue rhsResult = this.rhsEvaluator.evaluate();
            BVariable lVar = VariableFactory.getVariable(this.context, lhsResult.getJdiValue());
            BVariable rVar = VariableFactory.getVariable(this.context, rhsResult.getJdiValue());
            SyntaxKind operatorType = this.syntaxNode.operator().kind();
            boolean excludeEndValue = operatorType == SyntaxKind.DOUBLE_DOT_LT_TOKEN;
            Value excludeEndValueMirror = VMUtils.make(this.context, excludeEndValue).getJdiValue();
            ArrayList<Value> argList = new ArrayList<Value>();
            argList.add(EvaluationUtils.getValueAsObject(this.context, lVar));
            argList.add(EvaluationUtils.getValueAsObject(this.context, rVar));
            argList.add(EvaluationUtils.getValueAsObject(this.context, excludeEndValueMirror));
            GeneratedStaticMethod createIntRangeMethod = EvaluationUtils.getGeneratedMethod(this.context, "ballerina.debugger_helpers.1.range_operations", "createIntRange");
            createIntRangeMethod.setArgValues(argList);
            return new BExpressionValue(this.context, createIntRangeMethod.invokeSafely());
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.INTERNAL_ERROR, this.syntaxNode.toSourceCode().trim());
        }
    }
}

