/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine.invokable;

import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import org.ballerinalang.debugadapter.SuspendedContext;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.GeneratedMethod;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.RuntimeStaticMethod;
import org.ballerinalang.debugadapter.evaluation.utils.EvaluationUtils;

public class GeneratedInstanceMethod
extends GeneratedMethod {
    private final Value objectValueRef;

    public GeneratedInstanceMethod(SuspendedContext context, Value objectRef, Method methodRef) {
        super(context, methodRef);
        this.objectValueRef = objectRef;
    }

    @Override
    protected Value invoke() throws EvaluationException {
        try {
            if (!(this.objectValueRef instanceof ObjectReference)) {
                throw EvaluationException.createEvaluationException(EvaluationExceptionKind.FUNCTION_EXECUTION_ERROR, this.methodRef.name());
            }
            ArrayList<String> argTypeList = new ArrayList<String>();
            argTypeList.add("io.ballerina.runtime.api.values.BObject");
            argTypeList.add("java.lang.String");
            argTypeList.add("java.lang.Object[]");
            RuntimeStaticMethod scheduleMethod = EvaluationUtils.getRuntimeMethod(this.context, "org.ballerinalang.debugadapter.runtime.DebuggerRuntime", "invokeObjectMethod", argTypeList);
            ArrayList<Value> scheduleMethodArgs = new ArrayList<Value>();
            scheduleMethodArgs.add(this.objectValueRef);
            scheduleMethodArgs.add(EvaluationUtils.getAsJString(this.context, this.methodRef.name()));
            scheduleMethodArgs.addAll(this.getMethodArgs(this));
            scheduleMethod.setArgValues(scheduleMethodArgs);
            return scheduleMethod.invoke();
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            return this.extractBErrors(e);
        }
    }
}

