/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine.invokable;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.List;
import org.ballerinalang.debugadapter.SuspendedContext;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.RuntimeMethod;

public class RuntimeInstanceMethod
extends RuntimeMethod {
    private final Value objectValueRef;

    public RuntimeInstanceMethod(SuspendedContext context, Value objectRef, Method methodRef) {
        super(context, methodRef);
        this.objectValueRef = objectRef;
    }

    @Override
    protected synchronized Value invoke() throws EvaluationException {
        try {
            Value value = this.objectValueRef;
            if (!(value instanceof ObjectReference)) {
                throw EvaluationException.createEvaluationException(EvaluationExceptionKind.FUNCTION_EXECUTION_ERROR, this.methodRef.name());
            }
            ObjectReference objectReference = (ObjectReference)value;
            List<Value> argValueList = this.getMethodArgs(this);
            return objectReference.invokeMethod(this.context.getOwningThread().getThreadReference(), this.methodRef, argValueList, 0);
        }
        catch (ClassNotLoadedException e) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.FUNCTION_NOT_FOUND, this.methodRef.name());
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            return this.extractBErrors(e);
        }
    }
}

