/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.utils;

import com.sun.jdi.BooleanValue;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.identifier.Utils;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.IntStream;
import org.ballerinalang.debugadapter.EvaluationContext;
import org.ballerinalang.debugadapter.SuspendedContext;
import org.ballerinalang.debugadapter.evaluation.BExpressionValue;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.IdentifierModifier;
import org.ballerinalang.debugadapter.evaluation.engine.NameBasedTypeResolver;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.GeneratedStaticMethod;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.RuntimeInstanceMethod;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.RuntimeStaticMethod;
import org.ballerinalang.debugadapter.evaluation.utils.VariableUtils;
import org.ballerinalang.debugadapter.jdi.JdiProxyException;
import org.ballerinalang.debugadapter.jdi.LocalVariableProxyImpl;
import org.ballerinalang.debugadapter.utils.PackageUtils;
import org.ballerinalang.debugadapter.variable.BVariable;
import org.ballerinalang.debugadapter.variable.BVariableType;
import org.ballerinalang.debugadapter.variable.DebugVariableException;
import org.ballerinalang.debugadapter.variable.IndexedCompoundVariable;
import org.ballerinalang.debugadapter.variable.JVMValueType;
import org.ballerinalang.debugadapter.variable.VariableFactory;

public final class EvaluationUtils {
    private static final String DEBUGGER_HELPER_PREFIX = "ballerina.debugger_helpers.1.";
    public static final String B_UNARY_EXPR_HELPER_CLASS = "ballerina.debugger_helpers.1.unary_operations";
    public static final String B_ARITHMETIC_EXPR_HELPER_CLASS = "ballerina.debugger_helpers.1.arithmetic_operations";
    public static final String B_RELATIONAL_EXPR_HELPER_CLASS = "ballerina.debugger_helpers.1.relational_operations";
    public static final String B_BITWISE_EXPR_HELPER_CLASS = "ballerina.debugger_helpers.1.bitwise_operations";
    public static final String B_SHIFT_EXPR_HELPER_CLASS = "ballerina.debugger_helpers.1.shift_operations";
    public static final String B_LOGICAL_EXPR_HELPER_CLASS = "ballerina.debugger_helpers.1.logical_operations";
    public static final String B_RANGE_EXPR_HELPER_CLASS = "ballerina.debugger_helpers.1.range_operations";
    public static final String B_UTILS_HELPER_CLASS = "ballerina.debugger_helpers.1.utils";
    public static final String B_DEBUGGER_RUNTIME_CLASS = "org.ballerinalang.debugadapter.runtime.DebuggerRuntime";
    public static final String B_DEBUGGER_RUNTIME_UTILS_CLASS = "org.ballerinalang.debugadapter.runtime.VariableUtils";
    private static final String RUNTIME_HELPER_PREFIX = "io.ballerina.runtime.";
    public static final String B_TYPE_CHECKER_CLASS = "io.ballerina.runtime.internal.TypeChecker";
    public static final String B_TYPE_CREATOR_CLASS = "io.ballerina.runtime.api.creators.TypeCreator";
    public static final String B_TYPE_CONVERTER_CLASS = "io.ballerina.runtime.internal.TypeConverter";
    public static final String B_VALUE_CREATOR_CLASS = "io.ballerina.runtime.api.creators.ValueCreator";
    public static final String B_STRING_UTILS_CLASS = "io.ballerina.runtime.api.utils.StringUtils";
    public static final String B_TYPE_UTILS_CLASS = "io.ballerina.runtime.api.utils.TypeUtils";
    public static final String B_XML_FACTORY_CLASS = "io.ballerina.runtime.internal.xml.XmlFactory";
    public static final String B_DECIMAL_VALUE_CLASS = "io.ballerina.runtime.internal.values.DecimalValue";
    public static final String B_XML_CLASS = "io.ballerina.runtime.api.values.BXml";
    public static final String B_XML_VALUE_CLASS = "io.ballerina.runtime.internal.values.XmlValue";
    public static final String B_XML_SEQUENCE_CLASS = "io.ballerina.runtime.api.values.BXmlSequence";
    public static final String B_STRING_CLASS = "io.ballerina.runtime.api.values.BString";
    public static final String B_STRING_ARRAY_CLASS = "io.ballerina.runtime.api.values.BString[]";
    public static final String B_OBJECT_CLASS = "io.ballerina.runtime.api.values.BObject";
    public static final String B_TYPE_CLASS = "io.ballerina.runtime.api.types.Type";
    public static final String B_VALUE_ARRAY_CLASS = "io.ballerina.runtime.api.values.BValue[]";
    public static final String B_TYPE_ARRAY_CLASS = "io.ballerina.runtime.api.types.Type[]";
    public static final String B_SCHEDULER_CLASS = "io.ballerina.runtime.internal.scheduling.Scheduler";
    public static final String B_STRAND_CLASS = "io.ballerina.runtime.internal.scheduling.Strand";
    private static final String B_LINK_CLASS = "io.ballerina.runtime.api.values.BLink";
    private static final String B_ERROR_VALUE_CLASS = "io.ballerina.runtime.internal.values.ErrorValue";
    public static final String JAVA_OBJECT_CLASS = "java.lang.Object";
    public static final String JAVA_LANG_CLASSLOADER = "java.lang.ClassLoader";
    public static final String JAVA_OBJECT_ARRAY_CLASS = "java.lang.Object[]";
    public static final String JAVA_STRING_CLASS = "java.lang.String";
    public static final String JAVA_LONG_CLASS = "java.lang.Long";
    private static final String JAVA_BOOLEAN_CLASS = "java.lang.Boolean";
    private static final String JAVA_INT_CLASS = "java.lang.Integer";
    private static final String JAVA_FLOAT_CLASS = "java.lang.Float";
    private static final String JAVA_DOUBLE_CLASS = "java.lang.Double";
    private static final String JAVA_LANG_CLASS = "java.lang.Class";
    public static final String B_ADD_METHOD = "add";
    public static final String B_SUB_METHOD = "subtract";
    public static final String B_MUL_METHOD = "multiply";
    public static final String B_DIV_METHOD = "divide";
    public static final String B_MOD_METHOD = "modulus";
    public static final String B_LT_METHOD = "lessThan";
    public static final String B_LT_EQUALS_METHOD = "lessThanOrEquals";
    public static final String B_GT_METHOD = "greaterThan";
    public static final String B_GT_EQUALS_METHOD = "greaterThanOrEquals";
    public static final String B_BITWISE_AND_METHOD = "bitwiseAND";
    public static final String B_BITWISE_OR_METHOD = "bitwiseOR";
    public static final String B_BITWISE_XOR_METHOD = "bitwiseXOR";
    public static final String B_LEFT_SHIFT_METHOD = "leftShift";
    public static final String B_SIGNED_RIGHT_SHIFT_METHOD = "signedRightShift";
    public static final String B_UNSIGNED_RIGHT_SHIFT_METHOD = "unsignedRightShift";
    public static final String B_LOGICAL_AND_METHOD = "logicalAND";
    public static final String B_LOGICAL_OR_METHOD = "logicalOR";
    public static final String B_UNARY_PLUS_METHOD = "unaryPlus";
    public static final String B_UNARY_MINUS_METHOD = "unaryMinus";
    public static final String B_UNARY_INVERT_METHOD = "unaryInvert";
    public static final String B_UNARY_NOT_METHOD = "unaryNot";
    public static final String B_GET_TRAP_RESULT_METHOD = "getTrapResult";
    public static final String GET_ANNOT_VALUE_METHOD = "getAnnotationValue";
    public static final String GET_TYPEDESC_METHOD = "getTypedesc";
    public static final String CHECK_IS_TYPE_METHOD = "checkIsType";
    public static final String CHECK_CAST_METHOD = "checkCast";
    public static final String CREATE_UNION_TYPE_METHOD = "createUnionType";
    public static final String CREATE_ARRAY_TYPE_METHOD = "createArrayType";
    public static final String CREATE_DECIMAL_VALUE_METHOD = "createDecimalValue";
    public static final String CREATE_XML_ITEM = "createXmlItem";
    public static final String CREATE_XML_VALUE_METHOD = "createXmlValue";
    public static final String CREATE_OBJECT_VALUE_METHOD = "createObjectValue";
    public static final String CREATE_ERROR_VALUE_METHOD = "createErrorValue";
    public static final String CREATE_TYPEDESC_VALUE_METHOD = "createTypedescValue";
    public static final String VALUE_OF_METHOD = "valueOf";
    public static final String VALUE_FROM_STRING_METHOD = "fromString";
    public static final String REF_EQUAL_METHOD = "isReferenceEqual";
    public static final String VALUE_EQUAL_METHOD = "isEqual";
    public static final String XML_CONCAT_METHOD = "concatenate";
    public static final String STRING_TO_XML_METHOD = "stringToXml";
    public static final String INVOKE_OBJECT_METHOD_ASYNC = "invokeObjectMethod";
    public static final String INVOKE_FUNCTION_ASYNC = "invokeFunction";
    public static final String CLASSLOAD_AND_INVOKE_METHOD = "classloadAndInvokeFunction";
    public static final String CREATE_INT_RANGE_METHOD = "createIntRange";
    public static final String GET_REST_ARG_ARRAY_METHOD = "getRestArgArray";
    public static final String GET_XML_FILTER_RESULT_METHOD = "getXMLFilterResult";
    public static final String GET_XML_STEP_RESULT_METHOD = "getXMLStepResult";
    public static final String GET_BMAP_TYPE_METHOD = "getBMapType";
    public static final String GET_STRING_AT_METHOD = "getStringAt";
    static final String FROM_STRING_METHOD = "fromString";
    private static final String B_STRING_CONCAT_METHOD = "concat";
    private static final String FOR_NAME_METHOD = "forName";
    private static final String GET_STRING_VALUE_METHOD = "getStringValue";
    private static final String INT_VALUE_METHOD = "intValue";
    private static final String LONG_VALUE_METHOD = "longValue";
    private static final String FLOAT_VALUE_METHOD = "floatValue";
    private static final String DOUBLE_VALUE_METHOD = "doubleValue";
    public static final String SELF_VAR_NAME = "self";
    public static final String STRAND_VAR_NAME = "__strand";
    public static final String REST_ARG_IDENTIFIER = "...";
    public static final String MODULE_NAME_SEPARATOR = ".";
    public static final String MODULE_VERSION_SEPARATOR_REGEX = "\\.";
    public static final String MODULE_NAME_SEPARATOR_REGEX = "\\.";

    private EvaluationUtils() {
    }

    public static RuntimeStaticMethod getRuntimeMethod(SuspendedContext context, String qClassName, String methodName, List<String> argTypeNames) throws EvaluationException {
        List<Method> methods;
        List<ReferenceType> classesRef = context.getAttachedVm().classesByName(qClassName);
        if (classesRef == null || classesRef.isEmpty()) {
            classesRef = Collections.singletonList(EvaluationUtils.loadClass(context, qClassName, methodName));
        }
        if ((methods = classesRef.get(0).methodsByName(methodName)) == null || methods.isEmpty()) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.HELPER_UTIL_NOT_FOUND, methodName);
        }
        if ((methods = methods.stream().filter(method -> method.isPublic() && method.isStatic() && EvaluationUtils.compare(method.argumentTypeNames(), argTypeNames)).toList()).size() != 1) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.HELPER_UTIL_NOT_FOUND, methodName);
        }
        return new RuntimeStaticMethod(context, classesRef.get(0), methods.get(0));
    }

    public static GeneratedStaticMethod getGeneratedMethod(SuspendedContext context, String qClassName, String methodName) throws EvaluationException {
        List<Method> methods;
        List<ReferenceType> classesRef = context.getAttachedVm().classesByName(qClassName);
        if (classesRef == null || classesRef.isEmpty()) {
            classesRef = Collections.singletonList(EvaluationUtils.loadClass(context, qClassName, methodName));
        }
        if ((methods = classesRef.get(0).methodsByName(methodName)) == null || methods.isEmpty()) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.HELPER_UTIL_NOT_FOUND, methodName);
        }
        if ((methods = methods.stream().filter(method -> method.isPublic() && method.isStatic()).toList()).size() != 1) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.HELPER_UTIL_NOT_FOUND, methodName);
        }
        return new GeneratedStaticMethod(context, classesRef.get(0), methods.get(0));
    }

    public static ReferenceType loadClass(SuspendedContext evaluationContext, String qName, String methodName) throws EvaluationException {
        try {
            ClassType classType = (ClassType)evaluationContext.getAttachedVm().classesByName(JAVA_LANG_CLASS).get(0);
            if (classType == null) {
                throw EvaluationException.createEvaluationException(EvaluationExceptionKind.CLASS_LOADING_FAILED, methodName);
            }
            Method forNameMethod = null;
            List<Method> methods = classType.methodsByName(FOR_NAME_METHOD);
            for (Method method : methods) {
                List<String> argumentTypeNames = method.argumentTypeNames();
                if (argumentTypeNames.size() != 3 || !argumentTypeNames.getFirst().equals(JAVA_STRING_CLASS)) continue;
                forNameMethod = method;
                break;
            }
            if (forNameMethod == null) {
                throw EvaluationException.createEvaluationException(EvaluationExceptionKind.CLASS_LOADING_FAILED, methodName);
            }
            ArrayList<Value> args = new ArrayList<Value>();
            args.add(evaluationContext.getAttachedVm().mirrorOf(qName));
            args.add(evaluationContext.getAttachedVm().mirrorOf(true));
            args.add(evaluationContext.getDebuggeeClassLoader());
            Value classReference = classType.invokeMethod(evaluationContext.getOwningThread().getThreadReference(), forNameMethod, args, 1);
            return ((ClassObjectReference)classReference).reflectedType();
        }
        catch (Exception e) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.CLASS_LOADING_FAILED, methodName);
        }
    }

    public static List<Value> getAsObjects(SuspendedContext context, List<Value> argValueList) throws EvaluationException {
        ArrayList<Value> boxedValues = new ArrayList<Value>();
        for (Value value : argValueList) {
            boxedValues.add(EvaluationUtils.getValueAsObject(context, value));
        }
        return boxedValues;
    }

    public static Value getValueAsObject(SuspendedContext context, Value value) throws EvaluationException {
        BVariable bVar = VariableFactory.getVariable(context, value);
        if (value instanceof ObjectReference) {
            return value;
        }
        return EvaluationUtils.getValueAsObject(context, bVar);
    }

    public static Value unboxValue(SuspendedContext context, Value value) {
        try {
            List<Method> method;
            String typeName;
            if (!(value instanceof ObjectReference)) {
                return value;
            }
            ObjectReference objRef = (ObjectReference)value;
            switch (typeName = value.type().name()) {
                case "java.lang.Integer": {
                    method = objRef.referenceType().methodsByName(INT_VALUE_METHOD);
                    break;
                }
                case "java.lang.Long": {
                    method = objRef.referenceType().methodsByName(LONG_VALUE_METHOD);
                    break;
                }
                case "java.lang.Float": {
                    method = objRef.referenceType().methodsByName(FLOAT_VALUE_METHOD);
                    break;
                }
                case "java.lang.Double": {
                    method = objRef.referenceType().methodsByName(DOUBLE_VALUE_METHOD);
                    break;
                }
                default: {
                    return value;
                }
            }
            if (method.size() != 1) {
                return value;
            }
            RuntimeInstanceMethod unboxingMethod = new RuntimeInstanceMethod(context, value, method.get(0));
            unboxingMethod.setArgValues(new ArrayList<Value>());
            return unboxingMethod.invokeSafely();
        }
        catch (EvaluationException e) {
            return value;
        }
    }

    public static Value getValueAsObject(SuspendedContext context, BVariable variable) throws EvaluationException {
        ArrayList<String> methodArgTypeNames = new ArrayList<String>();
        Value jvmValue = variable.getJvmValue();
        switch (variable.getBType()) {
            case BOOLEAN: {
                if (jvmValue instanceof BooleanValue) {
                    methodArgTypeNames.add(JVMValueType.BOOLEAN.getString());
                    RuntimeStaticMethod method = EvaluationUtils.getRuntimeMethod(context, JAVA_BOOLEAN_CLASS, VALUE_OF_METHOD, methodArgTypeNames);
                    method.setArgValues(Collections.singletonList(jvmValue));
                    return method.invokeSafely();
                }
                return jvmValue;
            }
            case INT: {
                if (jvmValue instanceof IntegerValue) {
                    methodArgTypeNames.add(JVMValueType.INT.getString());
                    RuntimeStaticMethod method = EvaluationUtils.getRuntimeMethod(context, JAVA_INT_CLASS, VALUE_OF_METHOD, methodArgTypeNames);
                    method.setArgValues(Collections.singletonList(jvmValue));
                    return method.invokeSafely();
                }
                if (jvmValue instanceof LongValue) {
                    methodArgTypeNames.add(JVMValueType.LONG.getString());
                    RuntimeStaticMethod method = EvaluationUtils.getRuntimeMethod(context, JAVA_LONG_CLASS, VALUE_OF_METHOD, methodArgTypeNames);
                    method.setArgValues(Collections.singletonList(jvmValue));
                    return method.invokeSafely();
                }
                return jvmValue;
            }
            case FLOAT: {
                jvmValue = variable.getJvmValue();
                if (jvmValue instanceof FloatValue) {
                    methodArgTypeNames.add(JVMValueType.FLOAT.getString());
                    RuntimeStaticMethod method = EvaluationUtils.getRuntimeMethod(context, JAVA_FLOAT_CLASS, VALUE_OF_METHOD, methodArgTypeNames);
                    method.setArgValues(Collections.singletonList(variable.getJvmValue()));
                    return method.invokeSafely();
                }
                if (jvmValue instanceof DoubleValue) {
                    methodArgTypeNames.add(JVMValueType.DOUBLE.getString());
                    RuntimeStaticMethod method = EvaluationUtils.getRuntimeMethod(context, JAVA_DOUBLE_CLASS, VALUE_OF_METHOD, methodArgTypeNames);
                    method.setArgValues(Collections.singletonList(variable.getJvmValue()));
                    return method.invokeSafely();
                }
                return jvmValue;
            }
        }
        return variable.getJvmValue();
    }

    public static boolean checkIsType(SuspendedContext context, Value sourceVal, Value targetType) throws EvaluationException {
        ArrayList<String> methodArgTypeNames = new ArrayList<String>();
        methodArgTypeNames.add(JAVA_OBJECT_CLASS);
        methodArgTypeNames.add(B_TYPE_CLASS);
        RuntimeStaticMethod method = EvaluationUtils.getRuntimeMethod(context, B_TYPE_CHECKER_CLASS, CHECK_IS_TYPE_METHOD, methodArgTypeNames);
        ArrayList<Value> methodArgs = new ArrayList<Value>();
        methodArgs.add(EvaluationUtils.getValueAsObject(context, sourceVal));
        methodArgs.add(targetType);
        method.setArgValues(methodArgs);
        return Boolean.parseBoolean(new BExpressionValue(context, method.invokeSafely()).getStringValue());
    }

    public static Value concatBStrings(SuspendedContext context, Value ... bStrings) throws EvaluationException {
        Value result = bStrings[0];
        List<Method> method = ((ObjectReference)result).referenceType().methodsByName(B_STRING_CONCAT_METHOD);
        for (int i = 1; i < bStrings.length; ++i) {
            if (method.size() != 1) {
                throw EvaluationException.createEvaluationException("Error occurred when trying to load required methods to execute BString concatenation");
            }
            RuntimeInstanceMethod concatMethod = new RuntimeInstanceMethod(context, result, method.get(0));
            concatMethod.setArgValues(Collections.singletonList(bStrings[i]));
            result = concatMethod.invokeSafely();
            method = ((ObjectReference)result).referenceType().methodsByName(B_STRING_CONCAT_METHOD);
        }
        return result;
    }

    public static Value getStringValue(SuspendedContext context, Value value) throws EvaluationException {
        ArrayList<String> argTypeNames = new ArrayList<String>();
        argTypeNames.add(JAVA_OBJECT_CLASS);
        argTypeNames.add(B_LINK_CLASS);
        RuntimeStaticMethod runtimeMethod = EvaluationUtils.getRuntimeMethod(context, B_STRING_UTILS_CLASS, GET_STRING_VALUE_METHOD, argTypeNames);
        ArrayList<Value> args = new ArrayList<Value>();
        args.add(EvaluationUtils.getValueAsObject(context, value));
        args.add(null);
        runtimeMethod.setArgValues(args);
        return runtimeMethod.invokeSafely();
    }

    public static Value getAsBString(SuspendedContext context, String val) throws EvaluationException {
        return EvaluationUtils.getAsBString(context, context.getAttachedVm().mirrorOf(val));
    }

    public static Value getAsBString(SuspendedContext context, StringReference stringRef) throws EvaluationException {
        List<String> argTypeNames = Collections.singletonList(JAVA_STRING_CLASS);
        RuntimeStaticMethod fromStringMethod = EvaluationUtils.getRuntimeMethod(context, B_STRING_UTILS_CLASS, "fromString", argTypeNames);
        fromStringMethod.setArgValues(Collections.singletonList(stringRef));
        return fromStringMethod.invokeSafely();
    }

    public static String constructQualifiedClassName(Symbol symbol) {
        String className = ((Location)symbol.getLocation().orElseThrow()).lineRange().fileName().replaceAll(".bal$", "");
        if (symbol.getModule().isEmpty()) {
            return className;
        }
        ModuleID moduleMeta = ((ModuleSymbol)symbol.getModule().get()).id();
        if (moduleMeta.packageName().equals(MODULE_NAME_SEPARATOR)) {
            return className;
        }
        return new StringJoiner(MODULE_NAME_SEPARATOR).add(IdentifierModifier.encodeModuleName(moduleMeta.orgName())).add(IdentifierModifier.encodeModuleName(moduleMeta.moduleName())).add(moduleMeta.version().split("\\.")[0]).add(className).toString();
    }

    public static Value getAsJString(SuspendedContext context, String val) {
        return context.getAttachedVm().mirrorOf(val);
    }

    public static Optional<Value> getBError(Exception e) {
        if (!(e instanceof InvocationException)) {
            return Optional.empty();
        }
        InvocationException e1 = (InvocationException)e;
        String typeName = e1.exception().referenceType().name();
        if (typeName.equals(B_ERROR_VALUE_CLASS)) {
            return Optional.ofNullable(e1.exception());
        }
        return Optional.empty();
    }

    private static boolean compare(List<String> list1, List<String> list2) {
        return list1.size() == list2.size() && IntStream.range(0, list1.size()).allMatch(i -> ((String)list1.get(i)).equals(list2.get(i)));
    }

    public static String modifyName(String identifier) {
        return Utils.decodeIdentifier((String)IdentifierModifier.encodeIdentifier(identifier, IdentifierModifier.IdentifierType.OTHER));
    }

    public static Value fetchNameReferenceValue(EvaluationContext context, String name) throws EvaluationException {
        Optional<BExpressionValue> variableReferenceValue = EvaluationUtils.fetchVariableReferenceValue(context, name);
        if (variableReferenceValue.isPresent()) {
            return variableReferenceValue.get().getJdiValue();
        }
        NameBasedTypeResolver typeResolver = new NameBasedTypeResolver(context);
        try {
            List<Value> resolvedTypes = typeResolver.resolve(name);
            if (resolvedTypes.size() != 1) {
                throw EvaluationException.createEvaluationException(EvaluationExceptionKind.NAME_REF_RESOLVING_ERROR, name);
            }
            Value type = resolvedTypes.get(0);
            LinkedList<String> argTypeNames = new LinkedList<String>();
            argTypeNames.add(B_TYPE_CLASS);
            RuntimeStaticMethod createTypeDescMethod = EvaluationUtils.getRuntimeMethod(context.getSuspendedContext(), B_VALUE_CREATOR_CLASS, CREATE_TYPEDESC_VALUE_METHOD, argTypeNames);
            LinkedList<Value> argValues = new LinkedList<Value>();
            argValues.add(type);
            createTypeDescMethod.setArgValues(argValues);
            return createTypeDescMethod.invokeSafely();
        }
        catch (EvaluationException e) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.NAME_REF_RESOLVING_ERROR, name);
        }
    }

    public static Optional<BExpressionValue> fetchVariableReferenceValue(EvaluationContext context, String name) {
        Optional<BExpressionValue> bExpressionValue = EvaluationUtils.searchLocalVariables(context.getSuspendedContext(), name);
        if (bExpressionValue.isPresent()) {
            return bExpressionValue;
        }
        bExpressionValue = EvaluationUtils.searchGlobalVariables(context.getSuspendedContext(), name);
        return bExpressionValue;
    }

    private static Optional<BExpressionValue> searchLocalVariables(SuspendedContext context, String nameReference) {
        try {
            LocalVariableProxyImpl jvmVar = context.getFrame().visibleVariableByName(nameReference);
            if (jvmVar != null) {
                return Optional.of(new BExpressionValue(context, context.getFrame().getValue(jvmVar)));
            }
            List<LocalVariableProxyImpl> lambdaParamMaps = context.getFrame().visibleVariables().stream().filter(org.ballerinalang.debugadapter.variable.VariableUtils::isLambdaParamMap).toList();
            Optional<Value> localVariableMatch = lambdaParamMaps.stream().map(localVariableProxy -> {
                try {
                    Value varValue = context.getFrame().getValue((LocalVariableProxyImpl)localVariableProxy);
                    BVariable mapVar = VariableFactory.getVariable(context, varValue);
                    if (mapVar == null || mapVar.getBType() != BVariableType.MAP || !(mapVar instanceof IndexedCompoundVariable)) {
                        return null;
                    }
                    IndexedCompoundVariable indexedCompoundVariable = (IndexedCompoundVariable)mapVar;
                    return indexedCompoundVariable.getChildByName(nameReference);
                }
                catch (JdiProxyException | DebugVariableException e) {
                    return null;
                }
            }).filter(Objects::nonNull).findAny();
            if (localVariableMatch.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new BExpressionValue(context, localVariableMatch.get()));
        }
        catch (JdiProxyException e) {
            return Optional.empty();
        }
    }

    private static Optional<BExpressionValue> searchGlobalVariables(SuspendedContext context, String nameReference) {
        return EvaluationUtils.getFieldValue(context, nameReference);
    }

    private static Optional<BExpressionValue> getFieldValue(SuspendedContext context, String fieldName) {
        String varClassName = PackageUtils.getQualifiedClassName(context, fieldName, "identifiers.global_vars");
        ReferenceType classesRef = VariableUtils.loadClassRef(context, varClassName);
        if (classesRef == null) {
            varClassName = PackageUtils.getQualifiedClassName(context, fieldName, "identifiers.constants");
            classesRef = VariableUtils.loadClassRef(context, varClassName);
        }
        if (classesRef != null) {
            Field field = classesRef.fieldByName("v");
            return Optional.of(new BExpressionValue(context, classesRef.getValue(field)));
        }
        return Optional.empty();
    }
}

