/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.utils;

import com.sun.jdi.Field;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import org.ballerinalang.debugadapter.SuspendedContext;
import org.ballerinalang.debugadapter.evaluation.BExpressionValue;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.IdentifierModifier;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.RuntimeStaticMethod;
import org.ballerinalang.debugadapter.evaluation.utils.EvaluationUtils;

public final class VariableUtils {
    public static Optional<BExpressionValue> getModuleVariable(SuspendedContext context, ModuleSymbol moduleSymbol, String nameReference) {
        return VariableUtils.getFieldValue(context, moduleSymbol, nameReference);
    }

    public static String getMapType(SuspendedContext context, Value mapValue) {
        try {
            RuntimeStaticMethod getBMapType = EvaluationUtils.getRuntimeMethod(context, "org.ballerinalang.debugadapter.runtime.VariableUtils", "getBMapType", Collections.singletonList("java.lang.Object"));
            getBMapType.setArgValues(Collections.singletonList(mapValue));
            Value value = getBMapType.invokeSafely();
            return org.ballerinalang.debugadapter.variable.VariableUtils.getStringFrom(value);
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    public static ReferenceType loadClassRef(SuspendedContext context, String className) {
        List<ReferenceType> classRefs = context.getAttachedVm().classesByName(className);
        if (classRefs != null && !classRefs.isEmpty()) {
            classRefs.getFirst();
        }
        try {
            classRefs = Collections.singletonList(EvaluationUtils.loadClass(context, className, ""));
            return classRefs.getFirst();
        }
        catch (EvaluationException e) {
            return null;
        }
    }

    private static String getVariableClassName(ModuleSymbol moduleSymbol, String varName, String ... packageNames) {
        StringJoiner classNameJoiner = new StringJoiner(".");
        classNameJoiner.add(moduleSymbol.id().orgName()).add(IdentifierModifier.encodeModuleName(moduleSymbol.id().moduleName())).add(moduleSymbol.id().version().split("\\.")[0]);
        for (String packageName : packageNames) {
            classNameJoiner.add(packageName);
        }
        classNameJoiner.add(varName);
        return classNameJoiner.toString();
    }

    private static Optional<BExpressionValue> getFieldValue(SuspendedContext context, ModuleSymbol moduleSymbol, String fieldName) {
        String globalVarClassName = VariableUtils.getVariableClassName(moduleSymbol, fieldName, "identifiers.global_vars");
        ReferenceType classRef = VariableUtils.loadClassRef(context, globalVarClassName);
        if (classRef == null) {
            String constantClassName = VariableUtils.getVariableClassName(moduleSymbol, fieldName, "identifiers.constants");
            classRef = VariableUtils.loadClassRef(context, constantClassName);
        }
        if (classRef == null) {
            return Optional.empty();
        }
        Field field = classRef.fieldByName("v");
        if (field == null) {
            return Optional.empty();
        }
        return Optional.of(new BExpressionValue(context, classRef.getValue(field)));
    }

    private VariableUtils() {
    }
}

