/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.validator.impl;

import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import org.ballerinalang.debugadapter.evaluation.parser.StatementParser;
import org.ballerinalang.debugadapter.evaluation.validator.Validator;
import org.ballerinalang.debugadapter.evaluation.validator.ValidatorException;

public class StatementValidator
extends Validator {
    public StatementValidator() {
        this(new StatementParser());
    }

    public StatementValidator(StatementParser parser) {
        super(parser);
    }

    @Override
    public void validate(String source) throws Exception {
        SyntaxTree syntaxTree = this.debugParser.getSyntaxTreeFor(source);
        NodeList<StatementNode> statements = StatementValidator.getStatementsFrom(syntaxTree);
        StatementValidator.failIf(statements.isEmpty(), "Empty expressions cannot be evaluated.");
        StatementValidator.failIf(statements.size() > 1, "Statement evaluation is not supported.");
        StatementNode statement = (StatementNode)statements.get(0);
        StatementValidator.failIf(statement.kind() != SyntaxKind.INVALID_EXPRESSION_STATEMENT && !statement.hasDiagnostics(), "Statement evaluation is not supported.");
    }

    protected static NodeList<StatementNode> getStatementsFrom(SyntaxTree syntaxTree) throws ValidatorException {
        ModulePartNode moduleNode = (ModulePartNode)syntaxTree.rootNode();
        ModuleMemberDeclarationNode function = (ModuleMemberDeclarationNode)moduleNode.members().get(0);
        StatementValidator.failIf(function.kind() != SyntaxKind.FUNCTION_DEFINITION, "Top-level declaration evaluation is not supported.");
        String name = ((FunctionDefinitionNode)function).functionName().toSourceCode().trim();
        StatementValidator.failIf(!name.equals("wrapper_function"), "Top-level declaration evaluation is not supported.");
        FunctionBodyNode functionBody = ((FunctionDefinitionNode)function).functionBody();
        return ((FunctionBodyBlockNode)functionBody).statements();
    }
}

