/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.jdi;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.ballerinalang.debugadapter.jdi.JdiProxyException;
import org.ballerinalang.debugadapter.jdi.ObjectReferenceProxyImpl;
import org.ballerinalang.debugadapter.jdi.StackFrameProxyImpl;
import org.ballerinalang.debugadapter.jdi.ThreadGroupReferenceProxyImpl;
import org.ballerinalang.debugadapter.jdi.ThreadReferenceProxy;
import org.ballerinalang.debugadapter.jdi.ThreeState;
import org.ballerinalang.debugadapter.jdi.VirtualMachineProxyImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadReferenceProxyImpl
extends ObjectReferenceProxyImpl
implements ThreadReferenceProxy {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadReferenceProxyImpl.class);
    private String myName;
    private int myFrameCount = -1;
    private final LinkedList<StackFrameProxyImpl> myFramesFromBottom = new LinkedList();
    private List<StackFrameProxyImpl> myFrames = null;
    private ThreadGroupReferenceProxyImpl myThreadGroupProxy;
    private ThreeState myResumeOnHotSwap = ThreeState.UNSURE;
    public static final Comparator<ThreadReferenceProxyImpl> COMPARATOR = (th1, th2) -> {
        int res = Boolean.compare(th2.isSuspended(), th1.isSuspended());
        if (res == 0) {
            return th1.name().compareToIgnoreCase(th2.name());
        }
        return res;
    };

    public ThreadReferenceProxyImpl(VirtualMachineProxyImpl virtualMachineProxy, ThreadReference threadReference) {
        super(virtualMachineProxy, threadReference);
    }

    @Override
    public ThreadReference getThreadReference() {
        return (ThreadReference)this.getObjectReference();
    }

    @Override
    public VirtualMachineProxyImpl getVirtualMachine() {
        return (VirtualMachineProxyImpl)this.myTimer;
    }

    public String name() {
        this.checkValid();
        if (this.myName == null) {
            try {
                this.myName = this.getThreadReference().name();
            }
            catch (ObjectCollectedException ignored) {
                this.myName = "";
            }
            catch (IllegalThreadStateException ignored) {
                this.myName = "zombie";
            }
        }
        return this.myName;
    }

    public int getSuspendCount() {
        try {
            return this.getThreadReference().suspendCount();
        }
        catch (ObjectCollectedException ignored) {
            return 0;
        }
    }

    public void suspend() {
        try {
            this.getThreadReference().suspend();
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
        this.clearCaches();
    }

    public void resume() {
        ThreadReference threadRef = this.getThreadReference();
        if (LOG.isDebugEnabled()) {
            LOG.debug("before resume" + String.valueOf(threadRef));
        }
        this.getVirtualMachineProxy().clearCaches();
        try {
            threadRef.resume();
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
    }

    @Override
    protected void clearCaches() {
        this.myName = null;
        this.myFrames = null;
        this.myFrameCount = -1;
        super.clearCaches();
    }

    public int status() {
        try {
            return this.getThreadReference().status();
        }
        catch (ObjectCollectedException | IllegalThreadStateException e) {
            return 0;
        }
    }

    public ThreadGroupReferenceProxyImpl threadGroupProxy() {
        this.checkValid();
        if (this.myThreadGroupProxy == null) {
            ThreadGroupReference threadGroupRef;
            try {
                threadGroupRef = this.getThreadReference().threadGroup();
            }
            catch (ObjectCollectedException ignored) {
                threadGroupRef = null;
            }
            this.myThreadGroupProxy = this.getVirtualMachineProxy().getThreadGroupReferenceProxy(threadGroupRef);
        }
        return this.myThreadGroupProxy;
    }

    @Override
    public int frameCount() throws JdiProxyException {
        this.checkValid();
        if (this.myFrameCount == -1) {
            ThreadReference threadReference = this.getThreadReference();
            try {
                this.myFrameCount = threadReference.frameCount();
            }
            catch (ObjectCollectedException ignored) {
                this.myFrameCount = 0;
            }
            catch (IncompatibleThreadStateException e) {
                boolean isSuspended;
                try {
                    isSuspended = threadReference.isSuspended();
                }
                catch (Throwable ignored) {
                    throw new JdiProxyException(e.getMessage(), e);
                }
                if (!isSuspended) {
                    throw new JdiProxyException(e.getMessage(), e);
                }
                this.myFrameCount = 0;
            }
            catch (InternalException e) {
                LOG.info(e.getMessage());
                this.myFrameCount = 0;
            }
            catch (Exception e) {
                if (!this.getVirtualMachine().canBeModified()) {
                    LOG.debug(e.getMessage());
                    this.myFrameCount = 0;
                }
                throw e;
            }
        }
        return this.myFrameCount;
    }

    public List<StackFrameProxyImpl> forceFrames() throws JdiProxyException {
        block5: {
            ThreadReference threadRef = this.getThreadReference();
            try {
                this.checkValid();
                if (this.myFrames != null) break block5;
                try {
                    List<StackFrame> frames = threadRef.frames();
                    this.myFrameCount = frames.size();
                    this.myFrames = new ArrayList<StackFrameProxyImpl>(this.myFrameCount);
                    this.myFramesFromBottom.clear();
                    int idx = 0;
                    for (StackFrame frame : frames) {
                        StackFrameProxyImpl frameProxy = new StackFrameProxyImpl(this, frame, this.myFrameCount - idx);
                        this.myFrames.add(frameProxy);
                        this.myFramesFromBottom.addFirst(frameProxy);
                        ++idx;
                    }
                }
                catch (IncompatibleThreadStateException | InternalException e) {
                    throw new JdiProxyException(e.getMessage(), e);
                }
            }
            catch (ObjectCollectedException ignored) {
                return Collections.emptyList();
            }
        }
        return this.myFrames;
    }

    public List<StackFrameProxyImpl> frames() throws JdiProxyException {
        ThreadReference threadRef = this.getThreadReference();
        try {
            this.checkValid();
            if (this.myFrames == null) {
                this.checkFrames(threadRef);
                this.myFrames = new ArrayList<StackFrameProxyImpl>(this.myFramesFromBottom.subList(0, this.frameCount()));
                Collections.reverse(this.myFrames);
            }
        }
        catch (ObjectCollectedException ignored) {
            return Collections.emptyList();
        }
        return this.myFrames;
    }

    private void checkFrames(ThreadReference threadRef) throws JdiProxyException {
        int frameCount = this.frameCount();
        if (this.myFramesFromBottom.size() < frameCount) {
            List<StackFrame> frames;
            try {
                frames = threadRef.frames(0, frameCount - this.myFramesFromBottom.size());
            }
            catch (IncompatibleThreadStateException | InternalException e) {
                throw new JdiProxyException(e.getMessage(), e);
            }
            int index = this.myFramesFromBottom.size() + 1;
            ListIterator<StackFrame> iterator = frames.listIterator(frameCount - this.myFramesFromBottom.size());
            while (iterator.hasPrevious()) {
                this.myFramesFromBottom.add(new StackFrameProxyImpl(this, iterator.previous(), index));
                ++index;
            }
        } else {
            while (this.myFramesFromBottom.size() > frameCount) {
                this.myFramesFromBottom.removeLast();
            }
        }
    }

    @Override
    public StackFrameProxyImpl frame(int i) throws JdiProxyException {
        ThreadReference threadReference = this.getThreadReference();
        try {
            if (!threadReference.isSuspended()) {
                return null;
            }
            this.checkFrames(threadReference);
            int frameCount = this.frameCount();
            if (frameCount == 0) {
                return null;
            }
            return this.myFramesFromBottom.get(frameCount - i - 1);
        }
        catch (ObjectCollectedException | IllegalThreadStateException ignored) {
            return null;
        }
    }

    public void popFrames(StackFrameProxyImpl stackFrame) throws JdiProxyException {
        try {
            this.getThreadReference().popFrames(stackFrame.getStackFrame());
        }
        catch (InvalidStackFrameException | ObjectCollectedException runtimeException) {
        }
        catch (IncompatibleThreadStateException | InternalException e) {
            throw new JdiProxyException(e.getMessage(), e.getCause());
        }
        finally {
            this.clearCaches();
            this.getVirtualMachineProxy().clearCaches();
        }
    }

    public void forceEarlyReturn(Value value) throws ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
        try {
            this.getThreadReference().forceEarlyReturn(value);
        }
        finally {
            this.clearCaches();
            this.getVirtualMachineProxy().clearCaches();
        }
    }

    public void stop(ObjectReference exception) throws InvalidTypeException {
        try {
            this.getThreadReference().stop(exception);
        }
        finally {
            this.clearCaches();
            this.getVirtualMachineProxy().clearCaches();
        }
    }

    public boolean isSuspended() throws ObjectCollectedException {
        try {
            return this.getThreadReference().isSuspended();
        }
        catch (IllegalThreadStateException e) {
            LOG.info(String.valueOf(e));
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
        return false;
    }

    public boolean isAtBreakpoint() {
        try {
            return this.getThreadReference().isAtBreakpoint();
        }
        catch (InternalException e) {
            LOG.info(String.valueOf(e));
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
        return false;
    }

    public boolean isResumeOnHotSwap() {
        if (this.myResumeOnHotSwap == ThreeState.UNSURE) {
            this.myResumeOnHotSwap = ThreeState.fromBoolean(this.name().startsWith("YJPAgent-"));
        }
        return this.myResumeOnHotSwap.toBoolean();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

