/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.utils;

import com.sun.jdi.Location;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageResolution;
import io.ballerina.projects.Project;
import io.ballerina.projects.ResolvedPackageDependency;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import org.ballerinalang.debugadapter.DebugProjectCache;
import org.ballerinalang.debugadapter.utils.LocationInfo;
import org.ballerinalang.debugadapter.utils.SourceResolver;

public class DependencySourceResolver
extends SourceResolver {
    DependencySourceResolver(Project sourceProject, DebugProjectCache projectCache) {
        super(sourceProject, projectCache);
    }

    @Override
    public boolean isSupported(Location location) {
        try {
            LocationInfo locationInfo = new LocationInfo(location);
            if (!locationInfo.isValid()) {
                return false;
            }
            PackageResolution resolution = this.sourceProject.currentPackage().getResolution();
            for (ResolvedPackageDependency packageDependency : resolution.dependencyGraph().getNodes()) {
                Package depPackage = packageDependency.packageInstance();
                if (!depPackage.packageOrg().value().equals(locationInfo.orgName())) continue;
                for (ModuleId moduleId : depPackage.moduleIds()) {
                    if (!depPackage.module(moduleId).moduleName().toString().equals(locationInfo.moduleName())) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Optional<Path> resolve(Location location) {
        try {
            LocationInfo locationInfo = new LocationInfo(location);
            if (!locationInfo.isValid()) {
                return Optional.empty();
            }
            PackageResolution resolution = this.sourceProject.currentPackage().getResolution();
            Collection dependencies = resolution.dependencyGraph().getNodes();
            for (ResolvedPackageDependency dependency : dependencies) {
                Package depPackage = dependency.packageInstance();
                if (!depPackage.packageOrg().value().equals(locationInfo.orgName())) continue;
                for (ModuleId moduleId : depPackage.moduleIds()) {
                    if (!depPackage.module(moduleId).moduleName().toString().equals(locationInfo.moduleName())) continue;
                    Module module = depPackage.module(moduleId);
                    for (DocumentId docId : module.documentIds()) {
                        if (!module.document(docId).name().equals(locationInfo.fileName())) continue;
                        return module.project().documentPath(docId);
                    }
                }
            }
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

