/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.utils;

import com.sun.jdi.Location;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.Project;
import io.ballerina.projects.environment.PackageCache;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.debugadapter.DebugProjectCache;
import org.ballerinalang.debugadapter.utils.DependencySourceResolver;
import org.ballerinalang.debugadapter.utils.LocationInfo;

public class LangLibSourceResolver
extends DependencySourceResolver {
    LangLibSourceResolver(Project sourceProject, DebugProjectCache projectCache) {
        super(sourceProject, projectCache);
    }

    @Override
    public boolean isSupported(Location location) {
        try {
            LocationInfo locationInfo = new LocationInfo(location);
            if (!locationInfo.isValid()) {
                return false;
            }
            PackageCache packageCache = (PackageCache)this.sourceProject.projectEnvironmentContext().environment().getService(PackageCache.class);
            List langLibPackage = packageCache.getPackages(PackageOrg.from((String)locationInfo.orgName()), PackageName.from((String)locationInfo.moduleName()));
            return !langLibPackage.isEmpty();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Optional<Path> resolve(Location location) {
        try {
            LocationInfo locationInfo = new LocationInfo(location);
            if (!locationInfo.isValid()) {
                return Optional.empty();
            }
            PackageCache packageCache = (PackageCache)this.sourceProject.projectEnvironmentContext().environment().getService(PackageCache.class);
            List langLibPackage = packageCache.getPackages(PackageOrg.from((String)locationInfo.orgName()), PackageName.from((String)locationInfo.moduleName()));
            if (langLibPackage.isEmpty()) {
                return Optional.empty();
            }
            for (ModuleId moduleId : ((Package)langLibPackage.getFirst()).moduleIds()) {
                Module module = ((Package)langLibPackage.getFirst()).module(moduleId);
                for (DocumentId docId : module.documentIds()) {
                    if (!module.document(docId).name().equals(locationInfo.fileName())) continue;
                    return module.project().documentPath(docId);
                }
            }
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

