/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.variable;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.ballerinalang.debugadapter.SuspendedContext;
import org.ballerinalang.debugadapter.variable.BVariable;
import org.ballerinalang.debugadapter.variable.JVMValueType;
import org.ballerinalang.debugadapter.variable.VariableUtils;
import org.ballerinalang.debugadapter.variable.types.BArray;
import org.ballerinalang.debugadapter.variable.types.BBoolean;
import org.ballerinalang.debugadapter.variable.types.BByte;
import org.ballerinalang.debugadapter.variable.types.BClientObject;
import org.ballerinalang.debugadapter.variable.types.BDecimal;
import org.ballerinalang.debugadapter.variable.types.BError;
import org.ballerinalang.debugadapter.variable.types.BFloat;
import org.ballerinalang.debugadapter.variable.types.BFunction;
import org.ballerinalang.debugadapter.variable.types.BFuture;
import org.ballerinalang.debugadapter.variable.types.BHandle;
import org.ballerinalang.debugadapter.variable.types.BInt;
import org.ballerinalang.debugadapter.variable.types.BJson;
import org.ballerinalang.debugadapter.variable.types.BMap;
import org.ballerinalang.debugadapter.variable.types.BNil;
import org.ballerinalang.debugadapter.variable.types.BObject;
import org.ballerinalang.debugadapter.variable.types.BRecord;
import org.ballerinalang.debugadapter.variable.types.BRegexp;
import org.ballerinalang.debugadapter.variable.types.BService;
import org.ballerinalang.debugadapter.variable.types.BStream;
import org.ballerinalang.debugadapter.variable.types.BString;
import org.ballerinalang.debugadapter.variable.types.BTable;
import org.ballerinalang.debugadapter.variable.types.BTuple;
import org.ballerinalang.debugadapter.variable.types.BTypeDesc;
import org.ballerinalang.debugadapter.variable.types.BUnknown;
import org.ballerinalang.debugadapter.variable.types.BXmlComment;
import org.ballerinalang.debugadapter.variable.types.BXmlItem;
import org.ballerinalang.debugadapter.variable.types.BXmlItemAttributeMap;
import org.ballerinalang.debugadapter.variable.types.BXmlPi;
import org.ballerinalang.debugadapter.variable.types.BXmlSequence;
import org.ballerinalang.debugadapter.variable.types.BXmlText;

public final class VariableFactory {
    private static final String TYPEDESC_IDENTIFIER = "typedescs.$";

    private VariableFactory() {
    }

    public static BVariable getVariable(SuspendedContext context, Value value) {
        return VariableFactory.getVariable(context, "unknown", value);
    }

    public static BVariable getVariable(SuspendedContext context, String varName, Value value) {
        if (varName == null || varName.isEmpty() || varName.startsWith("$") || varName.equals("__strand")) {
            return null;
        }
        if (value == null) {
            return new BNil(context, varName, null);
        }
        Type valueType = value.type();
        String valueTypeName = valueType.name();
        if (valueTypeName.equals(JVMValueType.INT.getString()) || valueTypeName.equals(JVMValueType.J_INT.getString()) || valueTypeName.equals(JVMValueType.LONG.getString()) || valueTypeName.equals(JVMValueType.J_LONG.getString())) {
            return new BInt(context, varName, value);
        }
        if (valueTypeName.equals(JVMValueType.BOOLEAN.getString()) || valueTypeName.equals(JVMValueType.J_BOOLEAN.getString())) {
            return new BBoolean(context, varName, value);
        }
        if (valueTypeName.equals(JVMValueType.DOUBLE.getString()) || valueTypeName.equals(JVMValueType.J_DOUBLE.getString())) {
            return new BFloat(context, varName, value);
        }
        if (valueTypeName.equals(JVMValueType.BYTE.getString())) {
            return new BByte(context, varName, value);
        }
        if (valueTypeName.equals(JVMValueType.DECIMAL.getString())) {
            return new BDecimal(context, varName, value);
        }
        if (valueTypeName.equals(JVMValueType.BMP_STRING.getString()) || valueTypeName.equals(JVMValueType.NON_BMP_STRING.getString()) || valueTypeName.equals(JVMValueType.J_STRING.getString())) {
            return new BString(context, varName, value);
        }
        if (valueTypeName.contains(JVMValueType.ARRAY_VALUE.getString())) {
            return new BArray(context, varName, value);
        }
        if (valueTypeName.contains(JVMValueType.TUPLE_VALUE.getString())) {
            return new BTuple(context, varName, value);
        }
        if (valueTypeName.contains(JVMValueType.ERROR_VALUE.getString())) {
            return new BError(context, varName, value);
        }
        if (valueTypeName.contains(JVMValueType.TYPEDESC_VALUE.getString()) || valueTypeName.contains(TYPEDESC_IDENTIFIER)) {
            return new BTypeDesc(context, varName, value);
        }
        if (valueTypeName.contains(JVMValueType.TABLE_VALUE.getString())) {
            return new BTable(context, varName, value);
        }
        if (valueTypeName.equals(JVMValueType.FP_VALUE.getString())) {
            return new BFunction(context, varName, value);
        }
        if (valueTypeName.equals(JVMValueType.FUTURE_VALUE.getString())) {
            return new BFuture(context, varName, value);
        }
        if (valueTypeName.equals(JVMValueType.HANDLE_VALUE.getString())) {
            return new BHandle(context, varName, value);
        }
        if (valueTypeName.equals(JVMValueType.STREAM_VALUE.getString())) {
            return new BStream(context, varName, value);
        }
        if (valueTypeName.equals(JVMValueType.REGEXP_VALUE.getString())) {
            return new BRegexp(context, varName, value);
        }
        if (valueTypeName.equals(JVMValueType.XML_TEXT.getString())) {
            return new BXmlText(context, varName, value);
        }
        if (valueTypeName.equals(JVMValueType.XML_COMMENT.getString())) {
            return new BXmlComment(context, varName, value);
        }
        if (valueTypeName.equals(JVMValueType.XML_PI.getString())) {
            return new BXmlPi(context, varName, value);
        }
        if (valueTypeName.equals(JVMValueType.XML_SEQUENCE.getString())) {
            return new BXmlSequence(context, varName, value);
        }
        if (valueTypeName.equals(JVMValueType.XML_ITEM.getString())) {
            return new BXmlItem(context, varName, value);
        }
        if (valueTypeName.equals(JVMValueType.XML_ATTRIB_MAP.getString())) {
            return new BXmlItemAttributeMap(context, varName, value);
        }
        if (valueTypeName.contains(JVMValueType.MAP_VALUE.getString())) {
            if (VariableUtils.isJson(value)) {
                return new BJson(context, varName, value);
            }
            return new BMap(context, varName, value);
        }
        if (value instanceof ObjectReference) {
            if (VariableUtils.isObject(value)) {
                return new BObject(context, varName, value);
            }
            if (VariableUtils.isClientObject(value)) {
                return new BClientObject(context, varName, value);
            }
            if (VariableUtils.isRecord(value)) {
                return new BRecord(context, varName, value);
            }
            if (VariableUtils.isService(value)) {
                return new BService(context, varName, value);
            }
        }
        return new BUnknown(context, varName, value);
    }
}

